/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.io.Serializable;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.Driver;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.parse.AbstractSemanticAnalyzerHook;
import org.apache.hadoop.hive.ql.parse.HiveSemanticAnalyzerHookContext;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestViewEntity {
    private static Driver driver;
    private final String NAME_PREFIX = "TestViewEntity5".toLowerCase();

    @BeforeClass
    public static void onetimeSetup() throws Exception {
        HiveConf conf = new HiveConf(Driver.class);
        conf.setVar(HiveConf.ConfVars.SEMANTIC_ANALYZER_HOOK, CheckInputReadEntity.class.getName());
        HiveConf.setBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_SUPPORT_CONCURRENCY, (boolean)false);
        SessionState.start((HiveConf)conf);
        driver = new Driver(conf);
        driver.init();
    }

    @AfterClass
    public static void cleanUp() throws Exception {
        driver.close();
        driver.destroy();
    }

    @Test
    public void testUnionView() throws Exception {
        String prefix = "tunionview" + this.NAME_PREFIX;
        String tab1 = prefix + "t1";
        String tab2 = prefix + "t2";
        String view1 = prefix + "v1";
        int ret = driver.run("create table " + tab1 + "(id int)").getResponseCode();
        Assert.assertEquals((String)"Checking command success", (long)0L, (long)ret);
        ret = driver.run("create table " + tab2 + "(id int)").getResponseCode();
        Assert.assertEquals((String)"Checking command success", (long)0L, (long)ret);
        ret = driver.run("create view " + view1 + " as select t.id from (select " + tab1 + ".id from " + tab1 + " union all select " + tab2 + ".id from " + tab2 + ") as t").getResponseCode();
        Assert.assertEquals((String)"Checking command success", (long)0L, (long)ret);
        driver.compile("select * from " + view1);
        Assert.assertEquals((Object)("default@" + view1), (Object)CheckInputReadEntity.readEntities[0].getName());
        Assert.assertEquals((Object)("default@" + tab1), (Object)CheckInputReadEntity.readEntities[1].getName());
        Assert.assertFalse((String)"Table is not direct input", (boolean)CheckInputReadEntity.readEntities[1].isDirect());
        Assert.assertEquals((Object)("default@" + view1), (Object)((ReadEntity)CheckInputReadEntity.readEntities[1].getParents().iterator().next()).getName());
        Assert.assertEquals((Object)("default@" + tab2), (Object)CheckInputReadEntity.readEntities[2].getName());
        Assert.assertFalse((String)"Table is not direct input", (boolean)CheckInputReadEntity.readEntities[2].isDirect());
        Assert.assertEquals((Object)("default@" + view1), (Object)((ReadEntity)CheckInputReadEntity.readEntities[2].getParents().iterator().next()).getName());
    }

    @Test
    public void testViewInSubQuery() throws Exception {
        String prefix = "tvsubquery" + this.NAME_PREFIX;
        String tab1 = prefix + "t";
        String view1 = prefix + "v";
        int ret = driver.run("create table " + tab1 + "(id int)").getResponseCode();
        Assert.assertEquals((String)"Checking command success", (long)0L, (long)ret);
        ret = driver.run("create view " + view1 + " as select * from " + tab1).getResponseCode();
        Assert.assertEquals((String)"Checking command success", (long)0L, (long)ret);
        driver.compile("select * from " + view1);
        Assert.assertEquals((Object)("default@" + view1), (Object)CheckInputReadEntity.readEntities[0].getName());
        Assert.assertEquals((Object)("default@" + tab1), (Object)CheckInputReadEntity.readEntities[1].getName());
        Assert.assertFalse((String)"Table is not direct input", (boolean)CheckInputReadEntity.readEntities[1].isDirect());
    }

    public static class CheckInputReadEntity
    extends AbstractSemanticAnalyzerHook {
        public static ReadEntity[] readEntities;

        public void postAnalyze(HiveSemanticAnalyzerHookContext context, List<Task<? extends Serializable>> rootTasks) throws SemanticException {
            readEntities = context.getInputs().toArray(new ReadEntity[0]);
        }
    }
}

