/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf;

import java.sql.Date;
import java.sql.Timestamp;
import junit.framework.TestCase;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFDateDiff;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.JavaStringObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableDateObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableTimestampObjectInspector;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;

public class TestGenericUDFDateDiff
extends TestCase {
    public void testStringToDate() throws HiveException {
        GenericUDFDateDiff udf = new GenericUDFDateDiff();
        JavaStringObjectInspector valueOI1 = PrimitiveObjectInspectorFactory.javaStringObjectInspector;
        JavaStringObjectInspector valueOI2 = PrimitiveObjectInspectorFactory.javaStringObjectInspector;
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI1, valueOI2};
        udf.initialize(arguments);
        GenericUDF.DeferredJavaObject valueObj1 = new GenericUDF.DeferredJavaObject((Object)new Text("2009-07-20"));
        GenericUDF.DeferredJavaObject valueObj2 = new GenericUDF.DeferredJavaObject((Object)new Text("2009-07-22"));
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{valueObj1, valueObj2};
        IntWritable output = udf.evaluate(args);
        TestGenericUDFDateDiff.assertEquals((String)"date_iff() test for STRING failed ", (String)"-2", (String)output.toString());
        args = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject(null), valueObj2};
        TestGenericUDFDateDiff.assertNull((String)"date_add() 1st arg null", (Object)udf.evaluate(args));
        args = new GenericUDF.DeferredObject[]{valueObj1, new GenericUDF.DeferredJavaObject(null)};
        TestGenericUDFDateDiff.assertNull((String)"date_add() 2nd arg null", (Object)udf.evaluate(args));
        args = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject(null), new GenericUDF.DeferredJavaObject(null)};
        TestGenericUDFDateDiff.assertNull((String)"date_add() both args null", (Object)udf.evaluate(args));
    }

    public void testTimestampToDate() throws HiveException {
        GenericUDFDateDiff udf = new GenericUDFDateDiff();
        WritableTimestampObjectInspector valueOI1 = PrimitiveObjectInspectorFactory.writableTimestampObjectInspector;
        WritableTimestampObjectInspector valueOI2 = PrimitiveObjectInspectorFactory.writableTimestampObjectInspector;
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI1, valueOI2};
        udf.initialize(arguments);
        GenericUDF.DeferredJavaObject valueObj1 = new GenericUDF.DeferredJavaObject((Object)new TimestampWritable(new Timestamp(109, 6, 20, 0, 0, 0, 0)));
        GenericUDF.DeferredJavaObject valueObj2 = new GenericUDF.DeferredJavaObject((Object)new TimestampWritable(new Timestamp(109, 6, 17, 0, 0, 0, 0)));
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{valueObj1, valueObj2};
        IntWritable output = udf.evaluate(args);
        TestGenericUDFDateDiff.assertEquals((String)"datediff() test for TIMESTAMP failed ", (String)"3", (String)output.toString());
        args = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject(null), valueObj2};
        TestGenericUDFDateDiff.assertNull((String)"date_add() 1st arg null", (Object)udf.evaluate(args));
        args = new GenericUDF.DeferredObject[]{valueObj1, new GenericUDF.DeferredJavaObject(null)};
        TestGenericUDFDateDiff.assertNull((String)"date_add() 2nd arg null", (Object)udf.evaluate(args));
        args = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject(null), new GenericUDF.DeferredJavaObject(null)};
        TestGenericUDFDateDiff.assertNull((String)"date_add() both args null", (Object)udf.evaluate(args));
    }

    public void testDateWritablepToDate() throws HiveException {
        GenericUDFDateDiff udf = new GenericUDFDateDiff();
        WritableDateObjectInspector valueOI1 = PrimitiveObjectInspectorFactory.writableDateObjectInspector;
        WritableDateObjectInspector valueOI2 = PrimitiveObjectInspectorFactory.writableDateObjectInspector;
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI1, valueOI2};
        udf.initialize(arguments);
        GenericUDF.DeferredJavaObject valueObj1 = new GenericUDF.DeferredJavaObject((Object)new DateWritable(new Date(109, 6, 20)));
        GenericUDF.DeferredJavaObject valueObj2 = new GenericUDF.DeferredJavaObject((Object)new DateWritable(new Date(109, 6, 10)));
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{valueObj1, valueObj2};
        IntWritable output = udf.evaluate(args);
        TestGenericUDFDateDiff.assertEquals((String)"datediff() test for DATEWRITABLE failed ", (String)"10", (String)output.toString());
        args = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject(null), valueObj2};
        TestGenericUDFDateDiff.assertNull((String)"date_add() 1st arg null", (Object)udf.evaluate(args));
        args = new GenericUDF.DeferredObject[]{valueObj1, new GenericUDF.DeferredJavaObject(null)};
        TestGenericUDFDateDiff.assertNull((String)"date_add() 2nd arg null", (Object)udf.evaluate(args));
        args = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject(null), new GenericUDF.DeferredJavaObject(null)};
        TestGenericUDFDateDiff.assertNull((String)"date_add() both args null", (Object)udf.evaluate(args));
    }
}

