/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.sql.Date;
import java.sql.Timestamp;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.common.type.HiveIntervalDayTime;
import org.apache.hadoop.hive.common.type.HiveIntervalYearMonth;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.udf.generic.AbstractTestGenericUDFOPNumeric;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPMinus;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.io.HiveIntervalDayTimeWritable;
import org.apache.hadoop.hive.serde2.io.HiveIntervalYearMonthWritable;
import org.apache.hadoop.hive.serde2.io.HiveVarcharWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.junit.Assert;
import org.junit.Test;

public class TestGenericUDFOPMinus
extends AbstractTestGenericUDFOPNumeric {
    @Test
    public void testByteMinusShort() throws HiveException {
        GenericUDFOPMinus udf = new GenericUDFOPMinus();
        ByteWritable left = new ByteWritable(4);
        ShortWritable right = new ShortWritable(6);
        ObjectInspector[] inputOIs = new ObjectInspector[]{PrimitiveObjectInspectorFactory.writableByteObjectInspector, PrimitiveObjectInspectorFactory.writableShortObjectInspector};
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject((Object)left), new GenericUDF.DeferredJavaObject((Object)right)};
        PrimitiveObjectInspector oi = (PrimitiveObjectInspector)udf.initialize(inputOIs);
        Assert.assertEquals((Object)oi.getTypeInfo(), (Object)TypeInfoFactory.shortTypeInfo);
        ShortWritable res = (ShortWritable)udf.evaluate(args);
        Assert.assertEquals((long)-2L, (long)res.get());
    }

    @Test
    public void testVarcharMinusInt() throws HiveException {
        GenericUDFOPMinus udf = new GenericUDFOPMinus();
        HiveVarcharWritable left = new HiveVarcharWritable();
        left.set("123");
        IntWritable right = new IntWritable(456);
        ObjectInspector[] inputOIs = new ObjectInspector[]{PrimitiveObjectInspectorFactory.writableHiveVarcharObjectInspector, PrimitiveObjectInspectorFactory.writableIntObjectInspector};
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject((Object)left), new GenericUDF.DeferredJavaObject((Object)right)};
        PrimitiveObjectInspector oi = (PrimitiveObjectInspector)udf.initialize(inputOIs);
        Assert.assertEquals((Object)oi.getTypeInfo(), (Object)TypeInfoFactory.doubleTypeInfo);
        DoubleWritable res = (DoubleWritable)udf.evaluate(args);
        Assert.assertEquals((Object)new Double(-333.0), (Object)new Double(res.get()));
    }

    @Test
    public void testDoubleMinusLong() throws HiveException {
        GenericUDFOPMinus udf = new GenericUDFOPMinus();
        DoubleWritable left = new DoubleWritable(4.5);
        LongWritable right = new LongWritable(10L);
        ObjectInspector[] inputOIs = new ObjectInspector[]{PrimitiveObjectInspectorFactory.writableDoubleObjectInspector, PrimitiveObjectInspectorFactory.writableLongObjectInspector};
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject((Object)left), new GenericUDF.DeferredJavaObject((Object)right)};
        PrimitiveObjectInspector oi = (PrimitiveObjectInspector)udf.initialize(inputOIs);
        Assert.assertEquals((Object)TypeInfoFactory.doubleTypeInfo, (Object)oi.getTypeInfo());
        DoubleWritable res = (DoubleWritable)udf.evaluate(args);
        Assert.assertEquals((Object)new Double(-5.5), (Object)new Double(res.get()));
    }

    @Test
    public void testLongMinusDecimal() throws HiveException {
        GenericUDFOPMinus udf = new GenericUDFOPMinus();
        LongWritable left = new LongWritable(104L);
        HiveDecimalWritable right = new HiveDecimalWritable(HiveDecimal.create((String)"234.97"));
        ObjectInspector[] inputOIs = new ObjectInspector[]{PrimitiveObjectInspectorFactory.writableLongObjectInspector, PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.getDecimalTypeInfo((int)9, (int)4))};
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject((Object)left), new GenericUDF.DeferredJavaObject((Object)right)};
        PrimitiveObjectInspector oi = (PrimitiveObjectInspector)udf.initialize(inputOIs);
        Assert.assertEquals((Object)TypeInfoFactory.getDecimalTypeInfo((int)24, (int)4), (Object)oi.getTypeInfo());
        HiveDecimalWritable res = (HiveDecimalWritable)udf.evaluate(args);
        Assert.assertEquals((Object)HiveDecimal.create((String)"-130.97"), (Object)res.getHiveDecimal());
    }

    @Test
    public void testFloatMinusFloat() throws HiveException {
        GenericUDFOPMinus udf = new GenericUDFOPMinus();
        FloatWritable f1 = new FloatWritable(4.5f);
        FloatWritable f2 = new FloatWritable(0.0f);
        ObjectInspector[] inputOIs = new ObjectInspector[]{PrimitiveObjectInspectorFactory.writableFloatObjectInspector, PrimitiveObjectInspectorFactory.writableFloatObjectInspector};
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject((Object)f1), new GenericUDF.DeferredJavaObject((Object)f2)};
        PrimitiveObjectInspector oi = (PrimitiveObjectInspector)udf.initialize(inputOIs);
        Assert.assertEquals((Object)oi.getTypeInfo(), (Object)TypeInfoFactory.floatTypeInfo);
        FloatWritable res = (FloatWritable)udf.evaluate(args);
        Assert.assertEquals((Object)new Float(4.5), (Object)new Float(res.get()));
    }

    @Test
    public void testDouleMinusDecimal() throws HiveException {
        GenericUDFOPMinus udf = new GenericUDFOPMinus();
        DoubleWritable left = new DoubleWritable(74.52);
        HiveDecimalWritable right = new HiveDecimalWritable(HiveDecimal.create((String)"234.97"));
        ObjectInspector[] inputOIs = new ObjectInspector[]{PrimitiveObjectInspectorFactory.writableDoubleObjectInspector, PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.getDecimalTypeInfo((int)5, (int)2))};
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject((Object)left), new GenericUDF.DeferredJavaObject((Object)right)};
        PrimitiveObjectInspector oi = (PrimitiveObjectInspector)udf.initialize(inputOIs);
        Assert.assertEquals((Object)TypeInfoFactory.doubleTypeInfo, (Object)oi.getTypeInfo());
        DoubleWritable res = (DoubleWritable)udf.evaluate(args);
        Assert.assertEquals((Object)new Double(-160.45), (Object)new Double(res.get()));
    }

    @Test
    public void testDecimalMinusDecimal() throws HiveException {
        GenericUDFOPMinus udf = new GenericUDFOPMinus();
        HiveDecimalWritable left = new HiveDecimalWritable(HiveDecimal.create((String)"14.5"));
        HiveDecimalWritable right = new HiveDecimalWritable(HiveDecimal.create((String)"234.97"));
        ObjectInspector[] inputOIs = new ObjectInspector[]{PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.getDecimalTypeInfo((int)3, (int)1)), PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.getDecimalTypeInfo((int)5, (int)2))};
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject((Object)left), new GenericUDF.DeferredJavaObject((Object)right)};
        PrimitiveObjectInspector oi = (PrimitiveObjectInspector)udf.initialize(inputOIs);
        Assert.assertEquals((Object)TypeInfoFactory.getDecimalTypeInfo((int)6, (int)2), (Object)oi.getTypeInfo());
        HiveDecimalWritable res = (HiveDecimalWritable)udf.evaluate(args);
        Assert.assertEquals((Object)HiveDecimal.create((String)"-220.47"), (Object)res.getHiveDecimal());
    }

    @Test
    public void testDecimalMinusDecimalSameParams() throws HiveException {
        GenericUDFOPMinus udf = new GenericUDFOPMinus();
        ObjectInspector[] inputOIs = new ObjectInspector[]{PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.getDecimalTypeInfo((int)5, (int)2)), PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.getDecimalTypeInfo((int)5, (int)2))};
        PrimitiveObjectInspector oi = (PrimitiveObjectInspector)udf.initialize(inputOIs);
        Assert.assertEquals((Object)TypeInfoFactory.getDecimalTypeInfo((int)6, (int)2), (Object)oi.getTypeInfo());
    }

    @Test
    public void testReturnTypeBackwardCompat() throws Exception {
        SessionState.get().getConf().setVar(HiveConf.ConfVars.HIVE_COMPAT, "0.12");
        this.verifyReturnType((GenericUDF)new GenericUDFOPMinus(), "int", "int", "int");
        this.verifyReturnType((GenericUDF)new GenericUDFOPMinus(), "int", "float", "float");
        this.verifyReturnType((GenericUDF)new GenericUDFOPMinus(), "int", "double", "double");
        this.verifyReturnType((GenericUDF)new GenericUDFOPMinus(), "int", "decimal(10,2)", "decimal(13,2)");
        this.verifyReturnType((GenericUDF)new GenericUDFOPMinus(), "float", "float", "float");
        this.verifyReturnType((GenericUDF)new GenericUDFOPMinus(), "float", "double", "double");
        this.verifyReturnType((GenericUDF)new GenericUDFOPMinus(), "float", "decimal(10,2)", "double");
        this.verifyReturnType((GenericUDF)new GenericUDFOPMinus(), "double", "double", "double");
        this.verifyReturnType((GenericUDF)new GenericUDFOPMinus(), "double", "decimal(10,2)", "double");
        this.verifyReturnType((GenericUDF)new GenericUDFOPMinus(), "decimal(10,2)", "decimal(10,2)", "decimal(11,2)");
        SessionState.get().getConf().setVar(HiveConf.ConfVars.HIVE_COMPAT, "latest");
    }

    @Test
    public void testReturnTypeAnsiSql() throws Exception {
        SessionState.get().getConf().setVar(HiveConf.ConfVars.HIVE_COMPAT, "latest");
        this.verifyReturnType((GenericUDF)new GenericUDFOPMinus(), "int", "int", "int");
        this.verifyReturnType((GenericUDF)new GenericUDFOPMinus(), "int", "float", "float");
        this.verifyReturnType((GenericUDF)new GenericUDFOPMinus(), "int", "double", "double");
        this.verifyReturnType((GenericUDF)new GenericUDFOPMinus(), "int", "decimal(10,2)", "decimal(13,2)");
        this.verifyReturnType((GenericUDF)new GenericUDFOPMinus(), "float", "float", "float");
        this.verifyReturnType((GenericUDF)new GenericUDFOPMinus(), "float", "double", "double");
        this.verifyReturnType((GenericUDF)new GenericUDFOPMinus(), "float", "decimal(10,2)", "double");
        this.verifyReturnType((GenericUDF)new GenericUDFOPMinus(), "double", "double", "double");
        this.verifyReturnType((GenericUDF)new GenericUDFOPMinus(), "double", "decimal(10,2)", "double");
        this.verifyReturnType((GenericUDF)new GenericUDFOPMinus(), "decimal(10,2)", "decimal(10,2)", "decimal(11,2)");
    }

    @Test
    public void testIntervalYearMonthMinusIntervalYearMonth() throws Exception {
        GenericUDFOPMinus udf = new GenericUDFOPMinus();
        HiveIntervalYearMonthWritable left = new HiveIntervalYearMonthWritable(HiveIntervalYearMonth.valueOf((String)"3-1"));
        HiveIntervalYearMonthWritable right = new HiveIntervalYearMonthWritable(HiveIntervalYearMonth.valueOf((String)"1-2"));
        ObjectInspector[] inputOIs = new ObjectInspector[]{PrimitiveObjectInspectorFactory.writableHiveIntervalYearMonthObjectInspector, PrimitiveObjectInspectorFactory.writableHiveIntervalYearMonthObjectInspector};
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject((Object)left), new GenericUDF.DeferredJavaObject((Object)right)};
        PrimitiveObjectInspector oi = (PrimitiveObjectInspector)udf.initialize(inputOIs);
        Assert.assertEquals((Object)TypeInfoFactory.intervalYearMonthTypeInfo, (Object)oi.getTypeInfo());
        HiveIntervalYearMonthWritable res = (HiveIntervalYearMonthWritable)udf.evaluate(args);
        Assert.assertEquals((Object)HiveIntervalYearMonth.valueOf((String)"1-11"), (Object)res.getHiveIntervalYearMonth());
    }

    @Test
    public void testDateMinusIntervalYearMonth() throws Exception {
        GenericUDFOPMinus udf = new GenericUDFOPMinus();
        DateWritable left = new DateWritable(Date.valueOf("2004-02-15"));
        HiveIntervalYearMonthWritable right = new HiveIntervalYearMonthWritable(HiveIntervalYearMonth.valueOf((String)"2-8"));
        ObjectInspector[] inputOIs = new ObjectInspector[]{PrimitiveObjectInspectorFactory.writableDateObjectInspector, PrimitiveObjectInspectorFactory.writableHiveIntervalYearMonthObjectInspector};
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject((Object)left), new GenericUDF.DeferredJavaObject((Object)right)};
        PrimitiveObjectInspector oi = (PrimitiveObjectInspector)udf.initialize(inputOIs);
        Assert.assertEquals((Object)TypeInfoFactory.dateTypeInfo, (Object)oi.getTypeInfo());
        DateWritable res = (DateWritable)udf.evaluate(args);
        Assert.assertEquals((Object)Date.valueOf("2001-06-15"), (Object)res.get());
    }

    @Test
    public void testTimestampMinusIntervalYearMonth() throws Exception {
        GenericUDFOPMinus udf = new GenericUDFOPMinus();
        TimestampWritable left = new TimestampWritable(Timestamp.valueOf("2004-01-15 01:02:03.123456789"));
        HiveIntervalYearMonthWritable right = new HiveIntervalYearMonthWritable(HiveIntervalYearMonth.valueOf((String)"2-2"));
        ObjectInspector[] inputOIs = new ObjectInspector[]{PrimitiveObjectInspectorFactory.writableTimestampObjectInspector, PrimitiveObjectInspectorFactory.writableHiveIntervalYearMonthObjectInspector};
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject((Object)left), new GenericUDF.DeferredJavaObject((Object)right)};
        PrimitiveObjectInspector oi = (PrimitiveObjectInspector)udf.initialize(inputOIs);
        Assert.assertEquals((Object)TypeInfoFactory.timestampTypeInfo, (Object)oi.getTypeInfo());
        TimestampWritable res = (TimestampWritable)udf.evaluate(args);
        Assert.assertEquals((Object)Timestamp.valueOf("2001-11-15 01:02:03.123456789"), (Object)res.getTimestamp());
    }

    @Test
    public void testIntervalDayTimeMinusIntervalDayTime() throws Exception {
        GenericUDFOPMinus udf = new GenericUDFOPMinus();
        HiveIntervalDayTimeWritable left = new HiveIntervalDayTimeWritable(HiveIntervalDayTime.valueOf((String)"2 2:3:4.567"));
        HiveIntervalDayTimeWritable right = new HiveIntervalDayTimeWritable(HiveIntervalDayTime.valueOf((String)"1 2:3:4"));
        ObjectInspector[] inputOIs = new ObjectInspector[]{PrimitiveObjectInspectorFactory.writableHiveIntervalDayTimeObjectInspector, PrimitiveObjectInspectorFactory.writableHiveIntervalDayTimeObjectInspector};
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject((Object)left), new GenericUDF.DeferredJavaObject((Object)right)};
        PrimitiveObjectInspector oi = (PrimitiveObjectInspector)udf.initialize(inputOIs);
        Assert.assertEquals((Object)TypeInfoFactory.intervalDayTimeTypeInfo, (Object)oi.getTypeInfo());
        HiveIntervalDayTimeWritable res = (HiveIntervalDayTimeWritable)udf.evaluate(args);
        Assert.assertEquals((Object)HiveIntervalDayTime.valueOf((String)"1 0:0:0.567"), (Object)res.getHiveIntervalDayTime());
    }

    @Test
    public void testTimestampMinusIntervalDayTime() throws Exception {
        GenericUDFOPMinus udf = new GenericUDFOPMinus();
        TimestampWritable left = new TimestampWritable(Timestamp.valueOf("2001-01-02 2:3:4.567"));
        HiveIntervalDayTimeWritable right = new HiveIntervalDayTimeWritable(HiveIntervalDayTime.valueOf((String)"1 2:3:4.567"));
        ObjectInspector[] inputOIs = new ObjectInspector[]{PrimitiveObjectInspectorFactory.writableTimestampObjectInspector, PrimitiveObjectInspectorFactory.writableHiveIntervalDayTimeObjectInspector};
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject((Object)left), new GenericUDF.DeferredJavaObject((Object)right)};
        PrimitiveObjectInspector oi = (PrimitiveObjectInspector)udf.initialize(inputOIs);
        Assert.assertEquals((Object)TypeInfoFactory.timestampTypeInfo, (Object)oi.getTypeInfo());
        TimestampWritable res = (TimestampWritable)udf.evaluate(args);
        Assert.assertEquals((Object)Timestamp.valueOf("2001-01-01 00:00:00"), (Object)res.getTimestamp());
    }

    @Test
    public void testDateMinusIntervalDayTime() throws Exception {
        GenericUDFOPMinus udf = new GenericUDFOPMinus();
        DateWritable left = new DateWritable(Date.valueOf("2001-01-01"));
        HiveIntervalDayTimeWritable right = new HiveIntervalDayTimeWritable(HiveIntervalDayTime.valueOf((String)"1 0:0:0.555"));
        ObjectInspector[] inputOIs = new ObjectInspector[]{PrimitiveObjectInspectorFactory.writableDateObjectInspector, PrimitiveObjectInspectorFactory.writableHiveIntervalDayTimeObjectInspector};
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject((Object)left), new GenericUDF.DeferredJavaObject((Object)right)};
        PrimitiveObjectInspector oi = (PrimitiveObjectInspector)udf.initialize(inputOIs);
        Assert.assertEquals((Object)TypeInfoFactory.timestampTypeInfo, (Object)oi.getTypeInfo());
        TimestampWritable res = (TimestampWritable)udf.evaluate(args);
        Assert.assertEquals((Object)Timestamp.valueOf("2000-12-30 23:59:59.445"), (Object)res.getTimestamp());
    }
}

