/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.util.ArrayList;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;

@Description(name="map_values", value="_FUNC_(map) - Returns an unordered array containing the values of the input map.")
public class GenericUDFMapValues
extends GenericUDF {
    private transient MapObjectInspector mapOI;
    private final ArrayList<Object> retArray = new ArrayList();

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length != 1) {
            throw new UDFArgumentLengthException("The function MAP_VALUES only accepts 1 argument.");
        }
        if (!(arguments[0] instanceof MapObjectInspector)) {
            throw new UDFArgumentTypeException(0, "\"" + ObjectInspector.Category.MAP.toString().toLowerCase() + "\" is expected at function MAP_VALUES, but \"" + arguments[0].getTypeName() + "\" is found");
        }
        this.mapOI = (MapObjectInspector)arguments[0];
        ObjectInspector mapValueOI = this.mapOI.getMapValueObjectInspector();
        return ObjectInspectorFactory.getStandardListObjectInspector(mapValueOI);
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        this.retArray.clear();
        Object mapObj = arguments[0].get();
        this.retArray.addAll(this.mapOI.getMap(mapObj).values());
        return this.retArray;
    }

    @Override
    public String getDisplayString(String[] children) {
        assert (children.length == 1);
        return this.getStandardDisplayString("map_values", children);
    }
}

