/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import java.net.InetAddress;
import java.net.UnknownHostException;
import junit.framework.Assert;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.HiveMetaStore;
import org.apache.hadoop.hive.metastore.MetaStoreEventListener;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.events.AddPartitionEvent;
import org.apache.hadoop.hive.metastore.events.AlterPartitionEvent;
import org.apache.hadoop.hive.metastore.events.AlterTableEvent;
import org.apache.hadoop.hive.metastore.events.CreateDatabaseEvent;
import org.apache.hadoop.hive.metastore.events.CreateTableEvent;
import org.apache.hadoop.hive.metastore.events.DropDatabaseEvent;
import org.apache.hadoop.hive.metastore.events.DropPartitionEvent;
import org.apache.hadoop.hive.metastore.events.DropTableEvent;
import org.apache.hadoop.hive.metastore.events.LoadPartitionDoneEvent;

public class IpAddressListener
extends MetaStoreEventListener {
    private static final String LOCAL_HOST = "localhost";

    public IpAddressListener(Configuration config) {
        super(config);
    }

    private void checkIpAddress() {
        try {
            String localhostIp = InetAddress.getByName(LOCAL_HOST).getHostAddress();
            Assert.assertEquals((String)localhostIp, (String)HiveMetaStore.HMSHandler.getIpAddress());
        }
        catch (UnknownHostException e) {
            Assert.assertTrue((String)("InetAddress.getLocalHost threw an exception: " + e.getMessage()), (boolean)false);
        }
    }

    public void onAddPartition(AddPartitionEvent partition) throws MetaException {
        this.checkIpAddress();
    }

    public void onCreateDatabase(CreateDatabaseEvent db) throws MetaException {
        this.checkIpAddress();
    }

    public void onCreateTable(CreateTableEvent table) throws MetaException {
        this.checkIpAddress();
    }

    public void onDropDatabase(DropDatabaseEvent db) throws MetaException {
        this.checkIpAddress();
    }

    public void onDropPartition(DropPartitionEvent partition) throws MetaException {
        this.checkIpAddress();
    }

    public void onDropTable(DropTableEvent table) throws MetaException {
        this.checkIpAddress();
    }

    public void onAlterTable(AlterTableEvent event) throws MetaException {
        this.checkIpAddress();
    }

    public void onAlterPartition(AlterPartitionEvent event) throws MetaException {
        this.checkIpAddress();
    }

    public void onLoadPartitionDone(LoadPartitionDoneEvent partEvent) throws MetaException {
        this.checkIpAddress();
    }
}

