/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaStore;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.MockPartitionExpressionForMetastore;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.util.StringUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestHiveMetaStoreTimeout {
    protected static HiveMetaStoreClient client;
    protected static HiveConf hiveConf;
    protected static Warehouse warehouse;

    @BeforeClass
    public static void setUp() throws Exception {
        HiveMetaStore.TEST_TIMEOUT_ENABLED = true;
        hiveConf = new HiveConf(TestHiveMetaStoreTimeout.class);
        hiveConf.setBoolean(HiveConf.ConfVars.HIVE_WAREHOUSE_SUBDIR_INHERIT_PERMS.varname, true);
        hiveConf.set(HiveConf.ConfVars.METASTORE_EXPRESSION_PROXY_CLASS.varname, MockPartitionExpressionForMetastore.class.getCanonicalName());
        hiveConf.setTimeVar(HiveConf.ConfVars.METASTORE_CLIENT_SOCKET_TIMEOUT, 10000L, TimeUnit.MILLISECONDS);
        warehouse = new Warehouse((Configuration)hiveConf);
        try {
            client = new HiveMetaStoreClient(hiveConf, null);
        }
        catch (Throwable e) {
            System.err.println("Unable to open the metastore");
            System.err.println(StringUtils.stringifyException((Throwable)e));
            throw e;
        }
    }

    @AfterClass
    public static void tearDown() throws Exception {
        HiveMetaStore.TEST_TIMEOUT_ENABLED = false;
        try {
            client.close();
        }
        catch (Throwable e) {
            System.err.println("Unable to close metastore");
            System.err.println(StringUtils.stringifyException((Throwable)e));
            throw e;
        }
    }

    @Test
    public void testNoTimeout() throws Exception {
        HiveMetaStore.TEST_TIMEOUT_VALUE = 5000L;
        String dbName = "db";
        client.dropDatabase(dbName, true, true);
        Database db = new Database();
        db.setName(dbName);
        try {
            client.createDatabase(db);
        }
        catch (MetaException e) {
            Assert.fail((String)("should not throw timeout exception: " + e.getMessage()));
        }
        client.dropDatabase(dbName, true, true);
    }

    @Test
    public void testTimeout() throws Exception {
        HiveMetaStore.TEST_TIMEOUT_VALUE = 15000L;
        String dbName = "db";
        client.dropDatabase(dbName, true, true);
        Database db = new Database();
        db.setName(dbName);
        try {
            client.createDatabase(db);
            Assert.fail((String)"should throw timeout exception.");
        }
        catch (MetaException e) {
            Assert.assertTrue((String)"unexpected MetaException", (boolean)e.getMessage().contains("Timeout when executing method: create_database"));
        }
        HiveMetaStore.TEST_TIMEOUT_VALUE = 5000L;
    }

    @Test
    public void testResetTimeout() throws Exception {
        HiveMetaStore.TEST_TIMEOUT_VALUE = 5000L;
        String dbName = "db";
        client.dropDatabase(dbName, true, true);
        Database db = new Database();
        db.setName(dbName);
        try {
            client.createDatabase(db);
        }
        catch (MetaException e) {
            Assert.fail((String)("should not throw timeout exception: " + e.getMessage()));
        }
        client.dropDatabase(dbName, true, true);
        client.setMetaConf(HiveConf.ConfVars.METASTORE_CLIENT_SOCKET_TIMEOUT.varname, "3s");
        try {
            client.createDatabase(db);
            Assert.fail((String)"should throw timeout exception.");
        }
        catch (MetaException e) {
            Assert.assertTrue((String)"unexpected MetaException", (boolean)e.getMessage().contains("Timeout when executing method: create_database"));
        }
        client.dropDatabase(dbName, true, true);
        client.setMetaConf(HiveConf.ConfVars.METASTORE_CLIENT_SOCKET_TIMEOUT.varname, "10s");
    }
}

