/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.txn;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import junit.framework.Assert;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.AbortTxnRequest;
import org.apache.hadoop.hive.metastore.api.CheckLockRequest;
import org.apache.hadoop.hive.metastore.api.CommitTxnRequest;
import org.apache.hadoop.hive.metastore.api.CompactionRequest;
import org.apache.hadoop.hive.metastore.api.CompactionType;
import org.apache.hadoop.hive.metastore.api.GetOpenTxnsInfoResponse;
import org.apache.hadoop.hive.metastore.api.GetOpenTxnsResponse;
import org.apache.hadoop.hive.metastore.api.HeartbeatRequest;
import org.apache.hadoop.hive.metastore.api.HeartbeatTxnRangeRequest;
import org.apache.hadoop.hive.metastore.api.HeartbeatTxnRangeResponse;
import org.apache.hadoop.hive.metastore.api.LockComponent;
import org.apache.hadoop.hive.metastore.api.LockLevel;
import org.apache.hadoop.hive.metastore.api.LockRequest;
import org.apache.hadoop.hive.metastore.api.LockResponse;
import org.apache.hadoop.hive.metastore.api.LockState;
import org.apache.hadoop.hive.metastore.api.LockType;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchLockException;
import org.apache.hadoop.hive.metastore.api.NoSuchTxnException;
import org.apache.hadoop.hive.metastore.api.OpenTxnRequest;
import org.apache.hadoop.hive.metastore.api.OpenTxnsResponse;
import org.apache.hadoop.hive.metastore.api.ShowCompactRequest;
import org.apache.hadoop.hive.metastore.api.ShowCompactResponse;
import org.apache.hadoop.hive.metastore.api.ShowCompactResponseElement;
import org.apache.hadoop.hive.metastore.api.ShowLocksRequest;
import org.apache.hadoop.hive.metastore.api.ShowLocksResponse;
import org.apache.hadoop.hive.metastore.api.ShowLocksResponseElement;
import org.apache.hadoop.hive.metastore.api.TxnAbortedException;
import org.apache.hadoop.hive.metastore.api.TxnInfo;
import org.apache.hadoop.hive.metastore.api.TxnOpenException;
import org.apache.hadoop.hive.metastore.api.TxnState;
import org.apache.hadoop.hive.metastore.api.UnlockRequest;
import org.apache.hadoop.hive.metastore.txn.TxnDbUtil;
import org.apache.hadoop.hive.metastore.txn.TxnHandler;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.junit.After;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class TestTxnHandler {
    private static final String CLASS_NAME = TxnHandler.class.getName();
    private static final Log LOG = LogFactory.getLog((String)CLASS_NAME);
    private HiveConf conf = new HiveConf();
    private TxnHandler txnHandler;

    public TestTxnHandler() throws Exception {
        TxnDbUtil.setConfValues((HiveConf)this.conf);
        LogManager.getLogger((String)TxnHandler.class.getName()).setLevel(Level.DEBUG);
        this.tearDown();
    }

    @Test
    public void testValidTxnsEmpty() throws Exception {
        GetOpenTxnsInfoResponse txnsInfo = this.txnHandler.getOpenTxnsInfo();
        Assert.assertEquals((long)0L, (long)txnsInfo.getTxn_high_water_mark());
        Assert.assertTrue((boolean)txnsInfo.getOpen_txns().isEmpty());
        GetOpenTxnsResponse txns = this.txnHandler.getOpenTxns();
        Assert.assertEquals((long)0L, (long)txns.getTxn_high_water_mark());
        Assert.assertTrue((boolean)txns.getOpen_txns().isEmpty());
    }

    @Test
    public void testOpenTxn() throws Exception {
        long first = this.openTxn();
        Assert.assertEquals((long)1L, (long)first);
        long second = this.openTxn();
        Assert.assertEquals((long)2L, (long)second);
        GetOpenTxnsInfoResponse txnsInfo = this.txnHandler.getOpenTxnsInfo();
        Assert.assertEquals((long)2L, (long)txnsInfo.getTxn_high_water_mark());
        Assert.assertEquals((int)2, (int)txnsInfo.getOpen_txns().size());
        Assert.assertEquals((long)1L, (long)((TxnInfo)txnsInfo.getOpen_txns().get(0)).getId());
        Assert.assertEquals((Object)TxnState.OPEN, (Object)((TxnInfo)txnsInfo.getOpen_txns().get(0)).getState());
        Assert.assertEquals((long)2L, (long)((TxnInfo)txnsInfo.getOpen_txns().get(1)).getId());
        Assert.assertEquals((Object)TxnState.OPEN, (Object)((TxnInfo)txnsInfo.getOpen_txns().get(1)).getState());
        Assert.assertEquals((String)"me", (String)((TxnInfo)txnsInfo.getOpen_txns().get(1)).getUser());
        Assert.assertEquals((String)"localhost", (String)((TxnInfo)txnsInfo.getOpen_txns().get(1)).getHostname());
        GetOpenTxnsResponse txns = this.txnHandler.getOpenTxns();
        Assert.assertEquals((long)2L, (long)txns.getTxn_high_water_mark());
        Assert.assertEquals((int)2, (int)txns.getOpen_txns().size());
        boolean[] saw = new boolean[3];
        for (int i = 0; i < saw.length; ++i) {
            saw[i] = false;
        }
        for (Long tid : txns.getOpen_txns()) {
            saw[tid.intValue()] = true;
        }
        for (int i = 1; i < saw.length; ++i) {
            Assert.assertTrue((boolean)saw[i]);
        }
    }

    @Test
    public void testAbortTxn() throws Exception {
        OpenTxnsResponse openedTxns = this.txnHandler.openTxns(new OpenTxnRequest(2, "me", "localhost"));
        List txnList = openedTxns.getTxn_ids();
        long first = (Long)txnList.get(0);
        Assert.assertEquals((long)1L, (long)first);
        long second = (Long)txnList.get(1);
        Assert.assertEquals((long)2L, (long)second);
        this.txnHandler.abortTxn(new AbortTxnRequest(1L));
        GetOpenTxnsInfoResponse txnsInfo = this.txnHandler.getOpenTxnsInfo();
        Assert.assertEquals((long)2L, (long)txnsInfo.getTxn_high_water_mark());
        Assert.assertEquals((int)2, (int)txnsInfo.getOpen_txns().size());
        Assert.assertEquals((long)1L, (long)((TxnInfo)txnsInfo.getOpen_txns().get(0)).getId());
        Assert.assertEquals((Object)TxnState.ABORTED, (Object)((TxnInfo)txnsInfo.getOpen_txns().get(0)).getState());
        Assert.assertEquals((long)2L, (long)((TxnInfo)txnsInfo.getOpen_txns().get(1)).getId());
        Assert.assertEquals((Object)TxnState.OPEN, (Object)((TxnInfo)txnsInfo.getOpen_txns().get(1)).getState());
        GetOpenTxnsResponse txns = this.txnHandler.getOpenTxns();
        Assert.assertEquals((long)2L, (long)txns.getTxn_high_water_mark());
        Assert.assertEquals((int)2, (int)txns.getOpen_txns().size());
        boolean[] saw = new boolean[3];
        for (int i = 0; i < saw.length; ++i) {
            saw[i] = false;
        }
        for (Long tid : txns.getOpen_txns()) {
            saw[tid.intValue()] = true;
        }
        for (int i = 1; i < saw.length; ++i) {
            Assert.assertTrue((boolean)saw[i]);
        }
    }

    @Test
    public void testAbortInvalidTxn() throws Exception {
        boolean caught = false;
        try {
            this.txnHandler.abortTxn(new AbortTxnRequest(195L));
        }
        catch (NoSuchTxnException e) {
            caught = true;
        }
        Assert.assertTrue((boolean)caught);
    }

    @Test
    public void testValidTxnsNoneOpen() throws Exception {
        this.txnHandler.openTxns(new OpenTxnRequest(2, "me", "localhost"));
        this.txnHandler.commitTxn(new CommitTxnRequest(1L));
        this.txnHandler.commitTxn(new CommitTxnRequest(2L));
        GetOpenTxnsInfoResponse txnsInfo = this.txnHandler.getOpenTxnsInfo();
        Assert.assertEquals((long)2L, (long)txnsInfo.getTxn_high_water_mark());
        Assert.assertEquals((int)0, (int)txnsInfo.getOpen_txns().size());
        GetOpenTxnsResponse txns = this.txnHandler.getOpenTxns();
        Assert.assertEquals((long)2L, (long)txns.getTxn_high_water_mark());
        Assert.assertEquals((int)0, (int)txns.getOpen_txns().size());
    }

    @Test
    public void testValidTxnsSomeOpen() throws Exception {
        this.txnHandler.openTxns(new OpenTxnRequest(3, "me", "localhost"));
        this.txnHandler.abortTxn(new AbortTxnRequest(1L));
        this.txnHandler.commitTxn(new CommitTxnRequest(2L));
        GetOpenTxnsInfoResponse txnsInfo = this.txnHandler.getOpenTxnsInfo();
        Assert.assertEquals((long)3L, (long)txnsInfo.getTxn_high_water_mark());
        Assert.assertEquals((int)2, (int)txnsInfo.getOpen_txns().size());
        Assert.assertEquals((long)1L, (long)((TxnInfo)txnsInfo.getOpen_txns().get(0)).getId());
        Assert.assertEquals((Object)TxnState.ABORTED, (Object)((TxnInfo)txnsInfo.getOpen_txns().get(0)).getState());
        Assert.assertEquals((long)3L, (long)((TxnInfo)txnsInfo.getOpen_txns().get(1)).getId());
        Assert.assertEquals((Object)TxnState.OPEN, (Object)((TxnInfo)txnsInfo.getOpen_txns().get(1)).getState());
        GetOpenTxnsResponse txns = this.txnHandler.getOpenTxns();
        Assert.assertEquals((long)3L, (long)txns.getTxn_high_water_mark());
        Assert.assertEquals((int)2, (int)txns.getOpen_txns().size());
        boolean[] saw = new boolean[4];
        for (int i = 0; i < saw.length; ++i) {
            saw[i] = false;
        }
        for (Long tid : txns.getOpen_txns()) {
            saw[tid.intValue()] = true;
        }
        Assert.assertTrue((boolean)saw[1]);
        Assert.assertFalse((boolean)saw[2]);
        Assert.assertTrue((boolean)saw[3]);
    }

    @Test
    public void testLockDifferentDBs() throws Exception {
        LockComponent comp = new LockComponent(LockType.EXCLUSIVE, LockLevel.DB, "mydb");
        ArrayList<LockComponent> components = new ArrayList<LockComponent>(1);
        components.add(comp);
        LockRequest req = new LockRequest(components, "me", "localhost");
        LockResponse res = this.txnHandler.lock(req);
        Assert.assertTrue((res.getState() == LockState.ACQUIRED ? 1 : 0) != 0);
        comp = new LockComponent(LockType.EXCLUSIVE, LockLevel.DB, "yourdb");
        components.clear();
        components.add(comp);
        req = new LockRequest(components, "me", "localhost");
        res = this.txnHandler.lock(req);
        Assert.assertTrue((res.getState() == LockState.ACQUIRED ? 1 : 0) != 0);
    }

    @Test
    public void testLockSameDB() throws Exception {
        LockComponent comp = new LockComponent(LockType.EXCLUSIVE, LockLevel.DB, "mydb");
        ArrayList<LockComponent> components = new ArrayList<LockComponent>(1);
        components.add(comp);
        LockRequest req = new LockRequest(components, "me", "localhost");
        LockResponse res = this.txnHandler.lock(req);
        Assert.assertTrue((res.getState() == LockState.ACQUIRED ? 1 : 0) != 0);
        comp = new LockComponent(LockType.EXCLUSIVE, LockLevel.DB, "mydb");
        components.clear();
        components.add(comp);
        req = new LockRequest(components, "me", "localhost");
        res = this.txnHandler.lock(req);
        Assert.assertTrue((res.getState() == LockState.WAITING ? 1 : 0) != 0);
    }

    @Test
    public void testLockDbLocksTable() throws Exception {
        LockComponent comp = new LockComponent(LockType.EXCLUSIVE, LockLevel.DB, "mydb");
        ArrayList<LockComponent> components = new ArrayList<LockComponent>(1);
        components.add(comp);
        LockRequest req = new LockRequest(components, "me", "localhost");
        LockResponse res = this.txnHandler.lock(req);
        Assert.assertTrue((res.getState() == LockState.ACQUIRED ? 1 : 0) != 0);
        comp = new LockComponent(LockType.EXCLUSIVE, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        components.clear();
        components.add(comp);
        req = new LockRequest(components, "me", "localhost");
        res = this.txnHandler.lock(req);
        Assert.assertTrue((res.getState() == LockState.WAITING ? 1 : 0) != 0);
    }

    @Test
    public void testLockDbDoesNotLockTableInDifferentDB() throws Exception {
        LockComponent comp = new LockComponent(LockType.EXCLUSIVE, LockLevel.DB, "mydb");
        ArrayList<LockComponent> components = new ArrayList<LockComponent>(1);
        components.add(comp);
        LockRequest req = new LockRequest(components, "me", "localhost");
        LockResponse res = this.txnHandler.lock(req);
        Assert.assertTrue((res.getState() == LockState.ACQUIRED ? 1 : 0) != 0);
        comp = new LockComponent(LockType.EXCLUSIVE, LockLevel.DB, "yourdb");
        comp.setTablename("mytable");
        components.clear();
        components.add(comp);
        req = new LockRequest(components, "me", "localhost");
        res = this.txnHandler.lock(req);
        Assert.assertTrue((res.getState() == LockState.ACQUIRED ? 1 : 0) != 0);
    }

    @Test
    public void testLockDifferentTables() throws Exception {
        LockComponent comp = new LockComponent(LockType.EXCLUSIVE, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        ArrayList<LockComponent> components = new ArrayList<LockComponent>(1);
        components.add(comp);
        LockRequest req = new LockRequest(components, "me", "localhost");
        LockResponse res = this.txnHandler.lock(req);
        Assert.assertTrue((res.getState() == LockState.ACQUIRED ? 1 : 0) != 0);
        comp = new LockComponent(LockType.EXCLUSIVE, LockLevel.DB, "mydb");
        comp.setTablename("yourtable");
        components.clear();
        components.add(comp);
        req = new LockRequest(components, "me", "localhost");
        res = this.txnHandler.lock(req);
        Assert.assertTrue((res.getState() == LockState.ACQUIRED ? 1 : 0) != 0);
    }

    @Test
    public void testLockSameTable() throws Exception {
        LockComponent comp = new LockComponent(LockType.EXCLUSIVE, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        ArrayList<LockComponent> components = new ArrayList<LockComponent>(1);
        components.add(comp);
        LockRequest req = new LockRequest(components, "me", "localhost");
        LockResponse res = this.txnHandler.lock(req);
        Assert.assertTrue((res.getState() == LockState.ACQUIRED ? 1 : 0) != 0);
        comp = new LockComponent(LockType.EXCLUSIVE, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        components.clear();
        components.add(comp);
        req = new LockRequest(components, "me", "localhost");
        res = this.txnHandler.lock(req);
        Assert.assertTrue((res.getState() == LockState.WAITING ? 1 : 0) != 0);
    }

    @Test
    public void testLockTableLocksPartition() throws Exception {
        LockComponent comp = new LockComponent(LockType.EXCLUSIVE, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        ArrayList<LockComponent> components = new ArrayList<LockComponent>(1);
        components.add(comp);
        LockRequest req = new LockRequest(components, "me", "localhost");
        LockResponse res = this.txnHandler.lock(req);
        Assert.assertTrue((res.getState() == LockState.ACQUIRED ? 1 : 0) != 0);
        comp = new LockComponent(LockType.EXCLUSIVE, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        comp.setPartitionname("mypartition");
        components.clear();
        components.add(comp);
        req = new LockRequest(components, "me", "localhost");
        res = this.txnHandler.lock(req);
        Assert.assertTrue((res.getState() == LockState.WAITING ? 1 : 0) != 0);
    }

    @Test
    public void testLockDifferentTableDoesntLockPartition() throws Exception {
        LockComponent comp = new LockComponent(LockType.EXCLUSIVE, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        ArrayList<LockComponent> components = new ArrayList<LockComponent>(1);
        components.add(comp);
        LockRequest req = new LockRequest(components, "me", "localhost");
        LockResponse res = this.txnHandler.lock(req);
        Assert.assertTrue((res.getState() == LockState.ACQUIRED ? 1 : 0) != 0);
        comp = new LockComponent(LockType.EXCLUSIVE, LockLevel.DB, "mydb");
        comp.setTablename("yourtable");
        comp.setPartitionname("mypartition");
        components.clear();
        components.add(comp);
        req = new LockRequest(components, "me", "localhost");
        res = this.txnHandler.lock(req);
        Assert.assertTrue((res.getState() == LockState.ACQUIRED ? 1 : 0) != 0);
    }

    @Test
    public void testLockDifferentPartitions() throws Exception {
        LockComponent comp = new LockComponent(LockType.EXCLUSIVE, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        comp.setPartitionname("mypartition");
        ArrayList<LockComponent> components = new ArrayList<LockComponent>(1);
        components.add(comp);
        LockRequest req = new LockRequest(components, "me", "localhost");
        LockResponse res = this.txnHandler.lock(req);
        Assert.assertTrue((res.getState() == LockState.ACQUIRED ? 1 : 0) != 0);
        comp = new LockComponent(LockType.EXCLUSIVE, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        comp.setPartitionname("yourpartition");
        components.clear();
        components.add(comp);
        req = new LockRequest(components, "me", "localhost");
        res = this.txnHandler.lock(req);
        Assert.assertTrue((res.getState() == LockState.ACQUIRED ? 1 : 0) != 0);
    }

    @Test
    public void testLockSamePartition() throws Exception {
        LockComponent comp = new LockComponent(LockType.EXCLUSIVE, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        comp.setPartitionname("mypartition");
        ArrayList<LockComponent> components = new ArrayList<LockComponent>(1);
        components.add(comp);
        LockRequest req = new LockRequest(components, "me", "localhost");
        LockResponse res = this.txnHandler.lock(req);
        Assert.assertTrue((res.getState() == LockState.ACQUIRED ? 1 : 0) != 0);
        comp = new LockComponent(LockType.EXCLUSIVE, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        comp.setPartitionname("mypartition");
        components.clear();
        components.add(comp);
        req = new LockRequest(components, "me", "localhost");
        res = this.txnHandler.lock(req);
        Assert.assertTrue((res.getState() == LockState.WAITING ? 1 : 0) != 0);
    }

    @Test
    public void testLockSRSR() throws Exception {
        LockComponent comp = new LockComponent(LockType.SHARED_READ, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        comp.setPartitionname("mypartition");
        ArrayList<LockComponent> components = new ArrayList<LockComponent>(1);
        components.add(comp);
        LockRequest req = new LockRequest(components, "me", "localhost");
        LockResponse res = this.txnHandler.lock(req);
        Assert.assertTrue((res.getState() == LockState.ACQUIRED ? 1 : 0) != 0);
        comp = new LockComponent(LockType.SHARED_READ, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        comp.setPartitionname("mypartition");
        components.clear();
        components.add(comp);
        req = new LockRequest(components, "me", "localhost");
        res = this.txnHandler.lock(req);
        Assert.assertTrue((res.getState() == LockState.ACQUIRED ? 1 : 0) != 0);
    }

    @Test
    public void testLockESRSR() throws Exception {
        LockComponent comp = new LockComponent(LockType.EXCLUSIVE, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        comp.setPartitionname("mypartition");
        ArrayList<LockComponent> components = new ArrayList<LockComponent>(1);
        components.add(comp);
        LockRequest req = new LockRequest(components, "me", "localhost");
        LockResponse res = this.txnHandler.lock(req);
        Assert.assertTrue((res.getState() == LockState.ACQUIRED ? 1 : 0) != 0);
        comp = new LockComponent(LockType.SHARED_READ, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        comp.setPartitionname("mypartition");
        components.clear();
        components.add(comp);
        req = new LockRequest(components, "me", "localhost");
        res = this.txnHandler.lock(req);
        Assert.assertTrue((res.getState() == LockState.WAITING ? 1 : 0) != 0);
        comp = new LockComponent(LockType.SHARED_READ, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        comp.setPartitionname("mypartition");
        components.clear();
        components.add(comp);
        req = new LockRequest(components, "me", "localhost");
        res = this.txnHandler.lock(req);
        Assert.assertTrue((res.getState() == LockState.WAITING ? 1 : 0) != 0);
    }

    @Test
    public void testLockSRSW() throws Exception {
        LockComponent comp = new LockComponent(LockType.SHARED_READ, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        comp.setPartitionname("mypartition");
        ArrayList<LockComponent> components = new ArrayList<LockComponent>(1);
        components.add(comp);
        LockRequest req = new LockRequest(components, "me", "localhost");
        LockResponse res = this.txnHandler.lock(req);
        Assert.assertTrue((res.getState() == LockState.ACQUIRED ? 1 : 0) != 0);
        comp = new LockComponent(LockType.SHARED_WRITE, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        comp.setPartitionname("mypartition");
        components.clear();
        components.add(comp);
        req = new LockRequest(components, "me", "localhost");
        res = this.txnHandler.lock(req);
        Assert.assertTrue((res.getState() == LockState.ACQUIRED ? 1 : 0) != 0);
    }

    @Test
    public void testLockESRSW() throws Exception {
        LockComponent comp = new LockComponent(LockType.EXCLUSIVE, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        comp.setPartitionname("mypartition");
        ArrayList<LockComponent> components = new ArrayList<LockComponent>(1);
        components.add(comp);
        LockRequest req = new LockRequest(components, "me", "localhost");
        LockResponse res = this.txnHandler.lock(req);
        Assert.assertTrue((res.getState() == LockState.ACQUIRED ? 1 : 0) != 0);
        comp = new LockComponent(LockType.SHARED_READ, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        comp.setPartitionname("mypartition");
        components.clear();
        components.add(comp);
        req = new LockRequest(components, "me", "localhost");
        res = this.txnHandler.lock(req);
        Assert.assertTrue((res.getState() == LockState.WAITING ? 1 : 0) != 0);
        comp = new LockComponent(LockType.SHARED_WRITE, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        comp.setPartitionname("mypartition");
        components.clear();
        components.add(comp);
        req = new LockRequest(components, "me", "localhost");
        res = this.txnHandler.lock(req);
        Assert.assertTrue((res.getState() == LockState.WAITING ? 1 : 0) != 0);
    }

    @Test
    public void testLockSRE() throws Exception {
        LockComponent comp = new LockComponent(LockType.SHARED_READ, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        comp.setPartitionname("mypartition");
        ArrayList<LockComponent> components = new ArrayList<LockComponent>(1);
        components.add(comp);
        LockRequest req = new LockRequest(components, "me", "localhost");
        LockResponse res = this.txnHandler.lock(req);
        Assert.assertTrue((res.getState() == LockState.ACQUIRED ? 1 : 0) != 0);
        comp = new LockComponent(LockType.EXCLUSIVE, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        comp.setPartitionname("mypartition");
        components.clear();
        components.add(comp);
        req = new LockRequest(components, "me", "localhost");
        res = this.txnHandler.lock(req);
        Assert.assertTrue((res.getState() == LockState.WAITING ? 1 : 0) != 0);
    }

    @Test
    public void testLockESRE() throws Exception {
        LockComponent comp = new LockComponent(LockType.EXCLUSIVE, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        comp.setPartitionname("mypartition");
        ArrayList<LockComponent> components = new ArrayList<LockComponent>(1);
        components.add(comp);
        LockRequest req = new LockRequest(components, "me", "localhost");
        LockResponse res = this.txnHandler.lock(req);
        Assert.assertTrue((res.getState() == LockState.ACQUIRED ? 1 : 0) != 0);
        comp = new LockComponent(LockType.SHARED_READ, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        comp.setPartitionname("mypartition");
        components.clear();
        components.add(comp);
        req = new LockRequest(components, "me", "localhost");
        res = this.txnHandler.lock(req);
        Assert.assertTrue((res.getState() == LockState.WAITING ? 1 : 0) != 0);
        comp = new LockComponent(LockType.EXCLUSIVE, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        comp.setPartitionname("mypartition");
        components.clear();
        components.add(comp);
        req = new LockRequest(components, "me", "localhost");
        res = this.txnHandler.lock(req);
        Assert.assertTrue((res.getState() == LockState.WAITING ? 1 : 0) != 0);
    }

    @Test
    public void testLockSWSR() throws Exception {
        LockComponent comp = new LockComponent(LockType.SHARED_WRITE, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        comp.setPartitionname("mypartition");
        ArrayList<LockComponent> components = new ArrayList<LockComponent>(1);
        components.add(comp);
        LockRequest req = new LockRequest(components, "me", "localhost");
        LockResponse res = this.txnHandler.lock(req);
        Assert.assertTrue((res.getState() == LockState.ACQUIRED ? 1 : 0) != 0);
        comp = new LockComponent(LockType.SHARED_READ, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        comp.setPartitionname("mypartition");
        components.clear();
        components.add(comp);
        req = new LockRequest(components, "me", "localhost");
        res = this.txnHandler.lock(req);
        Assert.assertTrue((res.getState() == LockState.ACQUIRED ? 1 : 0) != 0);
    }

    @Test
    public void testLockSWSWSR() throws Exception {
        LockComponent comp = new LockComponent(LockType.SHARED_WRITE, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        comp.setPartitionname("mypartition");
        ArrayList<LockComponent> components = new ArrayList<LockComponent>(1);
        components.add(comp);
        LockRequest req = new LockRequest(components, "me", "localhost");
        LockResponse res = this.txnHandler.lock(req);
        Assert.assertTrue((res.getState() == LockState.ACQUIRED ? 1 : 0) != 0);
        comp = new LockComponent(LockType.SHARED_WRITE, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        comp.setPartitionname("mypartition");
        components.clear();
        components.add(comp);
        req = new LockRequest(components, "me", "localhost");
        res = this.txnHandler.lock(req);
        Assert.assertTrue((res.getState() == LockState.WAITING ? 1 : 0) != 0);
        comp = new LockComponent(LockType.SHARED_READ, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        comp.setPartitionname("mypartition");
        components.clear();
        components.add(comp);
        req = new LockRequest(components, "me", "localhost");
        res = this.txnHandler.lock(req);
        Assert.assertTrue((res.getState() == LockState.ACQUIRED ? 1 : 0) != 0);
    }

    @Test
    public void testLockSWSWSW() throws Exception {
        LockComponent comp = new LockComponent(LockType.SHARED_WRITE, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        comp.setPartitionname("mypartition");
        ArrayList<LockComponent> components = new ArrayList<LockComponent>(1);
        components.add(comp);
        LockRequest req = new LockRequest(components, "me", "localhost");
        LockResponse res = this.txnHandler.lock(req);
        Assert.assertTrue((res.getState() == LockState.ACQUIRED ? 1 : 0) != 0);
        comp = new LockComponent(LockType.SHARED_WRITE, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        comp.setPartitionname("mypartition");
        components.clear();
        components.add(comp);
        req = new LockRequest(components, "me", "localhost");
        res = this.txnHandler.lock(req);
        Assert.assertTrue((res.getState() == LockState.WAITING ? 1 : 0) != 0);
        comp = new LockComponent(LockType.SHARED_WRITE, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        comp.setPartitionname("mypartition");
        components.clear();
        components.add(comp);
        req = new LockRequest(components, "me", "localhost");
        res = this.txnHandler.lock(req);
        Assert.assertTrue((res.getState() == LockState.WAITING ? 1 : 0) != 0);
    }

    @Test
    public void testLockEESW() throws Exception {
        LockComponent comp = new LockComponent(LockType.EXCLUSIVE, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        comp.setPartitionname("mypartition");
        ArrayList<LockComponent> components = new ArrayList<LockComponent>(1);
        components.add(comp);
        LockRequest req = new LockRequest(components, "me", "localhost");
        LockResponse res = this.txnHandler.lock(req);
        Assert.assertTrue((res.getState() == LockState.ACQUIRED ? 1 : 0) != 0);
        comp = new LockComponent(LockType.EXCLUSIVE, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        comp.setPartitionname("mypartition");
        components.clear();
        components.add(comp);
        req = new LockRequest(components, "me", "localhost");
        res = this.txnHandler.lock(req);
        Assert.assertTrue((res.getState() == LockState.WAITING ? 1 : 0) != 0);
        comp = new LockComponent(LockType.SHARED_WRITE, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        comp.setPartitionname("mypartition");
        components.clear();
        components.add(comp);
        req = new LockRequest(components, "me", "localhost");
        res = this.txnHandler.lock(req);
        Assert.assertTrue((res.getState() == LockState.WAITING ? 1 : 0) != 0);
    }

    @Test
    public void testLockEESR() throws Exception {
        LockComponent comp = new LockComponent(LockType.EXCLUSIVE, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        comp.setPartitionname("mypartition");
        ArrayList<LockComponent> components = new ArrayList<LockComponent>(1);
        components.add(comp);
        LockRequest req = new LockRequest(components, "me", "localhost");
        LockResponse res = this.txnHandler.lock(req);
        Assert.assertTrue((res.getState() == LockState.ACQUIRED ? 1 : 0) != 0);
        comp = new LockComponent(LockType.EXCLUSIVE, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        comp.setPartitionname("mypartition");
        components.clear();
        components.add(comp);
        req = new LockRequest(components, "me", "localhost");
        res = this.txnHandler.lock(req);
        Assert.assertTrue((res.getState() == LockState.WAITING ? 1 : 0) != 0);
        comp = new LockComponent(LockType.SHARED_READ, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        comp.setPartitionname("mypartition");
        components.clear();
        components.add(comp);
        req = new LockRequest(components, "me", "localhost");
        res = this.txnHandler.lock(req);
        Assert.assertTrue((res.getState() == LockState.WAITING ? 1 : 0) != 0);
    }

    @Test
    public void testCheckLockAcquireAfterWaiting() throws Exception {
        LockComponent comp = new LockComponent(LockType.SHARED_WRITE, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        comp.setPartitionname("mypartition");
        ArrayList<LockComponent> components = new ArrayList<LockComponent>(1);
        components.add(comp);
        LockRequest req = new LockRequest(components, "me", "localhost");
        LockResponse res = this.txnHandler.lock(req);
        long lockid1 = res.getLockid();
        Assert.assertTrue((res.getState() == LockState.ACQUIRED ? 1 : 0) != 0);
        comp = new LockComponent(LockType.SHARED_WRITE, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        comp.setPartitionname("mypartition");
        components.clear();
        components.add(comp);
        req = new LockRequest(components, "me", "localhost");
        res = this.txnHandler.lock(req);
        long lockid2 = res.getLockid();
        Assert.assertTrue((res.getState() == LockState.WAITING ? 1 : 0) != 0);
        this.txnHandler.unlock(new UnlockRequest(lockid1));
        res = this.txnHandler.checkLock(new CheckLockRequest(lockid2));
        Assert.assertTrue((res.getState() == LockState.ACQUIRED ? 1 : 0) != 0);
    }

    @Test
    public void testCheckLockNoSuchLock() throws Exception {
        try {
            this.txnHandler.checkLock(new CheckLockRequest(23L));
            Assert.fail((String)"Allowed to check lock on non-existent lock");
        }
        catch (NoSuchLockException noSuchLockException) {
            // empty catch block
        }
    }

    @Test
    public void testCheckLockTxnAborted() throws Exception {
        long txnid = this.openTxn();
        LockComponent comp = new LockComponent(LockType.SHARED_WRITE, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        comp.setPartitionname("mypartition");
        ArrayList<LockComponent> components = new ArrayList<LockComponent>(1);
        components.add(comp);
        LockRequest req = new LockRequest(components, "me", "localhost");
        req.setTxnid(txnid);
        LockResponse res = this.txnHandler.lock(req);
        long lockid = res.getLockid();
        this.txnHandler.abortTxn(new AbortTxnRequest(txnid));
        try {
            this.txnHandler.checkLock(new CheckLockRequest(lockid));
            Assert.fail((String)"Allowed to check lock on aborted transaction.");
        }
        catch (NoSuchLockException noSuchLockException) {
            // empty catch block
        }
    }

    @Test
    public void testMultipleLock() throws Exception {
        LockComponent comp = new LockComponent(LockType.EXCLUSIVE, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        comp.setPartitionname("mypartition");
        ArrayList<LockComponent> components = new ArrayList<LockComponent>(2);
        components.add(comp);
        comp = new LockComponent(LockType.EXCLUSIVE, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        comp.setPartitionname("anotherpartition");
        components.add(comp);
        LockRequest req = new LockRequest(components, "me", "localhost");
        LockResponse res = this.txnHandler.lock(req);
        long lockid = res.getLockid();
        Assert.assertTrue((res.getState() == LockState.ACQUIRED ? 1 : 0) != 0);
        res = this.txnHandler.checkLock(new CheckLockRequest(lockid));
        Assert.assertTrue((res.getState() == LockState.ACQUIRED ? 1 : 0) != 0);
        this.txnHandler.unlock(new UnlockRequest(lockid));
        Assert.assertEquals((int)0, (int)this.txnHandler.numLocksInLockTable());
    }

    @Test
    public void testMultipleLockWait() throws Exception {
        LockComponent comp = new LockComponent(LockType.EXCLUSIVE, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        comp.setPartitionname("mypartition");
        ArrayList<LockComponent> components = new ArrayList<LockComponent>(2);
        components.add(comp);
        comp = new LockComponent(LockType.EXCLUSIVE, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        comp.setPartitionname("anotherpartition");
        components.add(comp);
        LockRequest req = new LockRequest(components, "me", "localhost");
        LockResponse res = this.txnHandler.lock(req);
        long lockid1 = res.getLockid();
        Assert.assertTrue((res.getState() == LockState.ACQUIRED ? 1 : 0) != 0);
        comp = new LockComponent(LockType.EXCLUSIVE, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        comp.setPartitionname("mypartition");
        components = new ArrayList(1);
        components.add(comp);
        req = new LockRequest(components, "me", "localhost");
        res = this.txnHandler.lock(req);
        long lockid2 = res.getLockid();
        Assert.assertTrue((res.getState() == LockState.WAITING ? 1 : 0) != 0);
        this.txnHandler.unlock(new UnlockRequest(lockid1));
        res = this.txnHandler.checkLock(new CheckLockRequest(lockid2));
        Assert.assertTrue((res.getState() == LockState.ACQUIRED ? 1 : 0) != 0);
    }

    @Test
    public void testUnlockOnCommit() throws Exception {
        long txnid = this.openTxn();
        LockComponent comp = new LockComponent(LockType.SHARED_WRITE, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        ArrayList<LockComponent> components = new ArrayList<LockComponent>(1);
        components.add(comp);
        LockRequest req = new LockRequest(components, "me", "localhost");
        req.setTxnid(txnid);
        LockResponse res = this.txnHandler.lock(req);
        Assert.assertTrue((res.getState() == LockState.ACQUIRED ? 1 : 0) != 0);
        this.txnHandler.commitTxn(new CommitTxnRequest(txnid));
        Assert.assertEquals((int)0, (int)this.txnHandler.numLocksInLockTable());
    }

    @Test
    public void testUnlockOnAbort() throws Exception {
        long txnid = this.openTxn();
        LockComponent comp = new LockComponent(LockType.SHARED_WRITE, LockLevel.DB, "mydb");
        ArrayList<LockComponent> components = new ArrayList<LockComponent>(1);
        components.add(comp);
        LockRequest req = new LockRequest(components, "me", "localhost");
        req.setTxnid(txnid);
        LockResponse res = this.txnHandler.lock(req);
        Assert.assertTrue((res.getState() == LockState.ACQUIRED ? 1 : 0) != 0);
        this.txnHandler.abortTxn(new AbortTxnRequest(txnid));
        Assert.assertEquals((int)0, (int)this.txnHandler.numLocksInLockTable());
    }

    @Test
    public void testUnlockWithTxn() throws Exception {
        LOG.debug((Object)"Starting testUnlockWithTxn");
        long txnid = this.openTxn();
        LockComponent comp = new LockComponent(LockType.SHARED_WRITE, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        comp.setPartitionname("mypartition");
        ArrayList<LockComponent> components = new ArrayList<LockComponent>(1);
        components.add(comp);
        LockRequest req = new LockRequest(components, "me", "localhost");
        req.setTxnid(txnid);
        LockResponse res = this.txnHandler.lock(req);
        long lockid = res.getLockid();
        try {
            this.txnHandler.unlock(new UnlockRequest(lockid));
            Assert.fail((String)"Allowed to unlock lock associated with transaction.");
        }
        catch (TxnOpenException txnOpenException) {
            // empty catch block
        }
    }

    @Test
    public void testHeartbeatTxnAborted() throws Exception {
        this.openTxn();
        this.txnHandler.abortTxn(new AbortTxnRequest(1L));
        HeartbeatRequest h = new HeartbeatRequest();
        h.setTxnid(1L);
        try {
            this.txnHandler.heartbeat(h);
            Assert.fail((String)"Told there was a txn, when it should have been aborted.");
        }
        catch (TxnAbortedException txnAbortedException) {
            // empty catch block
        }
    }

    @Test
    public void testHeartbeatNoTxn() throws Exception {
        HeartbeatRequest h = new HeartbeatRequest();
        h.setTxnid(939393L);
        try {
            this.txnHandler.heartbeat(h);
            Assert.fail((String)"Told there was a txn, when there wasn't.");
        }
        catch (NoSuchTxnException noSuchTxnException) {
            // empty catch block
        }
    }

    @Test
    public void testHeartbeatLock() throws Exception {
        this.conf.setTimeVar(HiveConf.ConfVars.HIVE_TXN_TIMEOUT, 1L, TimeUnit.SECONDS);
        HeartbeatRequest h = new HeartbeatRequest();
        LockComponent comp = new LockComponent(LockType.EXCLUSIVE, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        comp.setPartitionname("mypartition");
        ArrayList<LockComponent> components = new ArrayList<LockComponent>(1);
        components.add(comp);
        LockRequest req = new LockRequest(components, "me", "localhost");
        LockResponse res = this.txnHandler.lock(req);
        Assert.assertTrue((res.getState() == LockState.ACQUIRED ? 1 : 0) != 0);
        h.setLockid(res.getLockid());
        for (int i = 0; i < 30; ++i) {
            try {
                this.txnHandler.heartbeat(h);
                continue;
            }
            catch (NoSuchLockException e) {
                Assert.fail((String)"Told there was no lock, when the heartbeat should have kept it.");
            }
        }
    }

    @Test
    public void heartbeatTxnRange() throws Exception {
        long txnid = this.openTxn();
        Assert.assertEquals((long)1L, (long)txnid);
        txnid = this.openTxn();
        txnid = this.openTxn();
        HeartbeatTxnRangeResponse rsp = this.txnHandler.heartbeatTxnRange(new HeartbeatTxnRangeRequest(1L, 3L));
        Assert.assertEquals((int)0, (int)rsp.getAborted().size());
        Assert.assertEquals((int)0, (int)rsp.getNosuch().size());
    }

    @Test
    public void heartbeatTxnRangeOneCommitted() throws Exception {
        long txnid = this.openTxn();
        Assert.assertEquals((long)1L, (long)txnid);
        this.txnHandler.commitTxn(new CommitTxnRequest(1L));
        txnid = this.openTxn();
        txnid = this.openTxn();
        HeartbeatTxnRangeResponse rsp = this.txnHandler.heartbeatTxnRange(new HeartbeatTxnRangeRequest(1L, 3L));
        Assert.assertEquals((int)1, (int)rsp.getNosuchSize());
        Long txn = (Long)rsp.getNosuch().iterator().next();
        Assert.assertEquals((long)1L, (long)txn);
        Assert.assertEquals((int)0, (int)rsp.getAborted().size());
    }

    @Test
    public void heartbeatTxnRangeOneAborted() throws Exception {
        long txnid = this.openTxn();
        Assert.assertEquals((long)1L, (long)txnid);
        txnid = this.openTxn();
        txnid = this.openTxn();
        this.txnHandler.abortTxn(new AbortTxnRequest(3L));
        HeartbeatTxnRangeResponse rsp = this.txnHandler.heartbeatTxnRange(new HeartbeatTxnRangeRequest(1L, 3L));
        Assert.assertEquals((int)1, (int)rsp.getAbortedSize());
        Long txn = (Long)rsp.getAborted().iterator().next();
        Assert.assertEquals((long)3L, (long)txn);
        Assert.assertEquals((int)0, (int)rsp.getNosuch().size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLockTimeout() throws Exception {
        long timeout = this.txnHandler.setTimeout(1L);
        try {
            LockComponent comp = new LockComponent(LockType.EXCLUSIVE, LockLevel.DB, "mydb");
            comp.setTablename("mytable");
            comp.setPartitionname("mypartition");
            ArrayList<LockComponent> components = new ArrayList<LockComponent>(1);
            components.add(comp);
            LockRequest req = new LockRequest(components, "me", "localhost");
            LockResponse res = this.txnHandler.lock(req);
            Assert.assertTrue((res.getState() == LockState.ACQUIRED ? 1 : 0) != 0);
            Thread.currentThread();
            Thread.sleep(10L);
            this.txnHandler.checkLock(new CheckLockRequest(res.getLockid()));
            Assert.fail((String)"Told there was a lock, when it should have timed out.");
        }
        catch (NoSuchLockException noSuchLockException) {
        }
        finally {
            this.txnHandler.setTimeout(timeout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRecoverManyTimeouts() throws Exception {
        long timeout = this.txnHandler.setTimeout(1L);
        try {
            this.txnHandler.openTxns(new OpenTxnRequest(503, "me", "localhost"));
            Thread.currentThread();
            Thread.sleep(10L);
            this.txnHandler.getOpenTxns();
            GetOpenTxnsInfoResponse rsp = this.txnHandler.getOpenTxnsInfo();
            int numAborted = 0;
            for (TxnInfo txnInfo : rsp.getOpen_txns()) {
                Assert.assertEquals((Object)TxnState.ABORTED, (Object)txnInfo.getState());
                ++numAborted;
            }
            Assert.assertEquals((int)503, (int)numAborted);
        }
        finally {
            this.txnHandler.setTimeout(timeout);
        }
    }

    @Test
    public void testHeartbeatNoLock() throws Exception {
        HeartbeatRequest h = new HeartbeatRequest();
        h.setLockid(29389839L);
        try {
            this.txnHandler.heartbeat(h);
            Assert.fail((String)"Told there was a lock, when there wasn't.");
        }
        catch (NoSuchLockException noSuchLockException) {
            // empty catch block
        }
    }

    @Test
    public void testCompactMajorWithPartition() throws Exception {
        CompactionRequest rqst = new CompactionRequest("foo", "bar", CompactionType.MAJOR);
        rqst.setPartitionname("ds=today");
        this.txnHandler.compact(rqst);
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        List compacts = rsp.getCompacts();
        Assert.assertEquals((int)1, (int)compacts.size());
        ShowCompactResponseElement c = (ShowCompactResponseElement)compacts.get(0);
        Assert.assertEquals((String)"foo", (String)c.getDbname());
        Assert.assertEquals((String)"bar", (String)c.getTablename());
        Assert.assertEquals((String)"ds=today", (String)c.getPartitionname());
        Assert.assertEquals((Object)CompactionType.MAJOR, (Object)c.getType());
        Assert.assertEquals((String)"initiated", (String)c.getState());
        Assert.assertEquals((long)0L, (long)c.getStart());
    }

    @Test
    public void testCompactMinorNoPartition() throws Exception {
        CompactionRequest rqst = new CompactionRequest("foo", "bar", CompactionType.MINOR);
        rqst.setRunas("fred");
        this.txnHandler.compact(rqst);
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        List compacts = rsp.getCompacts();
        Assert.assertEquals((int)1, (int)compacts.size());
        ShowCompactResponseElement c = (ShowCompactResponseElement)compacts.get(0);
        Assert.assertEquals((String)"foo", (String)c.getDbname());
        Assert.assertEquals((String)"bar", (String)c.getTablename());
        Assert.assertNull((Object)c.getPartitionname());
        Assert.assertEquals((Object)CompactionType.MINOR, (Object)c.getType());
        Assert.assertEquals((String)"initiated", (String)c.getState());
        Assert.assertEquals((long)0L, (long)c.getStart());
        Assert.assertEquals((String)"fred", (String)c.getRunAs());
    }

    @Test
    public void showLocks() throws Exception {
        long begining = System.currentTimeMillis();
        long txnid = this.openTxn();
        LockComponent comp = new LockComponent(LockType.EXCLUSIVE, LockLevel.DB, "mydb");
        ArrayList<LockComponent> components = new ArrayList<LockComponent>(1);
        components.add(comp);
        LockRequest req = new LockRequest(components, "me", "localhost");
        req.setTxnid(txnid);
        LockResponse res = this.txnHandler.lock(req);
        txnid = this.openTxn();
        comp = new LockComponent(LockType.SHARED_READ, LockLevel.TABLE, "mydb");
        comp.setTablename("mytable");
        components = new ArrayList(1);
        components.add(comp);
        req = new LockRequest(components, "me", "localhost");
        req.setTxnid(txnid);
        res = this.txnHandler.lock(req);
        components = new ArrayList(1);
        comp = new LockComponent(LockType.SHARED_WRITE, LockLevel.PARTITION, "yourdb");
        comp.setTablename("yourtable");
        comp.setPartitionname("yourpartition");
        components.add(comp);
        req = new LockRequest(components, "you", "remotehost");
        res = this.txnHandler.lock(req);
        ShowLocksResponse rsp = this.txnHandler.showLocks(new ShowLocksRequest());
        List locks = rsp.getLocks();
        Assert.assertEquals((int)3, (int)locks.size());
        boolean[] saw = new boolean[locks.size()];
        for (int i = 0; i < saw.length; ++i) {
            saw[i] = false;
        }
        for (ShowLocksResponseElement lock : locks) {
            if (lock.getLockid() == 1L) {
                Assert.assertEquals((long)1L, (long)lock.getTxnid());
                Assert.assertEquals((String)"mydb", (String)lock.getDbname());
                Assert.assertNull((Object)lock.getTablename());
                Assert.assertNull((Object)lock.getPartname());
                Assert.assertEquals((Object)LockState.ACQUIRED, (Object)lock.getState());
                Assert.assertEquals((Object)LockType.EXCLUSIVE, (Object)lock.getType());
                Assert.assertTrue((begining <= lock.getLastheartbeat() && System.currentTimeMillis() >= lock.getLastheartbeat() ? 1 : 0) != 0);
                Assert.assertTrue((String)("Expected acquired at " + lock.getAcquiredat() + " to be between " + begining + " and " + System.currentTimeMillis()), (begining <= lock.getAcquiredat() && System.currentTimeMillis() >= lock.getAcquiredat() ? 1 : 0) != 0);
                Assert.assertEquals((String)"me", (String)lock.getUser());
                Assert.assertEquals((String)"localhost", (String)lock.getHostname());
                saw[0] = true;
                continue;
            }
            if (lock.getLockid() == 2L) {
                Assert.assertEquals((long)2L, (long)lock.getTxnid());
                Assert.assertEquals((String)"mydb", (String)lock.getDbname());
                Assert.assertEquals((String)"mytable", (String)lock.getTablename());
                Assert.assertNull((Object)lock.getPartname());
                Assert.assertEquals((Object)LockState.WAITING, (Object)lock.getState());
                Assert.assertEquals((Object)LockType.SHARED_READ, (Object)lock.getType());
                Assert.assertTrue((begining <= lock.getLastheartbeat() && System.currentTimeMillis() >= lock.getLastheartbeat() ? 1 : 0) != 0);
                Assert.assertEquals((long)0L, (long)lock.getAcquiredat());
                Assert.assertEquals((String)"me", (String)lock.getUser());
                Assert.assertEquals((String)"localhost", (String)lock.getHostname());
                saw[1] = true;
                continue;
            }
            if (lock.getLockid() == 3L) {
                Assert.assertEquals((long)0L, (long)lock.getTxnid());
                Assert.assertEquals((String)"yourdb", (String)lock.getDbname());
                Assert.assertEquals((String)"yourtable", (String)lock.getTablename());
                Assert.assertEquals((String)"yourpartition", (String)lock.getPartname());
                Assert.assertEquals((Object)LockState.ACQUIRED, (Object)lock.getState());
                Assert.assertEquals((Object)LockType.SHARED_WRITE, (Object)lock.getType());
                Assert.assertTrue((begining <= lock.getLastheartbeat() && System.currentTimeMillis() >= lock.getLastheartbeat() ? 1 : 0) != 0);
                Assert.assertTrue((begining <= lock.getAcquiredat() && System.currentTimeMillis() >= lock.getAcquiredat() ? 1 : 0) != 0);
                Assert.assertEquals((String)"you", (String)lock.getUser());
                Assert.assertEquals((String)"remotehost", (String)lock.getHostname());
                saw[2] = true;
                continue;
            }
            Assert.fail((String)"Unknown lock id");
        }
        for (int i = 0; i < saw.length; ++i) {
            Assert.assertTrue((String)("Didn't see lock id " + i), (boolean)saw[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Ignore
    public void deadlockDetected() throws Exception {
        LOG.debug((Object)"Starting deadlock test");
        Connection conn = this.txnHandler.getDbConn(8);
        Statement stmt = conn.createStatement();
        long now = this.txnHandler.getDbTime(conn);
        stmt.executeUpdate("insert into TXNS (txn_id, txn_state, txn_started, txn_last_heartbeat, txn_user, txn_host) values (1, 'o', " + now + ", " + now + ", 'shagy', 'scooby.com')");
        stmt.executeUpdate("insert into HIVE_LOCKS (hl_lock_ext_id, hl_lock_int_id, hl_txnid, hl_db, hl_table, hl_partition, hl_lock_state, hl_lock_type, hl_last_heartbeat, hl_user, hl_host) values (1, 1, 1, 'mydb', 'mytable', 'mypartition', '" + 'w' + "', '" + 'e' + "', " + now + ", 'fred', 'scooby.com')");
        conn.commit();
        this.txnHandler.closeDbConn(conn);
        final AtomicBoolean sawDeadlock = new AtomicBoolean();
        final Connection conn1 = this.txnHandler.getDbConn(8);
        final Connection conn2 = this.txnHandler.getDbConn(8);
        try {
            for (int i = 0; i < 5; ++i) {
                Thread t1 = new Thread(){

                    @Override
                    public void run() {
                        try {
                            try {
                                TestTxnHandler.this.updateTxns(conn1);
                                TestTxnHandler.this.updateLocks(conn1);
                                Thread.sleep(1000L);
                                conn1.commit();
                                LOG.debug((Object)"no exception, no deadlock");
                            }
                            catch (SQLException e) {
                                try {
                                    TestTxnHandler.this.txnHandler.checkRetryable(conn1, e, "thread t1");
                                    LOG.debug((Object)("Got an exception, but not a deadlock, SQLState is " + e.getSQLState() + " class of exception is " + e.getClass().getName() + " msg is <" + e.getMessage() + ">"));
                                }
                                catch (TxnHandler.RetryException de) {
                                    LOG.debug((Object)("Forced a deadlock, SQLState is " + e.getSQLState() + " class of exception is " + e.getClass().getName() + " msg is <" + e.getMessage() + ">"));
                                    sawDeadlock.set(true);
                                }
                            }
                            conn1.rollback();
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                };
                Thread t2 = new Thread(){

                    @Override
                    public void run() {
                        try {
                            try {
                                TestTxnHandler.this.updateLocks(conn2);
                                TestTxnHandler.this.updateTxns(conn2);
                                Thread.sleep(1000L);
                                conn2.commit();
                                LOG.debug((Object)"no exception, no deadlock");
                            }
                            catch (SQLException e) {
                                try {
                                    TestTxnHandler.this.txnHandler.checkRetryable(conn2, e, "thread t2");
                                    LOG.debug((Object)("Got an exception, but not a deadlock, SQLState is " + e.getSQLState() + " class of exception is " + e.getClass().getName() + " msg is <" + e.getMessage() + ">"));
                                }
                                catch (TxnHandler.RetryException de) {
                                    LOG.debug((Object)("Forced a deadlock, SQLState is " + e.getSQLState() + " class of exception is " + e.getClass().getName() + " msg is <" + e.getMessage() + ">"));
                                    sawDeadlock.set(true);
                                }
                            }
                            conn2.rollback();
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                };
                t1.start();
                t2.start();
                t1.join();
                t2.join();
                if (sawDeadlock.get()) break;
            }
            Assert.assertTrue((boolean)sawDeadlock.get());
        }
        finally {
            conn1.rollback();
            this.txnHandler.closeDbConn(conn1);
            conn2.rollback();
            this.txnHandler.closeDbConn(conn2);
        }
    }

    private void updateTxns(Connection conn) throws SQLException {
        Statement stmt = conn.createStatement();
        stmt.executeUpdate("update TXNS set txn_last_heartbeat = txn_last_heartbeat + 1");
    }

    private void updateLocks(Connection conn) throws SQLException {
        Statement stmt = conn.createStatement();
        stmt.executeUpdate("update HIVE_LOCKS set hl_last_heartbeat = hl_last_heartbeat + 1");
    }

    @Before
    public void setUp() throws Exception {
        TxnDbUtil.prepDb();
        this.txnHandler = new TxnHandler(this.conf);
    }

    @After
    public void tearDown() throws Exception {
        TxnDbUtil.cleanDb();
    }

    private long openTxn() throws MetaException {
        List txns = this.txnHandler.openTxns(new OpenTxnRequest(1, "me", "localhost")).getTxn_ids();
        return (Long)txns.get(0);
    }
}

