/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.txn;

import org.apache.hadoop.hive.common.ValidTxnList;
import org.apache.hadoop.hive.metastore.txn.ValidCompactorTxnList;
import org.junit.Assert;
import org.junit.Test;

public class TestValidCompactorTxnList {
    @Test
    public void minTxnHigh() {
        ValidCompactorTxnList txns = new ValidCompactorTxnList(new long[]{3L, 4L}, 3L, 5L);
        ValidTxnList.RangeResponse rsp = txns.isTxnRangeValid(7L, 9L);
        Assert.assertEquals((Object)ValidTxnList.RangeResponse.NONE, (Object)rsp);
    }

    @Test
    public void maxTxnLow() {
        ValidCompactorTxnList txns = new ValidCompactorTxnList(new long[]{13L, 14L}, 13L, 15L);
        ValidTxnList.RangeResponse rsp = txns.isTxnRangeValid(7L, 9L);
        Assert.assertEquals((Object)ValidTxnList.RangeResponse.ALL, (Object)rsp);
    }

    @Test
    public void minTxnHighNoExceptions() {
        ValidCompactorTxnList txns = new ValidCompactorTxnList(new long[0], -1L, 5L);
        ValidTxnList.RangeResponse rsp = txns.isTxnRangeValid(7L, 9L);
        Assert.assertEquals((Object)ValidTxnList.RangeResponse.NONE, (Object)rsp);
    }

    @Test
    public void maxTxnLowNoExceptions() {
        ValidCompactorTxnList txns = new ValidCompactorTxnList(new long[0], -1L, 15L);
        ValidTxnList.RangeResponse rsp = txns.isTxnRangeValid(7L, 9L);
        Assert.assertEquals((Object)ValidTxnList.RangeResponse.ALL, (Object)rsp);
    }

    @Test
    public void exceptionsAllBelow() {
        ValidCompactorTxnList txns = new ValidCompactorTxnList(new long[]{3L, 6L}, 3L, 15L);
        ValidTxnList.RangeResponse rsp = txns.isTxnRangeValid(7L, 9L);
        Assert.assertEquals((Object)ValidTxnList.RangeResponse.NONE, (Object)rsp);
    }

    @Test
    public void exceptionsInMidst() {
        ValidCompactorTxnList txns = new ValidCompactorTxnList(new long[]{8L}, 8L, 15L);
        ValidTxnList.RangeResponse rsp = txns.isTxnRangeValid(7L, 9L);
        Assert.assertEquals((Object)ValidTxnList.RangeResponse.NONE, (Object)rsp);
    }

    @Test
    public void writeToString() {
        ValidCompactorTxnList txns = new ValidCompactorTxnList(new long[]{9L, 7L, 10L}, 9L, 37L);
        Assert.assertEquals((Object)"37:9:7:9:10", (Object)txns.writeToString());
        txns = new ValidCompactorTxnList();
        Assert.assertEquals((Object)(Long.toString(Long.MAX_VALUE) + ":-1:"), (Object)txns.writeToString());
        txns = new ValidCompactorTxnList(new long[0], -1L, 23L);
        Assert.assertEquals((Object)"23:-1:", (Object)txns.writeToString());
    }

    @Test
    public void readFromString() {
        ValidCompactorTxnList txns = new ValidCompactorTxnList("37:9:7:9:10");
        Assert.assertEquals((long)37L, (long)txns.getHighWatermark());
        Assert.assertEquals((long)9L, (long)txns.getMinOpenTxn());
        Assert.assertArrayEquals((long[])new long[]{7L, 9L, 10L}, (long[])txns.getInvalidTransactions());
        txns = new ValidCompactorTxnList("21:-1:");
        Assert.assertEquals((long)21L, (long)txns.getHighWatermark());
        Assert.assertEquals((long)-1L, (long)txns.getMinOpenTxn());
        Assert.assertEquals((long)0L, (long)txns.getInvalidTransactions().length);
    }
}

