/*
 * Decompiled with CFR 0.152.
 */
package com.iaja.ldavis;

import breeze.generic.UFunc;
import breeze.linalg.DenseMatrix;
import breeze.linalg.DenseMatrix$;
import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.linalg.ImmutableNumericOps;
import breeze.linalg.SliceMatrix;
import breeze.linalg.SliceVector;
import breeze.linalg.Tensor$;
import breeze.linalg.TensorLike;
import breeze.linalg.Transpose;
import breeze.linalg.Vector;
import breeze.linalg.argsort$;
import breeze.linalg.eig;
import breeze.linalg.eig$;
import breeze.linalg.svd;
import breeze.linalg.svd$;
import breeze.math.Semiring$;
import breeze.numerics.package;
import breeze.storage.Zero;
import com.iaja.ldavis.LDAvisMath$;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.math.Numeric;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;

public final class LDAvisMath$ {
    public static final LDAvisMath$ MODULE$;

    static {
        new LDAvisMath$();
    }

    /*
     * WARNING - void declaration
     */
    public double[] klDivergence(double[] p1, double[] p2) {
        void var3_3;
        Predef$.MODULE$.assert(p1.length == p2.length);
        double[] res = (double[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.doubleArrayOps(p1).zip((GenIterable)Predef$.MODULE$.wrapDoubleArray(p2), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(Tuple2<Object, Object> x0$1) {
                Tuple2<Object, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    double x = tuple2._1$mcD$sp();
                    double y = tuple2._2$mcD$sp();
                    double d = x;
                    double d2 = y;
                    double d3 = d > 0.0 && d2 > 0.0 ? d * Math.log(d / d2) - d + d2 : (d == 0.0 && d2 >= 0.0 ? d2 : Double.POSITIVE_INFINITY);
                    return d3;
                }
                throw new MatchError(tuple2);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        return var3_3;
    }

    public double entropy(DenseVector<Object> pk, DenseVector<Object> qk) {
        Predef$.MODULE$.assert(pk.length() == qk.length());
        double sumP = BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps(pk.toArray$mcD$sp(ClassTag$.MODULE$.Double())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
        double[] pArray = (double[])Predef$.MODULE$.doubleArrayOps(pk.toArray$mcD$sp(ClassTag$.MODULE$.Double())).map((Function1)new Serializable(sumP){
            public static final long serialVersionUID = 0L;
            private final double sumP$1;

            public final double apply(double x$1) {
                return this.apply$mcDD$sp(x$1);
            }

            public double apply$mcDD$sp(double x$1) {
                return x$1 / this.sumP$1;
            }
            {
                this.sumP$1 = sumP$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        double sumQ = BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps(qk.toArray$mcD$sp(ClassTag$.MODULE$.Double())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
        double[] qArray = (double[])Predef$.MODULE$.doubleArrayOps(qk.toArray$mcD$sp(ClassTag$.MODULE$.Double())).map((Function1)new Serializable(sumQ){
            public static final long serialVersionUID = 0L;
            private final double sumQ$1;

            public final double apply(double x$2) {
                return this.apply$mcDD$sp(x$2);
            }

            public double apply$mcDD$sp(double x$2) {
                return x$2 / this.sumQ$1;
            }
            {
                this.sumQ$1 = sumQ$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        double[] vec = this.klDivergence(pArray, qArray);
        return BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps(vec).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
    }

    public double jensenShannon(DenseVector<Object> pointP, DenseVector<Object> pointQ) {
        DenseVector meanM = (DenseVector)((ImmutableNumericOps)pointP.$plus(pointQ, DenseVector$.MODULE$.canAddD())).$times((Object)BoxesRunTime.boxToDouble((double)0.5), DenseVector$.MODULE$.dv_s_Op_Double_OpMulMatrix());
        double e1 = this.entropy(pointP, (DenseVector<Object>)meanM);
        double e2 = this.entropy(pointQ, (DenseVector<Object>)meanM);
        return 0.5 * (e1 + e2);
    }

    public DenseVector<Object> pairNDimDistance(DenseMatrix<Object> X, Function2<DenseVector<Object>, DenseVector<Object>, Object> metric) {
        int rows = X.rows();
        int cols = X.cols();
        int newDim = rows * (rows - 1) / 2;
        DenseVector dm = DenseVector$.MODULE$.zeros$mDc$sp(newDim, ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$);
        IntRef k = IntRef.create((int)0);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), rows - 1).foreach$mVc$sp((Function1)new Serializable(X, metric, rows, dm, k){
            public static final long serialVersionUID = 0L;
            public final DenseMatrix X$1;
            public final Function2 metric$1;
            private final int rows$1;
            public final DenseVector dm$1;
            public final IntRef k$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(i + 1), this.rows$1).foreach$mVc$sp((Function1)new Serializable(this, i){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.pairNDimDistance.1 $outer;
                    private final int i$1;

                    public final void apply(int j) {
                        this.apply$mcVI$sp(j);
                    }

                    public void apply$mcVI$sp(int j) {
                        DenseVector p = (DenseVector)((Transpose)this.$outer.X$1.apply((Object)BoxesRunTime.boxToInteger((int)this.i$1), (Object)package$.MODULE$.$colon$colon(), DenseMatrix$.MODULE$.canSliceRow())).inner();
                        DenseVector q = (DenseVector)((Transpose)this.$outer.X$1.apply((Object)BoxesRunTime.boxToInteger((int)j), (Object)package$.MODULE$.$colon$colon(), DenseMatrix$.MODULE$.canSliceRow())).inner();
                        this.$outer.dm$1.update$mcD$sp(this.$outer.k$1.elem, BoxesRunTime.unboxToDouble((Object)this.$outer.metric$1.apply((Object)p, (Object)q)));
                        ++this.$outer.k$1.elem;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.i$1 = i$1;
                    }
                });
            }
            {
                this.X$1 = X$1;
                this.metric$1 = metric$1;
                this.rows$1 = rows$1;
                this.dm$1 = dm$1;
                this.k$1 = k$1;
            }
        });
        return dm;
    }

    public Function2<DenseVector<Object>, DenseVector<Object>, Object> pairNDimDistance$default$2() {
        return new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(DenseVector<Object> pointP, DenseVector<Object> pointQ) {
                return LDAvisMath$.MODULE$.jensenShannon(pointP, pointQ);
            }
        };
    }

    public BigInt binomialCoefficient(int n, int r) {
        if (Math.min(r, n - r) == 0) {
            return BigInt$.MODULE$.int2bigInt(1);
        }
        BigInt qual$1 = package$.MODULE$.BigInt().apply(n - r + 1);
        BigInt x$5 = BigInt$.MODULE$.int2bigInt(n);
        BigInt x$6 = qual$1.to$default$2();
        BigInt qual$2 = package$.MODULE$.BigInt().apply(1);
        BigInt x$7 = BigInt$.MODULE$.int2bigInt(r);
        BigInt x$8 = qual$2.to$default$2();
        return ((BigInt)qual$1.to(x$5, x$6).product((Numeric)Numeric.BigIntIsIntegral$.MODULE$)).$div((BigInt)qual$2.to(x$7, x$8).product((Numeric)Numeric.BigIntIsIntegral$.MODULE$));
    }

    public DenseMatrix<Object> squareForm(DenseVector<Object> X) {
        int n = X.length();
        int d = (int)Math.ceil(Math.sqrt(n * 2));
        Predef$.MODULE$.assert(d * (d - 1) / 2 == n);
        DenseMatrix matrix = DenseMatrix$.MODULE$.zeros$mDc$sp(d, d, ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), d).foreach$mVc$sp((Function1)new Serializable(X, d, matrix){
            public static final long serialVersionUID = 0L;
            public final DenseVector X$2;
            public final int d$1;
            public final DenseMatrix matrix$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.d$1).foreach$mVc$sp((Function1)new Serializable(this, i){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.squareForm.1 $outer;
                    private final int i$2;

                    public final void apply(int j) {
                        this.apply$mcVI$sp(j);
                    }

                    public void apply$mcVI$sp(int j) {
                        int vecIndex = LDAvisMath$.MODULE$.binomialCoefficient(this.$outer.d$1, 2).$minus(LDAvisMath$.MODULE$.binomialCoefficient(this.$outer.d$1 - this.i$2, 2)).$plus(BigInt$.MODULE$.int2bigInt(j - this.i$2 - 1)).toInt();
                        if (this.i$2 == j) {
                            this.$outer.matrix$1.update$mcD$sp(this.i$2, j, 0.0);
                        } else if (this.$outer.matrix$1.apply$mcD$sp(this.i$2, j) == 0.0) {
                            this.$outer.matrix$1.update$mcD$sp(this.i$2, j, this.$outer.X$2.apply$mcD$sp(vecIndex));
                            this.$outer.matrix$1.update$mcD$sp(j, this.i$2, this.$outer.X$2.apply$mcD$sp(vecIndex));
                        }
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.i$2 = i$2;
                    }
                });
            }
            {
                this.X$2 = X$2;
                this.d$1 = d$1;
                this.matrix$1 = matrix$1;
            }
        });
        return matrix;
    }

    public double mean(Vector<Object> v) {
        return BoxesRunTime.unboxToDouble((Object)v.valuesIterator().sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) / (double)v.size();
    }

    /*
     * WARNING - void declaration
     */
    public DenseMatrix<Object> zeroMean(DenseMatrix<Object> m) {
        void var2_2;
        DenseMatrix copy = m.copy$mcD$sp();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), m.cols()).foreach((Function1)new Serializable(copy){
            public static final long serialVersionUID = 0L;
            private final DenseMatrix copy$1;

            public final DenseVector<Object> apply(int c) {
                DenseVector col = (DenseVector)this.copy$1.apply((Object)package$.MODULE$.$colon$colon(), (Object)BoxesRunTime.boxToInteger((int)c), DenseMatrix$.MODULE$.canSliceCol());
                double colMean = LDAvisMath$.MODULE$.mean((Vector<Object>)col);
                return (DenseVector)col.$minus$eq((Object)BoxesRunTime.boxToDouble((double)colMean), DenseVector$.MODULE$.dv_s_UpdateOp_Double_OpSub());
            }
            {
                this.copy$1 = copy$1;
            }
        });
        return var2_2;
    }

    public DenseMatrix<Object> PCA(DenseMatrix<Object> data, int components) {
        DenseMatrix<Object> d = this.zeroMean(data);
        Predef$.MODULE$.println((Object)new Tuple2((Object)"zeroMean: ", d));
        svd.SVD sVD = (svd.SVD)svd$.MODULE$.apply(d.t(DenseMatrix$.MODULE$.canTranspose()), (UFunc.UImpl)svd.Svd_DM_Impl$.MODULE$);
        if (sVD != null) {
            Tuple3 tuple3;
            DenseMatrix u = (DenseMatrix)sVD.leftVectors();
            DenseVector s = (DenseVector)sVD.singularValues();
            DenseMatrix v = (DenseMatrix)sVD.rightVectors();
            Tuple3 tuple32 = tuple3 = new Tuple3((Object)u, (Object)s, (Object)v);
            DenseMatrix u2 = (DenseMatrix)tuple32._1();
            DenseVector s2 = (DenseVector)tuple32._2();
            DenseMatrix v2 = (DenseMatrix)tuple32._3();
            Predef$.MODULE$.println((Object)new Tuple4((Object)"v: ", (Object)BoxesRunTime.boxToInteger((int)v2.rows()), (Object)BoxesRunTime.boxToInteger((int)v2.cols()), (Object)v2));
            DenseMatrix model = (DenseMatrix)v2.apply((Object)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), components), (Object)package$.MODULE$.$colon$colon(), DenseMatrix$.MODULE$.canSliceRows());
            Predef$.MODULE$.println((Object)new Tuple3((Object)"Model: ", (Object)BoxesRunTime.boxToInteger((int)model.rows()), (Object)BoxesRunTime.boxToInteger((int)model.cols())));
            Predef$.MODULE$.println((Object)new Tuple3((Object)"Model.T: ", (Object)BoxesRunTime.boxToInteger((int)((DenseMatrix)model.t(DenseMatrix$.MODULE$.canTranspose())).rows()), (Object)BoxesRunTime.boxToInteger((int)((DenseMatrix)model.t(DenseMatrix$.MODULE$.canTranspose())).cols())));
            DenseMatrix filter = (DenseMatrix)((ImmutableNumericOps)model.t(DenseMatrix$.MODULE$.canTranspose())).$times((Object)model, (UFunc.UImpl2)DenseMatrix$.MODULE$.implOpMulMatrix_DMD_DMD_eq_DMD());
            Predef$.MODULE$.println((Object)new Tuple3((Object)"filter: ", (Object)BoxesRunTime.boxToInteger((int)filter.rows()), (Object)BoxesRunTime.boxToInteger((int)filter.cols())));
            return (DenseMatrix)filter.$times(d, (UFunc.UImpl2)DenseMatrix$.MODULE$.implOpMulMatrix_DMD_DMD_eq_DMD());
        }
        throw new MatchError((Object)sVD);
    }

    public DenseMatrix<Object> PCoA(DenseMatrix<Object> pairDistMatrix, int numComponents) {
        int n = pairDistMatrix.rows();
        DenseMatrix H = (DenseMatrix)DenseMatrix$.MODULE$.eye$mDc$sp(n, ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$, Semiring$.MODULE$.semiringD()).$minus(DenseMatrix$.MODULE$.ones$mDc$sp(n, n, ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$, Semiring$.MODULE$.semiringD()).mapValues$mcD$sp((Function1)new Serializable(n){
            public static final long serialVersionUID = 0L;
            private final int n$1;

            public final double apply(double x$4) {
                return this.apply$mcDD$sp(x$4);
            }

            public double apply$mcDD$sp(double x$4) {
                return x$4 / (double)this.n$1;
            }
            {
                this.n$1 = n$1;
            }
        }, DenseMatrix$.MODULE$.canMapValues$mDDc$sp(ClassTag$.MODULE$.Double())), DenseMatrix$.MODULE$.op_DM_DM_Double_OpSub());
        DenseMatrix squaredPairDistMatrix = (DenseMatrix)pairDistMatrix.mapValues$mcD$sp((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(double x) {
                return this.apply$mcDD$sp(x);
            }

            public double apply$mcDD$sp(double x) {
                return x * x;
            }
        }, DenseMatrix$.MODULE$.canMapValues$mDDc$sp(ClassTag$.MODULE$.Double()));
        DenseMatrix B = (DenseMatrix)((TensorLike)((ImmutableNumericOps)H.$times((Object)squaredPairDistMatrix, (UFunc.UImpl2)DenseMatrix$.MODULE$.implOpMulMatrix_DMD_DMD_eq_DMD())).$times((Object)H, (UFunc.UImpl2)DenseMatrix$.MODULE$.implOpMulMatrix_DMD_DMD_eq_DMD())).mapValues$mcD$sp((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(double x) {
                return this.apply$mcDD$sp(x);
            }

            public double apply$mcDD$sp(double x) {
                return -x / (double)2;
            }
        }, DenseMatrix$.MODULE$.canMapValues$mDDc$sp(ClassTag$.MODULE$.Double()));
        DenseVector eigvals = (DenseVector)((eig.Eig)eig$.MODULE$.apply((Object)B, (UFunc.UImpl)eig.Eig_DM_Impl$.MODULE$)).eigenvalues();
        DenseMatrix eigvecs = (DenseMatrix)((eig.Eig)eig$.MODULE$.apply((Object)B, (UFunc.UImpl)eig.Eig_DM_Impl$.MODULE$)).eigenvectors();
        IndexedSeq ix = ((TraversableOnce)((IterableLike)((SeqLike)argsort$.MODULE$.apply((Object)eigvals, argsort$.MODULE$.argsortDenseVector_Double())).reverse()).take(numComponents)).toIndexedSeq();
        SliceVector slicedEigenVals = (SliceVector)eigvals.apply((Object)ix, Tensor$.MODULE$.canSliceTensor(ClassTag$.MODULE$.Double()));
        SliceMatrix slicedEigenVec = (SliceMatrix)eigvecs.apply((Object)package$.MODULE$.$colon$colon(), (Object)ix, DenseMatrix$.MODULE$.canSliceWeirdCols(Semiring$.MODULE$.semiringD(), ClassTag$.MODULE$.Double()));
        DenseMatrix m = slicedEigenVec.toDenseMatrix$mcD$sp(ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$);
        DenseVector v = (DenseVector)package.sqrt$.MODULE$.apply((Object)slicedEigenVals.toDenseVector$mcD$sp(ClassTag$.MODULE$.Double()), package.sqrt$.MODULE$.fromLowOrderCanMapValues(DenseVector$.MODULE$.scalarOf(), (UFunc.UImpl)package.sqrt$.sqrtDoubleImpl$.MODULE$, DenseVector$.MODULE$.canMapValues$mDDc$sp(ClassTag$.MODULE$.Double())));
        DenseMatrix<Object> res = this.matVecElementWiseOp((DenseMatrix<Object>)m, (DenseVector<Object>)v, (Function2<Object, Object, Object>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(double x, double y) {
                return this.apply$mcDDD$sp(x, y);
            }

            public double apply$mcDDD$sp(double x, double y) {
                return x * y;
            }
        });
        return res;
    }

    public int PCoA$default$2() {
        return 2;
    }

    public DenseMatrix<Object> matVecElementWiseOp(DenseMatrix<Object> mat, DenseVector<Object> vec, Function2<Object, Object, Object> op) {
        return (DenseMatrix)mat.mapPairs((Function2)new Serializable(vec, op){
            public static final long serialVersionUID = 0L;
            private final DenseVector vec$1;
            private final Function2 op$1;

            public final double apply(Tuple2<Object, Object> x0$2, double x1$1) {
                Tuple2 tuple2 = new Tuple2(x0$2, (Object)BoxesRunTime.boxToDouble((double)x1$1));
                if (tuple2 != null) {
                    Tuple2 tuple22 = (Tuple2)tuple2._1();
                    double value = tuple2._2$mcD$sp();
                    if (tuple22 != null) {
                        int col = tuple22._2$mcI$sp();
                        double d = this.op$1.apply$mcDDD$sp(value, this.vec$1.apply$mcD$sp(col));
                        return d;
                    }
                }
                throw new MatchError((Object)tuple2);
            }
            {
                this.vec$1 = vec$1;
                this.op$1 = op$1;
            }
        }, DenseMatrix$.MODULE$.canMapKeyValuePairs(ClassTag$.MODULE$.Double()));
    }

    private LDAvisMath$() {
        MODULE$ = this;
    }
}

