/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.maven_replacer_plugin;

import com.google.code.maven_replacer_plugin.Replacement;
import com.google.code.maven_replacer_plugin.Replacer;
import com.google.code.maven_replacer_plugin.TokenReplacer;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.ReadContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public class JsonPathReplacer
implements Replacer {
    private final TokenReplacer tokenReplacer;
    private final Configuration jsonConfig;
    private final Gson gson;

    public JsonPathReplacer(TokenReplacer tokenReplacer) {
        try {
            if (tokenReplacer == null) {
                throw new IllegalArgumentException("Must supply a tokenReplacer to change the node's content.");
            }
            this.tokenReplacer = tokenReplacer;
            this.jsonConfig = Configuration.builder().options(new Option[]{Option.AS_PATH_LIST}).build();
            this.gson = new GsonBuilder().serializeNulls().setPrettyPrinting().create();
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to initialise JSON processing: " + e.getMessage(), e);
        }
    }

    @Override
    public String replace(String content, Replacement replacement, boolean regex, int regexFlags) {
        try {
            ReadContext doc = this.parseJson(content);
            List<String> replacementTargets = this.findReplacementNodes(doc, replacement.getJsonpath());
            if (replacementTargets.size() > 0) {
                JsonParser parser = new JsonParser();
                JsonElement element = parser.parse(content);
                this.replaceContent(replacementTargets, replacement, regex, regexFlags, element);
                return this.gson.toJson(element);
            }
            return content;
        }
        catch (Exception e) {
            String cause = e.getMessage() != null ? e.getMessage() : e.getCause().getMessage();
            throw new RuntimeException("Error during JSON replacement: " + cause, e);
        }
    }

    List<Object> getPathSegemnts(String path) {
        ArrayList<Object> nodeSegments = new ArrayList<Object>();
        StringTokenizer st = new StringTokenizer(path, "]");
        while (st.hasMoreElements()) {
            String token = st.nextToken();
            if (token.charAt(1) == '\'') {
                String name = token.substring(2, token.length() - 1);
                nodeSegments.add(name);
                continue;
            }
            Integer index = Integer.valueOf(token.substring(1));
            nodeSegments.add(index);
        }
        return nodeSegments;
    }

    private JsonElement getTargetJsonObject(JsonElement jsonElement, Iterator<Object> iterator) {
        if (iterator.hasNext()) {
            Object segment = iterator.next();
            JsonElement sibblingElement = null;
            sibblingElement = segment instanceof Integer ? jsonElement.getAsJsonArray().get(((Integer)segment).intValue()) : jsonElement.getAsJsonObject().get((String)segment);
            return this.getTargetJsonObject(sibblingElement, iterator);
        }
        return jsonElement;
    }

    private void replaceContent(List<String> replacementNodes, Replacement replacement, boolean regex, int regexFlags, JsonElement jsonElement) throws Exception {
        for (int i = 0; i < replacementNodes.size(); ++i) {
            JsonElement value;
            String replacedValue;
            String source;
            String replacementNode = replacementNodes.get(i);
            List<Object> nodeSegments = this.getPathSegemnts(replacementNode.substring(1));
            JsonElement target = this.getTargetJsonObject(jsonElement, nodeSegments.subList(0, nodeSegments.size() - 1).iterator());
            Object targetNode = nodeSegments.get(nodeSegments.size() - 1);
            if (targetNode instanceof Integer) {
                JsonElement item = target.getAsJsonArray().get(((Integer)targetNode).intValue());
                source = item.isJsonPrimitive() || item.isJsonNull() ? item.getAsString() : item.toString();
                replacedValue = this.tokenReplacer.replace(source, replacement, regex, regexFlags);
                value = this.normalizeValue(replacedValue, replacement);
                target.getAsJsonArray().set(((Integer)targetNode).intValue(), value);
                continue;
            }
            JsonElement property = target.getAsJsonObject().get((String)targetNode);
            source = property.isJsonPrimitive() || property.isJsonNull() ? property.getAsString() : property.toString();
            replacedValue = this.tokenReplacer.replace(source, replacement, regex, regexFlags);
            value = this.normalizeValue(replacedValue, replacement);
            target.getAsJsonObject().add((String)targetNode, value);
        }
    }

    private JsonElement normalizeValue(String value, Replacement replacement) {
        if ("string".equals(replacement.getJsontype()) || replacement.getJsontype() == null) {
            return new JsonPrimitive(value);
        }
        if ("number".equals(replacement.getJsontype())) {
            if (value.contains(".")) {
                return new JsonPrimitive((Number)new Double(value));
            }
            return new JsonPrimitive((Number)new Long(value));
        }
        if ("object".equals(replacement.getJsontype())) {
            return new JsonParser().parse(value);
        }
        if ("true".equals(replacement.getJsontype())) {
            return new JsonPrimitive(Boolean.valueOf(true));
        }
        if ("false".equals(replacement.getJsontype())) {
            return new JsonPrimitive(Boolean.valueOf(false));
        }
        if ("null".equals(replacement.getJsontype())) {
            return JsonNull.INSTANCE;
        }
        throw new IllegalArgumentException("Json type '" + replacement.getJsontype() + "' not supported. Supported values are [string|number|object|array|true|false|null");
    }

    private ReadContext parseJson(String content) throws Exception {
        return JsonPath.using((Configuration)this.jsonConfig).parse(content);
    }

    private List<String> findReplacementNodes(ReadContext doc, String jsonpathString) throws Exception {
        try {
            return (List)doc.read(jsonpathString, new Predicate[0]);
        }
        catch (Exception e) {
            return Collections.EMPTY_LIST;
        }
    }
}

