/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.maven_replacer_plugin;

import com.google.code.maven_replacer_plugin.ReplacerMojo;
import com.google.code.maven_replacer_plugin.file.FileUtils;
import java.io.File;

public class OutputFilenameBuilder {
    private final FileUtils fileUtils = new FileUtils();

    public String buildFrom(String inputFilename, ReplacerMojo mojo) {
        String based = this.buildOutputFile(inputFilename, mojo);
        if (mojo.getInputFilePattern() != null && mojo.getOutputFilePattern() != null) {
            based = based.replaceAll(mojo.getInputFilePattern(), mojo.getOutputFilePattern());
        }
        return based;
    }

    private String buildOutputFile(String inputFilename, ReplacerMojo mojo) {
        String basedir;
        String string = basedir = this.fileUtils.isAbsolutePath(inputFilename) ? "" : mojo.getBasedir();
        if (mojo.getOutputDir() != null && mojo.getOutputFile() != null) {
            String cleanResult;
            String string2 = cleanResult = mojo.isPreserveDir() ? mojo.getOutputFile() : this.stripPath(mojo.getOutputFile());
            if (mojo.getOutputBasedir() != null) {
                return this.fileUtils.createFullPath(mojo.getOutputBasedir(), mojo.getOutputDir(), cleanResult);
            }
            return this.fileUtils.createFullPath(basedir, mojo.getOutputDir(), cleanResult);
        }
        if (mojo.getOutputDir() != null) {
            String cleanResult;
            String string3 = cleanResult = mojo.isPreserveDir() ? inputFilename : this.stripPath(inputFilename);
            if (mojo.getOutputBasedir() != null) {
                return this.fileUtils.createFullPath(mojo.getOutputBasedir(), mojo.getOutputDir(), cleanResult);
            }
            return this.fileUtils.createFullPath(basedir, mojo.getOutputDir(), cleanResult);
        }
        if (mojo.getOutputFile() != null) {
            File outFile = new File(mojo.getOutputFile());
            if (outFile.isAbsolute()) {
                return this.fileUtils.createFullPath(mojo.getOutputFile());
            }
            return this.fileUtils.createFullPath(basedir, mojo.getOutputFile());
        }
        return this.fileUtils.createFullPath(basedir, inputFilename);
    }

    private String stripPath(String inputFilename) {
        return new File(inputFilename).getName();
    }

    public String buildFrom(String inputFilename, ReplacerMojo mojo, int index) {
        String based = this.buildOutputFile(inputFilename, mojo, index);
        return based;
    }

    private String buildOutputFile(String inputFilename, ReplacerMojo mojo, int index) {
        String basedir = "";
        if (!mojo.getOutputFiles().isEmpty()) {
            File outFile = new File(mojo.getOutputFiles().get(index));
            if (outFile.isAbsolute()) {
                return this.fileUtils.createFullPath(mojo.getOutputFiles().get(index));
            }
            return this.fileUtils.createFullPath(basedir, mojo.getOutputFiles().get(index));
        }
        return this.fileUtils.createFullPath(basedir, inputFilename);
    }
}

