/*
 * Decompiled with CFR 0.152.
 */
package io.itit.smartjdbc.spring;

import io.itit.smartjdbc.spring.SqlSession;
import io.itit.smartjdbc.spring.SqlSessionFactory;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class SmartJdbcTransactionSynchronizationAdapter
extends TransactionSynchronizationAdapter {
    private SqlSessionFactory sessionFactory;

    public SmartJdbcTransactionSynchronizationAdapter(SqlSessionFactory mySessionFactory) {
        this.sessionFactory = mySessionFactory;
    }

    public void beforeCommit(boolean readOnly) {
        if (!readOnly) {
            SqlSession mySession = (SqlSession)TransactionSynchronizationManager.getResource((Object)this.sessionFactory);
            mySession.beginTransaction();
        }
    }

    public void afterCompletion(int status) {
        SqlSession mySession = (SqlSession)TransactionSynchronizationManager.getResource((Object)this.sessionFactory);
        if (0 == status) {
            mySession.commit();
        } else if (1 == status) {
            mySession.rollback();
        }
    }
}

