/*
 * Decompiled with CFR 0.152.
 */
package io.itit.smartjdbc.spring;

import io.itit.smartjdbc.SqlInterceptor;
import io.itit.smartjdbc.connection.TransactionManager;
import io.itit.smartjdbc.spring.SmartJdbcTransactionSynchronizationAdapter;
import io.itit.smartjdbc.spring.SqlSession;
import io.itit.smartjdbc.util.DumpUtil;
import java.sql.Connection;
import java.util.UUID;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class SqlSessionFactory
implements TransactionManager,
SqlInterceptor {
    private static Logger logger = LoggerFactory.getLogger(SqlSessionFactory.class);
    private DataSource dataSource;
    private static ThreadLocal<SqlSession> sqlSessions = new ThreadLocal();

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public SqlSession getSession() {
        if (TransactionSynchronizationManager.hasResource((Object)this)) {
            return this.getCurrentSession();
        }
        return this.openSession();
    }

    private SqlSession openSession() {
        SqlSession session = new SqlSession(this);
        session.setSessionId(UUID.randomUUID().toString());
        Connection conn = DataSourceUtils.getConnection((DataSource)this.dataSource);
        session.setConnection(conn);
        if (TransactionSynchronizationManager.isSynchronizationActive()) {
            SmartJdbcTransactionSynchronizationAdapter transactionSynchronization = new SmartJdbcTransactionSynchronizationAdapter(this);
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)transactionSynchronization);
            TransactionSynchronizationManager.bindResource((Object)this, (Object)session);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("openSession mySession:{}", (Object)session.getSessionId());
        }
        sqlSessions.set(session);
        return session;
    }

    private SqlSession getCurrentSession() {
        SqlSession mySession = (SqlSession)TransactionSynchronizationManager.getResource((Object)this);
        return mySession;
    }

    public void commit() {
    }

    public void rollback() {
    }

    public Connection getConnecton(String datasourceIndex) {
        SqlSession session = this.getSession();
        return session.getConnection();
    }

    public void beforeExcute(String sql, Object ... parameters) {
        if (logger.isDebugEnabled()) {
            logger.debug("beforeExcute sql:[{}] parameters:[{}] isSynchronizationActive:[{}]", new Object[]{sql, DumpUtil.dump((Object)parameters), TransactionSynchronizationManager.isSynchronizationActive()});
        }
    }

    public void afterExcute(String sql, Object ... parameters) {
        if (logger.isDebugEnabled()) {
            logger.debug("afterExcute sql:[{}] parameters:[{}] isSynchronizationActive:[{}]", new Object[]{sql, DumpUtil.dump((Object)parameters), TransactionSynchronizationManager.isSynchronizationActive()});
        }
        if (!TransactionSynchronizationManager.isSynchronizationActive()) {
            this.closeConnection();
        }
    }

    public void closeConnection() {
        try {
            TransactionSynchronizationManager.unbindResourceIfPossible((Object)this);
            SqlSession session = sqlSessions.get();
            session.getConnection().close();
            sqlSessions.set(null);
            if (logger.isDebugEnabled()) {
                logger.debug("closeConnection sessionId:[{}]", (Object)session.getSessionId());
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }
}

