/*
 * Decompiled with CFR 0.152.
 */
package com.github.igor_petruk.protobuf.maven.plugin;

import com.github.igor_petruk.protobuf.maven.plugin.ProtoFileFilter;
import java.io.File;
import java.io.IOException;
import java.util.Scanner;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactCollector;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.dependency.tree.DependencyNode;
import org.apache.maven.shared.dependency.tree.DependencyTreeBuilder;
import org.apache.maven.shared.dependency.tree.DependencyTreeBuilderException;
import org.sonatype.plexus.build.incremental.BuildContext;

public class MyMojo
extends AbstractMojo {
    private static final String DEFAULT_INPUT_DIR = "/src/main/protobuf/".replace('/', File.separatorChar);
    private static final String PROTOBUF_GROUPID = "com.google.protobuf";
    private static final String PROTOBUF_ARTIFACTID = "protobuf-java";
    private static final String PROTOC = "protoc";
    private static final String VERSION_KEY = "--version";
    private MavenProject project;
    private ArtifactRepository localRepository;
    private ArtifactFactory artifactFactory;
    private ArtifactMetadataSource artifactMetadataSource;
    private ArtifactCollector artifactCollector;
    private DependencyTreeBuilder dependencyTreeBuilder;
    private BuildContext buildContext;
    private File[] inputDirectories;
    private boolean addSources;
    private File outputDirectory;
    private String extension;
    private boolean ignoreVersions;

    public void execute() throws MojoExecutionException {
        String dependencyVersion = this.getProtobufVersion();
        this.getLog().info((CharSequence)("Protobuf dependency version " + dependencyVersion));
        String executableVersion = this.detectProtobufVersion();
        if (executableVersion == null) {
            throw new MojoExecutionException("Unable to find 'protoc'");
        }
        this.getLog().info((CharSequence)("'protoc' executable version " + executableVersion));
        if (!this.ignoreVersions && !dependencyVersion.startsWith(executableVersion)) {
            throw new MojoExecutionException("Protobuf installation version does not match Protobuf library version");
        }
        this.performProtoCompilation();
    }

    private void performProtoCompilation() throws MojoExecutionException {
        File f = this.outputDirectory;
        if (!f.exists()) {
            f.mkdirs();
        }
        if (this.inputDirectories.length == 0) {
            File inputDir = new File(this.project.getBasedir().getAbsolutePath() + DEFAULT_INPUT_DIR);
            this.inputDirectories = new File[]{inputDir};
        }
        this.getLog().info((CharSequence)"Input directories:");
        for (File input : this.inputDirectories) {
            this.getLog().info((CharSequence)("    " + input));
        }
        this.getLog().info((CharSequence)("Output directory: " + this.outputDirectory));
        ProtoFileFilter PROTO_FILTER = new ProtoFileFilter(this.extension);
        for (File input : this.inputDirectories) {
            File[] files;
            this.getLog().info((CharSequence)("Directory " + input));
            for (File file : files = input.listFiles(PROTO_FILTER)) {
                if (this.buildContext.hasDelta(file.getPath())) {
                    this.processFile(file, this.outputDirectory);
                    continue;
                }
                this.getLog().info((CharSequence)("Not changed " + file));
            }
        }
        if (this.addSources) {
            this.project.addCompileSourceRoot(this.outputDirectory.getAbsolutePath());
            this.buildContext.refresh(this.outputDirectory);
        }
    }

    private void processFile(File file, File outputDir) throws MojoExecutionException {
        this.getLog().info((CharSequence)("    Processing " + file.getName()));
        Runtime runtime = Runtime.getRuntime();
        try {
            Process process = runtime.exec(new String[]{PROTOC, "--proto_path=" + file.getParentFile().getAbsolutePath(), "--java_out=" + outputDir, file.toString()});
            int result = process.waitFor();
            if (result != 0) {
                Scanner scanner = new Scanner(process.getErrorStream());
                while (scanner.hasNextLine()) {
                    this.getLog().info((CharSequence)("    " + scanner.nextLine()));
                }
                throw new MojoExecutionException("'protoc' failed for " + file + ". Exit code " + result);
            }
        }
        catch (InterruptedException e) {
            throw new MojoExecutionException("Interrupted", (Exception)e);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to execute protoc for " + file, (Exception)e);
        }
    }

    private String getProtobufVersion() throws MojoExecutionException {
        try {
            Object artifactFilter = null;
            DependencyNode node = this.dependencyTreeBuilder.buildDependencyTree(this.project, this.localRepository, this.artifactFactory, this.artifactMetadataSource, null, this.artifactCollector);
            return this.traverseNode(node);
        }
        catch (DependencyTreeBuilderException e) {
            throw new MojoExecutionException("Unable to traverse dependency tree", (Exception)((Object)e));
        }
    }

    private String detectProtobufVersion() throws MojoExecutionException {
        Runtime runtime = Runtime.getRuntime();
        try {
            Process process = runtime.exec(new String[]{PROTOC, VERSION_KEY});
            Scanner scanner = new Scanner(process.getInputStream());
            String[] version = scanner.nextLine().split(" ");
            return version[1];
        }
        catch (IOException e) {
            return null;
        }
    }

    private String traverseNode(DependencyNode node) {
        Artifact artifact = node.getArtifact();
        if (PROTOBUF_GROUPID.equals(artifact.getGroupId()) && PROTOBUF_ARTIFACTID.equals(artifact.getArtifactId())) {
            return artifact.getVersion();
        }
        for (Object o : node.getChildren()) {
            DependencyNode child = (DependencyNode)o;
            String result = this.traverseNode(child);
            if (result == null) continue;
            return result;
        }
        return null;
    }
}

