/*
 * Decompiled with CFR 0.152.
 */
package com.github.igor_petruk.protobuf.maven.plugin;

import com.github.igor_petruk.protobuf.maven.plugin.ProtoFileFilter;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Scanner;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactCollector;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.dependency.tree.DependencyNode;
import org.apache.maven.shared.dependency.tree.DependencyTreeBuilder;
import org.apache.maven.shared.dependency.tree.DependencyTreeBuilderException;
import org.codehaus.plexus.util.FileUtils;
import org.sonatype.plexus.build.incremental.BuildContext;

public class RunMojo
extends AbstractMojo {
    private static final String DEFAULT_INPUT_DIR = "/src/main/protobuf/".replace('/', File.separatorChar);
    private static final String VERSION_KEY = "--version";
    private static final int VALID_VERSION_EXIT_CODE = 1;
    private MavenProject project;
    private ArtifactRepository localRepository;
    private ArtifactFactory artifactFactory;
    private ArtifactMetadataSource artifactMetadataSource;
    private ArtifactCollector artifactCollector;
    private DependencyTreeBuilder dependencyTreeBuilder;
    private BuildContext buildContext;
    private File[] inputDirectories;
    private File[] includeDirectories;
    private boolean cleanOutputFolder;
    private String addSources;
    private File outputDirectory;
    private String extension;
    private boolean ignoreVersions;
    private String protocCommand;
    private String protobufGroupId;
    private String protobufArtifactId;

    public void execute() throws MojoExecutionException {
        if (this.project.getPackaging() != null && "pom".equals(this.project.getPackaging().toLowerCase())) {
            this.getLog().info((CharSequence)"Skipping 'pom' packaged project");
            return;
        }
        String dependencyVersion = this.getProtobufVersion();
        this.getLog().info((CharSequence)("Protobuf dependency version " + dependencyVersion));
        String executableVersion = this.detectProtobufVersion();
        if (executableVersion == null) {
            throw new MojoExecutionException("Unable to find '" + this.protocCommand + "'");
        }
        this.getLog().info((CharSequence)("'protoc' executable version " + executableVersion));
        if (!this.ignoreVersions) {
            if (dependencyVersion == null) {
                throw new MojoExecutionException("Protobuf library dependency not found in pom: " + this.protobufGroupId + ":" + this.protobufArtifactId);
            }
            if (!dependencyVersion.startsWith(executableVersion)) {
                throw new MojoExecutionException("Protobuf installation version does not match Protobuf library version");
            }
        }
        this.addSources = this.addSources.toLowerCase().trim();
        if ("true".equals(this.addSources)) {
            this.addSources = "main";
        }
        if (this.outputDirectory == null) {
            String subdir = "generated-" + ("test".equals(this.addSources) ? "test-" : "") + "sources";
            this.outputDirectory = new File(this.project.getBuild().getDirectory() + File.separator + subdir + File.separator);
        }
        this.performProtoCompilation();
    }

    private void performProtoCompilation() throws MojoExecutionException {
        if (this.includeDirectories != null && this.includeDirectories.length > 0) {
            this.getLog().info((CharSequence)"Include directories:");
            for (File include : this.includeDirectories) {
                this.getLog().info((CharSequence)("    " + include));
            }
        }
        this.getLog().info((CharSequence)"Input directories:");
        for (File input : this.inputDirectories) {
            this.getLog().info((CharSequence)("    " + input));
        }
        if (this.includeDirectories == null || this.inputDirectories.length == 0) {
            File inputDir = new File(this.project.getBasedir().getAbsolutePath() + DEFAULT_INPUT_DIR);
            this.getLog().info((CharSequence)("    " + inputDir + " (using default)"));
            this.inputDirectories = new File[]{inputDir};
        }
        this.getLog().info((CharSequence)("Output directory: " + this.outputDirectory));
        File f = this.outputDirectory;
        if (!f.exists()) {
            this.getLog().info((CharSequence)(f + " does not exist. Creating..."));
            f.mkdirs();
        }
        if (this.cleanOutputFolder) {
            try {
                this.getLog().info((CharSequence)("Cleaning " + f));
                FileUtils.cleanDirectory((File)f);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        ProtoFileFilter PROTO_FILTER = new ProtoFileFilter(this.extension);
        for (File input : this.inputDirectories) {
            if (input == null) continue;
            this.getLog().info((CharSequence)("Directory " + input));
            if (input.exists() && input.isDirectory()) {
                File[] files;
                for (File file : files = input.listFiles(PROTO_FILTER)) {
                    if (this.cleanOutputFolder || this.buildContext.hasDelta(file.getPath())) {
                        this.processFile(file, this.outputDirectory);
                        continue;
                    }
                    this.getLog().info((CharSequence)("Not changed " + file));
                }
                continue;
            }
            if (input.exists()) {
                this.getLog().warn((CharSequence)(input + " is not a directory"));
                continue;
            }
            this.getLog().warn((CharSequence)(input + " does not exist"));
        }
        boolean mainAddSources = "main".endsWith(this.addSources);
        boolean testAddSources = "test".endsWith(this.addSources);
        if (mainAddSources) {
            this.getLog().info((CharSequence)"Adding generated classes to classpath");
            this.project.addCompileSourceRoot(this.outputDirectory.getAbsolutePath());
        }
        if (testAddSources) {
            this.getLog().info((CharSequence)"Adding generated classes to test classpath");
            this.project.addTestCompileSourceRoot(this.outputDirectory.getAbsolutePath());
        }
        if (mainAddSources || testAddSources) {
            this.buildContext.refresh(this.outputDirectory);
        }
    }

    private void processFile(File file, File outputDir) throws MojoExecutionException {
        this.getLog().info((CharSequence)("    Processing " + file.getName()));
        Runtime runtime = Runtime.getRuntime();
        Collection<String> cmd = this.buildCommand(file, outputDir);
        try {
            Process process = runtime.exec(cmd.toArray(new String[0]));
            if (process.waitFor() != 0) {
                this.printErrorAndThrow(process, " for " + file);
            }
        }
        catch (InterruptedException e) {
            throw new MojoExecutionException("Interrupted", (Exception)e);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to execute protoc for " + file, (Exception)e);
        }
    }

    private Collection<String> buildCommand(File file, File outputDir) throws MojoExecutionException {
        LinkedList<String> cmd = new LinkedList<String>();
        cmd.add(this.protocCommand);
        this.populateIncludes(cmd);
        cmd.add("-I" + file.getParentFile().getAbsolutePath());
        cmd.add("--java_out=" + outputDir);
        cmd.add(file.toString());
        return cmd;
    }

    private void populateIncludes(Collection<String> args) throws MojoExecutionException {
        for (File include : this.includeDirectories) {
            if (!include.exists()) {
                throw new MojoExecutionException("Include path '" + include.getPath() + "' does not exist");
            }
            if (!include.isDirectory()) {
                throw new MojoExecutionException("Include path '" + include.getPath() + "' is not a directory");
            }
            args.add("-I" + include.getPath());
        }
    }

    private String getProtobufVersion() throws MojoExecutionException {
        try {
            Object artifactFilter = null;
            DependencyNode node = this.dependencyTreeBuilder.buildDependencyTree(this.project, this.localRepository, this.artifactFactory, this.artifactMetadataSource, null, this.artifactCollector);
            return this.traverseNode(node);
        }
        catch (DependencyTreeBuilderException e) {
            throw new MojoExecutionException("Unable to traverse dependency tree", (Exception)((Object)e));
        }
    }

    private String detectProtobufVersion() throws MojoExecutionException {
        try {
            Runtime runtime = Runtime.getRuntime();
            Process process = runtime.exec(this.protocVersionCommand());
            if (process.waitFor() == 1) {
                Scanner scanner = new Scanner(process.getInputStream());
                String[] version = scanner.nextLine().split(" ");
                return version[1];
            }
            this.printErrorAndThrow(process);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Cannot execute '" + this.protocCommand + "'", (Exception)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return null;
    }

    private String[] protocVersionCommand() {
        return new String[]{this.protocCommand, VERSION_KEY};
    }

    private void printErrorAndThrow(Process process, String exceptionMessage) throws MojoExecutionException {
        Scanner scanner = new Scanner(process.getErrorStream());
        while (scanner.hasNextLine()) {
            this.getLog().error((CharSequence)("    " + scanner.nextLine()));
        }
        throw new MojoExecutionException("'protoc' failed" + exceptionMessage + ". Exit code " + process.exitValue());
    }

    private void printErrorAndThrow(Process process) throws MojoExecutionException {
        this.printErrorAndThrow(process, "");
    }

    private String traverseNode(DependencyNode node) {
        Artifact artifact = node.getArtifact();
        if (this.protobufGroupId.equals(artifact.getGroupId()) && this.protobufArtifactId.equals(artifact.getArtifactId())) {
            return artifact.getVersion();
        }
        for (Object o : node.getChildren()) {
            DependencyNode child = (DependencyNode)o;
            String result = this.traverseNode(child);
            if (result == null) continue;
            return result;
        }
        return null;
    }
}

