/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository;

import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import org.springframework.data.repository.NoRepositoryBean;
import org.springframework.data.repository.Repository;
import org.springframework.lang.Nullable;

@NoRepositoryBean
public interface CrudRepository<T, ID extends Serializable>
extends Repository<T, ID> {
    public <S extends T> S save(S var1);

    public <S extends T> Iterable<S> saveAll(Iterable<S> var1);

    public Optional<T> findById(ID var1);

    public boolean existsById(ID var1);

    public Iterable<T> findAll();

    public Iterable<T> findAllById(Iterable<ID> var1);

    public long count();

    public void deleteById(ID var1);

    public void delete(T var1);

    public void deleteAll(Iterable<? extends T> var1);

    public void deleteAll();

    @Nullable
    default public T findOne(ID id) {
        return this.findById(id).orElse(null);
    }

    default public void delete(ID id) {
        this.deleteById(id);
    }

    default public boolean exists(ID id) {
        return this.existsById(id);
    }

    default public List<T> findAll(Iterable<ID> ids) {
        return (List)this.findAllById(ids);
    }

    default public <S extends T> List<S> save(Iterable<S> entities) {
        return (List)this.saveAll(entities);
    }

    default public void delete(Iterable<? extends T> entities) {
        this.deleteAll(entities);
    }
}

