/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.internal.ui.ribbon.appmenu;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import org.pushingpixels.flamingo.api.common.AbstractCommandButton;
import org.pushingpixels.flamingo.api.common.CommandButtonDisplayState;
import org.pushingpixels.flamingo.api.common.CommandButtonLayoutManager;
import org.pushingpixels.flamingo.api.common.JCommandButton;
import org.pushingpixels.flamingo.api.common.JCommandMenuButton;
import org.pushingpixels.flamingo.api.common.RolloverActionListener;
import org.pushingpixels.flamingo.api.common.popup.JPopupPanel;
import org.pushingpixels.flamingo.api.ribbon.RibbonApplicationMenu;
import org.pushingpixels.flamingo.api.ribbon.RibbonApplicationMenuEntryFooter;
import org.pushingpixels.flamingo.api.ribbon.RibbonApplicationMenuEntryPrimary;
import org.pushingpixels.flamingo.internal.ui.common.popup.BasicPopupPanelUI;
import org.pushingpixels.flamingo.internal.ui.ribbon.appmenu.CommandButtonLayoutManagerMenuTileLevel1;
import org.pushingpixels.flamingo.internal.ui.ribbon.appmenu.JRibbonApplicationMenuButton;
import org.pushingpixels.flamingo.internal.ui.ribbon.appmenu.JRibbonApplicationMenuPopupPanel;
import org.pushingpixels.flamingo.internal.ui.ribbon.appmenu.JRibbonApplicationMenuPopupPanelSecondary;
import org.pushingpixels.flamingo.internal.utils.FlamingoUtilities;

public class BasicRibbonApplicationMenuPopupPanelUI
extends BasicPopupPanelUI {
    protected JPanel panelLevel1;
    protected JPanel panelLevel2;
    protected JPanel footerPanel;
    protected static final CommandButtonDisplayState MENU_TILE_LEVEL_1 = new CommandButtonDisplayState("Ribbon application menu tile level 1", 32){

        @Override
        public CommandButtonLayoutManager createLayoutManager(AbstractCommandButton commandButton) {
            return new CommandButtonLayoutManagerMenuTileLevel1();
        }
    };
    protected JRibbonApplicationMenuPopupPanel applicationMenuPopupPanel;
    protected JPanel mainPanel;

    public static ComponentUI createUI(JComponent c) {
        return new BasicRibbonApplicationMenuPopupPanelUI();
    }

    @Override
    public void installUI(JComponent c) {
        this.applicationMenuPopupPanel = (JRibbonApplicationMenuPopupPanel)c;
        this.popupPanel = (JPopupPanel)c;
        this.applicationMenuPopupPanel.setLayout(new BorderLayout());
        this.installDefaults();
        this.installComponents();
        this.installListeners();
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.uninstallListeners();
        this.uninstallComponents();
        this.uninstallDefaults();
        this.applicationMenuPopupPanel = null;
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
    }

    @Override
    protected void installComponents() {
        super.installComponents();
        this.mainPanel = this.createMainPanel();
        this.panelLevel1 = new JPanel();
        this.panelLevel1.setLayout(new LayoutManager(){

            @Override
            public void addLayoutComponent(String name, Component comp) {
            }

            @Override
            public void removeLayoutComponent(Component comp) {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                int height = 0;
                int width = 0;
                for (int i = 0; i < parent.getComponentCount(); ++i) {
                    Dimension pref = parent.getComponent(i).getPreferredSize();
                    height += pref.height;
                    width = Math.max(width, pref.width);
                }
                Insets ins = parent.getInsets();
                return new Dimension(width + ins.left + ins.right, height + ins.top + ins.bottom);
            }

            @Override
            public Dimension minimumLayoutSize(Container parent) {
                return this.preferredLayoutSize(parent);
            }

            @Override
            public void layoutContainer(Container parent) {
                Insets ins = parent.getInsets();
                int topY = ins.top;
                for (int i = 0; i < parent.getComponentCount(); ++i) {
                    Component comp = parent.getComponent(i);
                    Dimension pref = comp.getPreferredSize();
                    comp.setBounds(ins.left, topY, parent.getWidth() - ins.left - ins.right, pref.height);
                    topY += pref.height;
                }
            }
        });
        final RibbonApplicationMenu ribbonAppMenu = this.applicationMenuPopupPanel.getRibbonAppMenu();
        if (ribbonAppMenu != null) {
            List<List<RibbonApplicationMenuEntryPrimary>> primaryEntries = ribbonAppMenu.getPrimaryEntries();
            int primaryGroupCount = primaryEntries.size();
            for (int i = 0; i < primaryGroupCount; ++i) {
                for (final RibbonApplicationMenuEntryPrimary menuEntry : primaryEntries.get(i)) {
                    final JCommandMenuButton commandButton = new JCommandMenuButton(menuEntry.getText(), menuEntry.getIcon());
                    commandButton.setCommandButtonKind(menuEntry.getEntryKind());
                    commandButton.addActionListener(menuEntry.getMainActionListener());
                    commandButton.setActionKeyTip(menuEntry.getActionKeyTip());
                    commandButton.setPopupKeyTip(menuEntry.getPopupKeyTip());
                    commandButton.setActionRichTooltip(menuEntry.getActionRichTooltip());
                    commandButton.setPopupRichTooltip(menuEntry.getPopupRichTooltip());
                    if (menuEntry.getDisabledIcon() != null) {
                        commandButton.setDisabledIcon(menuEntry.getDisabledIcon());
                    }
                    if (menuEntry.getSecondaryGroupCount() == 0) {
                        commandButton.addRolloverActionListener(new RolloverActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                RibbonApplicationMenuEntryPrimary.PrimaryRolloverCallback callback = menuEntry.getRolloverCallback();
                                if (callback != null) {
                                    callback.menuEntryActivated(BasicRibbonApplicationMenuPopupPanelUI.this.panelLevel2);
                                } else {
                                    RibbonApplicationMenuEntryPrimary.PrimaryRolloverCallback defaultCallback = ribbonAppMenu.getDefaultCallback();
                                    if (defaultCallback != null) {
                                        defaultCallback.menuEntryActivated(BasicRibbonApplicationMenuPopupPanelUI.this.panelLevel2);
                                    } else {
                                        BasicRibbonApplicationMenuPopupPanelUI.this.panelLevel2.removeAll();
                                        BasicRibbonApplicationMenuPopupPanelUI.this.panelLevel2.revalidate();
                                        BasicRibbonApplicationMenuPopupPanelUI.this.panelLevel2.repaint();
                                    }
                                }
                                BasicRibbonApplicationMenuPopupPanelUI.this.panelLevel2.applyComponentOrientation(BasicRibbonApplicationMenuPopupPanelUI.this.applicationMenuPopupPanel.getComponentOrientation());
                            }
                        });
                    } else {
                        final RibbonApplicationMenuEntryPrimary.PrimaryRolloverCallback coreCallback = new RibbonApplicationMenuEntryPrimary.PrimaryRolloverCallback(){

                            @Override
                            public void menuEntryActivated(JPanel targetPanel) {
                                targetPanel.removeAll();
                                targetPanel.setLayout(new BorderLayout());
                                JRibbonApplicationMenuPopupPanelSecondary secondary = new JRibbonApplicationMenuPopupPanelSecondary(menuEntry){

                                    @Override
                                    public void removeNotify() {
                                        super.removeNotify();
                                        commandButton.getPopupModel().setPopupShowing(false);
                                    }
                                };
                                secondary.applyComponentOrientation(BasicRibbonApplicationMenuPopupPanelUI.this.applicationMenuPopupPanel.getComponentOrientation());
                                targetPanel.add((Component)secondary, "Center");
                            }
                        };
                        commandButton.addRolloverActionListener(new RolloverActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                coreCallback.menuEntryActivated(BasicRibbonApplicationMenuPopupPanelUI.this.panelLevel2);
                                commandButton.getPopupModel().setPopupShowing(true);
                            }
                        });
                    }
                    commandButton.setDisplayState(MENU_TILE_LEVEL_1);
                    commandButton.setHorizontalAlignment(10);
                    commandButton.setPopupOrientationKind(JCommandButton.CommandButtonPopupOrientationKind.SIDEWARD);
                    commandButton.setEnabled(menuEntry.isEnabled());
                    this.panelLevel1.add(commandButton);
                }
                if (i >= primaryGroupCount - 1) continue;
                this.panelLevel1.add(new JPopupMenu.Separator());
            }
        }
        this.mainPanel.add((Component)this.panelLevel1, "Before");
        this.panelLevel2 = new JPanel();
        this.panelLevel2.setBorder(new Border(){

            @Override
            public Insets getBorderInsets(Component c) {
                boolean ltr = c.getComponentOrientation().isLeftToRight();
                return new Insets(0, ltr ? 1 : 0, 0, ltr ? 0 : 1);
            }

            @Override
            public boolean isBorderOpaque() {
                return true;
            }

            @Override
            public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
                g.setColor(FlamingoUtilities.getColor(Color.gray, "Label.disabledForeground"));
                boolean ltr = c.getComponentOrientation().isLeftToRight();
                int xToPaint = ltr ? x : x + width - 1;
                g.drawLine(xToPaint, y, xToPaint, y + height);
            }
        });
        Object o = null;
        if (this.applicationMenuPopupPanel.getAppMenuButton() != null && this.applicationMenuPopupPanel.getAppMenuButton().getRibbon() != null) {
            o = this.applicationMenuPopupPanel.getAppMenuButton().getRibbon().getClientProperty("ribbon.hideSecondary");
        }
        if (o instanceof Boolean && ((Boolean)o).booleanValue()) {
            this.panelLevel2.setPreferredSize(new Dimension(0, 10));
        } else {
            this.panelLevel2.setPreferredSize(new Dimension(30 * FlamingoUtilities.getFont(this.panelLevel1, "Ribbon.font", "Button.font", "Panel.font").getSize() - 30, 10));
        }
        this.mainPanel.add((Component)this.panelLevel2, "Center");
        if (ribbonAppMenu != null && ribbonAppMenu.getDefaultCallback() != null) {
            ribbonAppMenu.getDefaultCallback().menuEntryActivated(this.panelLevel2);
        }
        this.applicationMenuPopupPanel.add((Component)this.mainPanel, "Center");
        this.footerPanel = new JPanel(new FlowLayout(4)){

            @Override
            protected void paintComponent(Graphics g) {
                FlamingoUtilities.renderSurface(g, BasicRibbonApplicationMenuPopupPanelUI.this.footerPanel, new Rectangle(0, 0, BasicRibbonApplicationMenuPopupPanelUI.this.footerPanel.getWidth(), BasicRibbonApplicationMenuPopupPanelUI.this.footerPanel.getHeight()), false, false, false);
            }
        };
        if (ribbonAppMenu != null) {
            for (RibbonApplicationMenuEntryFooter footerEntry : ribbonAppMenu.getFooterEntries()) {
                JCommandButton commandFooterButton = new JCommandButton(footerEntry.getText(), footerEntry.getIcon());
                if (footerEntry.getDisabledIcon() != null) {
                    commandFooterButton.setDisabledIcon(footerEntry.getDisabledIcon());
                }
                commandFooterButton.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_ONLY);
                commandFooterButton.addActionListener(footerEntry.getMainActionListener());
                commandFooterButton.setDisplayState(CommandButtonDisplayState.MEDIUM);
                commandFooterButton.setFlat(false);
                commandFooterButton.setEnabled(footerEntry.isEnabled());
                this.footerPanel.add(commandFooterButton);
            }
        }
        this.applicationMenuPopupPanel.add((Component)this.footerPanel, "South");
        this.applicationMenuPopupPanel.setBorder(new Border(){

            @Override
            public Insets getBorderInsets(Component c) {
                return new Insets(20, 2, 2, 2);
            }

            @Override
            public boolean isBorderOpaque() {
                return true;
            }

            @Override
            public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
                g.setColor(FlamingoUtilities.getColor(Color.gray, "Label.disabledForeground"));
                g.drawRect(x, y, width - 1, height - 1);
                g.setColor(FlamingoUtilities.getColor(Color.gray, "Label.disabledForeground").brighter().brighter());
                g.drawRect(x + 1, y + 1, width - 3, height - 3);
                FlamingoUtilities.renderSurface(g, BasicRibbonApplicationMenuPopupPanelUI.this.applicationMenuPopupPanel, new Rectangle(x + 2, y + 2, width - 4, 24), false, false, false);
                JRibbonApplicationMenuButton button = BasicRibbonApplicationMenuPopupPanelUI.this.applicationMenuPopupPanel.getAppMenuButton();
                JRibbonApplicationMenuButton rendererButton = new JRibbonApplicationMenuButton(BasicRibbonApplicationMenuPopupPanelUI.this.applicationMenuPopupPanel.getAppMenuButton().getRibbon());
                rendererButton.setPopupKeyTip(button.getPopupKeyTip());
                rendererButton.setIcon(button.getIcon());
                rendererButton.getPopupModel().setRollover(false);
                rendererButton.getPopupModel().setPressed(true);
                rendererButton.getPopupModel().setArmed(true);
                rendererButton.getPopupModel().setPopupShowing(true);
                CellRendererPane buttonRendererPane = new CellRendererPane();
                Point buttonLoc = button.getLocationOnScreen();
                Point panelLoc = c.getLocationOnScreen();
                buttonRendererPane.setBounds(panelLoc.x - buttonLoc.x, panelLoc.y - buttonLoc.y, button.getWidth(), button.getHeight());
                buttonRendererPane.paintComponent(g, rendererButton, (Container)c, -panelLoc.x + buttonLoc.x, -panelLoc.y + buttonLoc.y, button.getWidth(), button.getHeight(), true);
            }
        });
    }

    protected JPanel createMainPanel() {
        JPanel result = new JPanel(new BorderLayout());
        result.setBorder(new Border(){

            @Override
            public Insets getBorderInsets(Component c) {
                return new Insets(2, 2, 2, 2);
            }

            @Override
            public boolean isBorderOpaque() {
                return true;
            }

            @Override
            public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
                g.setColor(FlamingoUtilities.getColor(Color.gray, "Label.disabledForeground").brighter().brighter());
                g.drawRect(x, y, width - 1, height - 1);
                g.setColor(FlamingoUtilities.getColor(Color.gray, "Label.disabledForeground"));
                g.drawRect(x + 1, y + 1, width - 3, height - 3);
            }
        });
        return result;
    }

    @Override
    protected void installListeners() {
        super.installListeners();
    }

    @Override
    protected void uninstallDefaults() {
        super.uninstallDefaults();
    }

    @Override
    protected void uninstallComponents() {
        super.uninstallComponents();
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.dispose();
    }

    public JPanel getPanelLevel1() {
        return this.panelLevel1;
    }

    public JPanel getPanelLevel2() {
        return this.panelLevel2;
    }
}

