/*
 * Decompiled with CFR 0.152.
 */
package com.github.isrsal.logging;

import com.github.isrsal.logging.RequestWrapper;
import com.github.isrsal.logging.ResponseWrapper;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.concurrent.atomic.AtomicLong;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.filter.OncePerRequestFilter;

public class LoggingFilter
extends OncePerRequestFilter {
    protected static final Logger logger = LoggerFactory.getLogger(LoggingFilter.class);
    private static final String REQUEST_PREFIX = "Request: ";
    private static final String RESPONSE_PREFIX = "Response: ";
    private AtomicLong id = new AtomicLong(1L);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        if (logger.isDebugEnabled()) {
            long requestId = this.id.incrementAndGet();
            request = new RequestWrapper(requestId, (HttpServletRequest)request);
            response = new ResponseWrapper(requestId, (HttpServletResponse)response);
        }
        try {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        finally {
            if (logger.isDebugEnabled()) {
                this.logRequest((HttpServletRequest)request);
                this.logResponse((ResponseWrapper)((Object)response));
            }
        }
    }

    private void logRequest(HttpServletRequest request) {
        HttpSession session;
        StringBuilder msg = new StringBuilder();
        msg.append(REQUEST_PREFIX);
        if (request instanceof RequestWrapper) {
            msg.append("request id=").append(((RequestWrapper)request).getId()).append("; ");
        }
        if ((session = request.getSession(false)) != null) {
            msg.append("session id=").append(session.getId()).append("; ");
        }
        msg.append("content type=").append(request.getContentType()).append("; ");
        msg.append("uri=").append(request.getRequestURI());
        msg.append('?').append(request.getQueryString());
        if (request instanceof RequestWrapper && !this.isMultipart(request)) {
            RequestWrapper requestWrapper = (RequestWrapper)request;
            try {
                String charEncoding = requestWrapper.getCharacterEncoding() != null ? requestWrapper.getCharacterEncoding() : "UTF-8";
                msg.append("; payload=").append(new String(requestWrapper.toByteArray(), charEncoding));
            }
            catch (UnsupportedEncodingException e) {
                logger.warn("Failed to parse request payload", (Throwable)e);
            }
        }
        logger.debug(msg.toString());
    }

    private boolean isMultipart(HttpServletRequest request) {
        return request.getContentType() != null && request.getContentType().startsWith("multipart/form-data");
    }

    private void logResponse(ResponseWrapper response) {
        StringBuilder msg = new StringBuilder();
        msg.append(RESPONSE_PREFIX);
        msg.append("request id=").append(response.getId());
        try {
            msg.append("; payload=").append(new String(response.toByteArray(), response.getCharacterEncoding()));
        }
        catch (UnsupportedEncodingException e) {
            logger.warn("Failed to parse response payload", (Throwable)e);
        }
        logger.debug(msg.toString());
    }
}

