/*
 * Copyright (C) 2015 Ivan Baranov
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
 package com.github.ivbaranov.rxbluetooth;

import android.bluetooth.BluetoothAdapter;

/**
 * Thrown when {@link BluetoothAdapter#getProfileProxy} returns true, which means that connection
 * to bluetooth profile failed.
 */
public class GetProfileProxyException extends RuntimeException {

  public GetProfileProxyException() {
    super("Failed to get profile proxy");
  }
}
