/*
 * Decompiled with CFR 0.152.
 */
package com.github.ivbaranov.rxbluetooth;

import android.bluetooth.BluetoothSocket;
import android.util.Log;
import com.github.ivbaranov.rxbluetooth.ConnectionClosedException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import rx.Observable;
import rx.Subscriber;

public class BluetoothConnection {
    private static final String TAG = BluetoothConnection.class.getName();
    private BluetoothSocket socket;
    private InputStream inputStream;
    private OutputStream outputStream;
    private Observable<Byte> mObserveInputStream;
    private boolean connected = false;

    public BluetoothConnection(BluetoothSocket socket) throws Exception {
        if (socket == null) {
            throw new InvalidParameterException("Bluetooth socket can't be null");
        }
        this.socket = socket;
        try {
            this.inputStream = socket.getInputStream();
            this.outputStream = socket.getOutputStream();
            this.connected = true;
        }
        catch (IOException e) {
            throw new Exception("Can't get stream from bluetooth socket");
        }
        finally {
            if (!this.connected) {
                this.closeConnection();
            }
        }
    }

    public Observable<Byte> observeByteStream() {
        if (this.mObserveInputStream == null) {
            this.mObserveInputStream = Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<Byte>(){

                public void call(Subscriber<? super Byte> subscriber) {
                    while (!subscriber.isUnsubscribed()) {
                        try {
                            subscriber.onNext((Object)((byte)BluetoothConnection.this.inputStream.read()));
                        }
                        catch (IOException e) {
                            BluetoothConnection.this.connected = false;
                            subscriber.onError((Throwable)new ConnectionClosedException("Can't read stream"));
                        }
                        finally {
                            if (BluetoothConnection.this.connected) continue;
                            BluetoothConnection.this.closeConnection();
                        }
                    }
                }
            }).share();
        }
        return this.mObserveInputStream;
    }

    public Observable<String> observeStringStream() {
        return this.observeStringStream(13, 10);
    }

    public Observable<String> observeStringStream(final int ... delimiter) {
        return this.observeByteStream().lift((Observable.Operator)new Observable.Operator<String, Byte>(){

            public Subscriber<? super Byte> call(final Subscriber<? super String> subscriber) {
                return new Subscriber<Byte>(subscriber){
                    ArrayList<Byte> buffer;
                    {
                        super(x0);
                        this.buffer = new ArrayList();
                    }

                    public void onCompleted() {
                        if (!this.buffer.isEmpty()) {
                            this.emit();
                        }
                        if (!subscriber.isUnsubscribed()) {
                            subscriber.onCompleted();
                        }
                    }

                    public void onError(Throwable e) {
                        if (!this.buffer.isEmpty()) {
                            this.emit();
                        }
                        if (!subscriber.isUnsubscribed()) {
                            subscriber.onError(e);
                        }
                    }

                    public void onNext(Byte b) {
                        boolean found = false;
                        for (int d : delimiter) {
                            if (b != d) continue;
                            found = true;
                            break;
                        }
                        if (found) {
                            this.emit();
                        } else {
                            this.buffer.add(b);
                        }
                    }

                    private void emit() {
                        if (this.buffer.isEmpty()) {
                            if (!subscriber.isUnsubscribed()) {
                                subscriber.onNext((Object)"");
                            }
                            return;
                        }
                        byte[] bArray = new byte[this.buffer.size()];
                        for (int i = 0; i < this.buffer.size(); ++i) {
                            bArray[i] = this.buffer.get(i);
                        }
                        if (!subscriber.isUnsubscribed()) {
                            subscriber.onNext((Object)new String(bArray));
                        }
                        this.buffer.clear();
                    }
                };
            }
        }).onBackpressureBuffer();
    }

    public boolean send(byte oneByte) {
        return this.send(new byte[]{oneByte});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean send(byte[] bytes) {
        if (!this.connected) {
            return false;
        }
        try {
            this.outputStream.write(bytes);
            this.outputStream.flush();
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            this.connected = false;
            Log.e((String)TAG, (String)"Fail to send data");
            boolean bl = false;
            return bl;
        }
        finally {
            if (!this.connected) {
                this.closeConnection();
            }
        }
    }

    public boolean send(String text) {
        byte[] sBytes = text.getBytes();
        return this.send(sBytes);
    }

    public void closeConnection() {
        try {
            this.connected = false;
            if (this.inputStream != null) {
                this.inputStream.close();
            }
            if (this.outputStream != null) {
                this.outputStream.close();
            }
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

