/*
 * Decompiled with CFR 0.152.
 */
package com.github.ivbaranov.rxbluetooth;

import android.app.Activity;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothProfile;
import android.bluetooth.BluetoothServerSocket;
import android.bluetooth.BluetoothSocket;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Looper;
import android.text.TextUtils;
import com.github.ivbaranov.rxbluetooth.GetProfileProxyException;
import com.github.ivbaranov.rxbluetooth.ServiceEvent;
import java.io.IOException;
import java.util.UUID;
import rx.Observable;
import rx.Scheduler;
import rx.Subscriber;
import rx.Subscription;
import rx.android.schedulers.AndroidSchedulers;
import rx.functions.Action0;
import rx.functions.Func0;
import rx.subscriptions.Subscriptions;

public class RxBluetooth {
    private BluetoothAdapter mBluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
    private Context context;

    public RxBluetooth(Context context) {
        this.context = context;
    }

    public boolean isBluetoothAvailable() {
        return this.mBluetoothAdapter != null && !TextUtils.isEmpty((CharSequence)this.mBluetoothAdapter.getAddress());
    }

    public boolean isBluetoothEnabled() {
        return this.mBluetoothAdapter.isEnabled();
    }

    public void enableBluetooth(Activity activity, int requestCode) {
        if (!this.mBluetoothAdapter.isEnabled()) {
            Intent enableBtIntent = new Intent("android.bluetooth.adapter.action.REQUEST_ENABLE");
            activity.startActivityForResult(enableBtIntent, requestCode);
        }
    }

    public boolean startDiscovery() {
        return this.mBluetoothAdapter.startDiscovery();
    }

    public boolean isDiscovering() {
        return this.mBluetoothAdapter.isDiscovering();
    }

    public boolean cancelDiscovery() {
        return this.mBluetoothAdapter.cancelDiscovery();
    }

    public void enableDiscoverability(Activity activity, int requestCode) {
        this.enableDiscoverability(activity, requestCode, -1);
    }

    public void enableDiscoverability(Activity activity, int requestCode, int duration) {
        Intent discoverableIntent = new Intent("android.bluetooth.adapter.action.REQUEST_DISCOVERABLE");
        if (duration >= 0) {
            discoverableIntent.putExtra("android.bluetooth.adapter.extra.DISCOVERABLE_DURATION", duration);
        }
        activity.startActivityForResult(discoverableIntent, requestCode);
    }

    public Observable<BluetoothDevice> observeDevices() {
        final IntentFilter filter = new IntentFilter("android.bluetooth.device.action.FOUND");
        return Observable.defer((Func0)new Func0<Observable<BluetoothDevice>>(){

            public Observable<BluetoothDevice> call() {
                return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<BluetoothDevice>(){

                    public void call(final Subscriber<? super BluetoothDevice> subscriber) {
                        final BroadcastReceiver receiver = new BroadcastReceiver(){

                            public void onReceive(Context context, Intent intent) {
                                String action = intent.getAction();
                                if (action.equals("android.bluetooth.device.action.FOUND")) {
                                    BluetoothDevice device = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
                                    subscriber.onNext((Object)device);
                                }
                            }
                        };
                        RxBluetooth.this.context.registerReceiver(receiver, filter);
                        subscriber.add(RxBluetooth.this.unsubscribeInUiThread(new Action0(){

                            public void call() {
                                RxBluetooth.this.context.unregisterReceiver(receiver);
                            }
                        }));
                    }
                });
            }
        });
    }

    public Observable<String> observeDiscovery() {
        final IntentFilter filter = new IntentFilter();
        filter.addAction("android.bluetooth.adapter.action.DISCOVERY_STARTED");
        filter.addAction("android.bluetooth.adapter.action.DISCOVERY_FINISHED");
        return Observable.defer((Func0)new Func0<Observable<String>>(){

            public Observable<String> call() {
                return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<String>(){

                    public void call(final Subscriber<? super String> subscriber) {
                        final BroadcastReceiver receiver = new BroadcastReceiver(){

                            public void onReceive(Context context, Intent intent) {
                                subscriber.onNext((Object)intent.getAction());
                            }
                        };
                        RxBluetooth.this.context.registerReceiver(receiver, filter);
                        subscriber.add(RxBluetooth.this.unsubscribeInUiThread(new Action0(){

                            public void call() {
                                RxBluetooth.this.context.unregisterReceiver(receiver);
                            }
                        }));
                    }
                });
            }
        });
    }

    public Observable<Integer> observeBluetoothState() {
        final IntentFilter filter = new IntentFilter();
        filter.addAction("android.bluetooth.adapter.action.STATE_CHANGED");
        return Observable.defer((Func0)new Func0<Observable<Integer>>(){

            public Observable<Integer> call() {
                return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<Integer>(){

                    public void call(final Subscriber<? super Integer> subscriber) {
                        final BroadcastReceiver receiver = new BroadcastReceiver(){

                            public void onReceive(Context context, Intent intent) {
                                subscriber.onNext((Object)RxBluetooth.this.mBluetoothAdapter.getState());
                            }
                        };
                        RxBluetooth.this.context.registerReceiver(receiver, filter);
                        subscriber.add(RxBluetooth.this.unsubscribeInUiThread(new Action0(){

                            public void call() {
                                RxBluetooth.this.context.unregisterReceiver(receiver);
                            }
                        }));
                    }
                });
            }
        });
    }

    public Observable<Integer> observeScanMode() {
        final IntentFilter filter = new IntentFilter();
        filter.addAction("android.bluetooth.adapter.action.SCAN_MODE_CHANGED");
        return Observable.defer((Func0)new Func0<Observable<Integer>>(){

            public Observable<Integer> call() {
                return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<Integer>(){

                    public void call(final Subscriber<? super Integer> subscriber) {
                        final BroadcastReceiver receiver = new BroadcastReceiver(){

                            public void onReceive(Context context, Intent intent) {
                                subscriber.onNext((Object)RxBluetooth.this.mBluetoothAdapter.getScanMode());
                            }
                        };
                        RxBluetooth.this.context.registerReceiver(receiver, filter);
                        subscriber.add(RxBluetooth.this.unsubscribeInUiThread(new Action0(){

                            public void call() {
                                RxBluetooth.this.context.unregisterReceiver(receiver);
                            }
                        }));
                    }
                });
            }
        });
    }

    public Observable<ServiceEvent> observeBluetoothProfile(final int bluetoothProfile) {
        return Observable.defer((Func0)new Func0<Observable<ServiceEvent>>(){

            public Observable<ServiceEvent> call() {
                return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<ServiceEvent>(){

                    public void call(final Subscriber<? super ServiceEvent> subscriber) {
                        if (!RxBluetooth.this.mBluetoothAdapter.getProfileProxy(RxBluetooth.this.context, new BluetoothProfile.ServiceListener(){

                            public void onServiceConnected(int profile, BluetoothProfile proxy) {
                                subscriber.onNext((Object)new ServiceEvent(ServiceEvent.State.CONNECTED, profile, proxy));
                            }

                            public void onServiceDisconnected(int profile) {
                                subscriber.onNext((Object)new ServiceEvent(ServiceEvent.State.DISCONNECTED, profile, null));
                            }
                        }, bluetoothProfile)) {
                            subscriber.onError((Throwable)new GetProfileProxyException());
                        }
                    }
                });
            }
        });
    }

    public void closeProfileProxy(int profile, BluetoothProfile proxy) {
        this.mBluetoothAdapter.closeProfileProxy(profile, proxy);
    }

    public Observable<BluetoothSocket> observeBluetoothSocket(final String name, final UUID uuid) {
        return Observable.defer((Func0)new Func0<Observable<BluetoothSocket>>(){

            public Observable<BluetoothSocket> call() {
                return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<BluetoothSocket>(){

                    public void call(Subscriber<? super BluetoothSocket> subscriber) {
                        try {
                            BluetoothServerSocket bluetoothServerSocket = RxBluetooth.this.mBluetoothAdapter.listenUsingRfcommWithServiceRecord(name, uuid);
                            subscriber.onNext((Object)bluetoothServerSocket.accept());
                            bluetoothServerSocket.close();
                        }
                        catch (IOException e) {
                            subscriber.onError((Throwable)e);
                        }
                    }
                });
            }
        });
    }

    public Observable<BluetoothSocket> observeConnectDevice(final BluetoothDevice bluetoothDevice, final UUID uuid) {
        return Observable.defer((Func0)new Func0<Observable<BluetoothSocket>>(){

            public Observable<BluetoothSocket> call() {
                return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<BluetoothSocket>(){

                    public void call(Subscriber<? super BluetoothSocket> subscriber) {
                        try {
                            BluetoothSocket bluetoothSocket = bluetoothDevice.createRfcommSocketToServiceRecord(uuid);
                            bluetoothSocket.connect();
                            subscriber.onNext((Object)bluetoothSocket);
                        }
                        catch (IOException e) {
                            subscriber.onError((Throwable)e);
                        }
                    }
                });
            }
        });
    }

    private Subscription unsubscribeInUiThread(final Action0 unsubscribe) {
        return Subscriptions.create((Action0)new Action0(){

            public void call() {
                if (Looper.getMainLooper() == Looper.myLooper()) {
                    unsubscribe.call();
                } else {
                    final Scheduler.Worker inner = AndroidSchedulers.mainThread().createWorker();
                    inner.schedule(new Action0(){

                        public void call() {
                            unsubscribe.call();
                            inner.unsubscribe();
                        }
                    });
                }
            }
        });
    }
}

