/*
 * Decompiled with CFR 0.152.
 */
package com.github.ivbaranov.rxbluetooth;

import android.bluetooth.BluetoothProfile;

public class ServiceEvent {
    private State mState;
    private int mProfileType;
    private BluetoothProfile mBluetoothProfile;

    public ServiceEvent(State state, int profileType, BluetoothProfile bluetoothProfile) {
        this.mState = state;
        this.mProfileType = profileType;
        this.mBluetoothProfile = bluetoothProfile;
    }

    public State getState() {
        return this.mState;
    }

    public int getProfileType() {
        return this.mProfileType;
    }

    public BluetoothProfile getBluetoothProfile() {
        return this.mBluetoothProfile;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceEvent that = (ServiceEvent)o;
        if (this.mProfileType != that.mProfileType) {
            return false;
        }
        if (this.mState != that.mState) {
            return false;
        }
        return !(this.mBluetoothProfile == null ? that.mBluetoothProfile != null : !this.mBluetoothProfile.equals(that.mBluetoothProfile));
    }

    public int hashCode() {
        int result = this.mState.hashCode();
        result = 31 * result + this.mProfileType;
        result = 31 * result + (this.mBluetoothProfile != null ? this.mBluetoothProfile.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ServiceEvent{mState=" + (Object)((Object)this.mState) + ", mProfileType=" + this.mProfileType + ", mBluetoothProfile=" + this.mBluetoothProfile + '}';
    }

    public static enum State {
        CONNECTED,
        DISCONNECTED;

    }
}

