/*
 * Decompiled with CFR 0.152.
 */
package cn.iwgang.familiarrecyclerview;

import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.support.v4.view.ViewCompat;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.StaggeredGridLayoutManager;
import android.view.View;
import cn.iwgang.familiarrecyclerview.FamiliarRecyclerView;

public class FamiliarDefaultItemDecoration
extends RecyclerView.ItemDecoration {
    private FamiliarRecyclerView mFamiliarRecyclerView;
    private Drawable mVerticalDividerDrawable;
    private Drawable mHorizontalDividerDrawable;
    private int mVerticalDividerDrawableHeight;
    private int mHorizontalDividerDrawableHeight;
    private int mItemViewBothSidesMargin;
    private int mLayoutManagerType = 0;
    private int mOrientation = 1;
    private int mGridSpanCount = 0;
    private boolean isHeaderDividersEnabled;
    private boolean isFooterDividersEnabled;
    private boolean isNotShowGridEndDivider;
    private float mUnDivisibleValue = 0.0f;
    private boolean isDivisible = true;

    public FamiliarDefaultItemDecoration(FamiliarRecyclerView familiarRecyclerView, Drawable dividerVertical, Drawable dividerHorizontal, int dividerDrawableSizeVertical, int dividerDrawableSizeHorizontal) {
        this.mFamiliarRecyclerView = familiarRecyclerView;
        this.mVerticalDividerDrawable = dividerVertical;
        this.mHorizontalDividerDrawable = dividerHorizontal;
        this.mVerticalDividerDrawableHeight = dividerDrawableSizeVertical;
        this.mHorizontalDividerDrawableHeight = dividerDrawableSizeHorizontal;
        this.initLayoutManagerType();
    }

    private void initLayoutManagerType() {
        this.mLayoutManagerType = this.mFamiliarRecyclerView.getCurLayoutManagerType();
        RecyclerView.LayoutManager layoutManager = this.mFamiliarRecyclerView.getLayoutManager();
        switch (this.mLayoutManagerType) {
            case 0: {
                LinearLayoutManager curLinearLayoutManager = (LinearLayoutManager)layoutManager;
                if (curLinearLayoutManager.getOrientation() == 0) {
                    this.mOrientation = 0;
                    break;
                }
                this.mOrientation = 1;
                break;
            }
            case 1: {
                GridLayoutManager curGridLayoutManager = (GridLayoutManager)layoutManager;
                this.mGridSpanCount = curGridLayoutManager.getSpanCount();
                if (curGridLayoutManager.getOrientation() == 0) {
                    this.mOrientation = 0;
                    break;
                }
                this.mOrientation = 1;
                break;
            }
            case 2: {
                StaggeredGridLayoutManager curStaggeredGridLayoutManager = (StaggeredGridLayoutManager)layoutManager;
                this.mGridSpanCount = curStaggeredGridLayoutManager.getSpanCount();
                if (curStaggeredGridLayoutManager.getOrientation() == 0) {
                    this.mOrientation = 0;
                    break;
                }
                this.mOrientation = 1;
                break;
            }
            default: {
                this.mLayoutManagerType = 0;
            }
        }
        this.initDivisible();
    }

    private void initDivisible() {
        int tempDividerDrawableSize;
        int n = tempDividerDrawableSize = this.mOrientation == 1 ? this.mHorizontalDividerDrawableHeight : this.mVerticalDividerDrawableHeight;
        if (this.mGridSpanCount > 0 && tempDividerDrawableSize % this.mGridSpanCount != 0) {
            float t1 = (float)tempDividerDrawableSize / (float)this.mGridSpanCount;
            this.mUnDivisibleValue = t1 - (float)((int)t1);
            this.isDivisible = false;
        } else {
            this.mUnDivisibleValue = 0.0f;
            this.isDivisible = true;
        }
    }

    public void setVerticalDividerDrawable(Drawable verticalDividerDrawable) {
        this.mVerticalDividerDrawable = verticalDividerDrawable;
    }

    public void setHorizontalDividerDrawable(Drawable horizontalDividerDrawable) {
        this.mHorizontalDividerDrawable = horizontalDividerDrawable;
    }

    public void setVerticalDividerDrawableHeight(int verticalDividerDrawableHeight) {
        this.mVerticalDividerDrawableHeight = verticalDividerDrawableHeight;
        this.initDivisible();
    }

    public void setHorizontalDividerDrawableHeight(int horizontalDividerDrawableHeight) {
        this.mHorizontalDividerDrawableHeight = horizontalDividerDrawableHeight;
        this.initDivisible();
    }

    public void setItemViewBothSidesMargin(int itemViewBothSidesMargin) {
        this.mItemViewBothSidesMargin = itemViewBothSidesMargin;
    }

    public void setHeaderDividersEnabled(boolean isHeaderDividersEnabled) {
        this.isHeaderDividersEnabled = isHeaderDividersEnabled;
    }

    public void setFooterDividersEnabled(boolean isFooterDividersEnabled) {
        this.isFooterDividersEnabled = isFooterDividersEnabled;
    }

    public void setNotShowGridEndDivider(boolean isNotShowGridEndDivider) {
        this.isNotShowGridEndDivider = isNotShowGridEndDivider;
    }

    public void onDraw(Canvas c, RecyclerView parent, RecyclerView.State state) {
        if (null != this.mVerticalDividerDrawable || null != this.mHorizontalDividerDrawable) {
            this.drawDividerDrawable(c, parent);
        }
    }

    private void drawDividerDrawable(Canvas c, RecyclerView parent) {
        int itemViewCount;
        int headersCount = 0;
        int footerCount = 0;
        FamiliarRecyclerView curFamiliarRecyclerView = null;
        if (parent instanceof FamiliarRecyclerView) {
            curFamiliarRecyclerView = (FamiliarRecyclerView)parent;
            headersCount = curFamiliarRecyclerView.getHeaderViewsCount();
            footerCount = curFamiliarRecyclerView.getFooterViewsCount();
            itemViewCount = curFamiliarRecyclerView.getAdapter().getItemCount() - headersCount - footerCount;
        } else {
            itemViewCount = parent.getAdapter().getItemCount();
        }
        int parentLeft = parent.getPaddingLeft();
        int parentRight = parent.getWidth() - parent.getPaddingRight();
        int parentTop = parent.getPaddingTop();
        int parentBottom = parent.getHeight() - parent.getPaddingBottom();
        boolean isGridLayoutLastNum = false;
        block4: for (int i = 0; i < parent.getChildCount(); ++i) {
            int bottom;
            int top;
            int right;
            int left;
            View childView = parent.getChildAt(i);
            RecyclerView.LayoutParams childViewParams = (RecyclerView.LayoutParams)childView.getLayoutParams();
            int position = childViewParams.getViewAdapterPosition();
            if (this.isInterceptFilter(position, headersCount, footerCount, itemViewCount) || this.mLayoutManagerType == 0 && (!this.isHeaderDividersEnabled || headersCount == 0) && position - headersCount == 0) continue;
            int traX = (int)ViewCompat.getTranslationX((View)childView);
            int traY = (int)ViewCompat.getTranslationY((View)childView);
            boolean isEmptyView = this.isEmptyView(curFamiliarRecyclerView, position, headersCount);
            if (this.isHeadViewPos(headersCount, position) || this.isFooterViewPos(headersCount, footerCount, itemViewCount, position) || isEmptyView) {
                if (isEmptyView && (!this.isHeaderDividersEnabled || headersCount == 0)) continue;
                if (this.mOrientation == 0) {
                    left = childView.getLeft() - childViewParams.leftMargin - this.mVerticalDividerDrawableHeight;
                    right = left + this.mVerticalDividerDrawableHeight;
                    this.mVerticalDividerDrawable.setBounds(left + traX, parentTop + traY, right + traX, parentBottom + traY);
                    this.mVerticalDividerDrawable.draw(c);
                    continue;
                }
                top = childView.getTop() - childViewParams.topMargin - this.mHorizontalDividerDrawableHeight;
                bottom = top + this.mHorizontalDividerDrawableHeight;
                this.mHorizontalDividerDrawable.setBounds(parentLeft + traX, top + traY, parentRight + traX, bottom + traY);
                this.mHorizontalDividerDrawable.draw(c);
                continue;
            }
            switch (this.mLayoutManagerType) {
                case 0: {
                    if (this.mOrientation == 1) {
                        left = parentLeft;
                        right = parentRight;
                        if (this.mItemViewBothSidesMargin > 0 && position - headersCount > 0) {
                            left += this.mItemViewBothSidesMargin;
                            right -= this.mItemViewBothSidesMargin;
                        }
                        int top2 = childView.getTop() - childViewParams.topMargin - this.mHorizontalDividerDrawableHeight;
                        int bottom2 = top2 + this.mHorizontalDividerDrawableHeight;
                        this.mHorizontalDividerDrawable.setBounds(left + traX, top2 + traY, right + traX, bottom2 + traY);
                        this.mHorizontalDividerDrawable.draw(c);
                        continue block4;
                    }
                    top = parentTop;
                    bottom = parentBottom;
                    if (this.mItemViewBothSidesMargin > 0 && position - headersCount > 0) {
                        top += this.mItemViewBothSidesMargin;
                        bottom -= this.mItemViewBothSidesMargin;
                    }
                    int left2 = childView.getLeft() - childViewParams.leftMargin - this.mVerticalDividerDrawableHeight;
                    int right2 = left2 + this.mVerticalDividerDrawableHeight;
                    this.mVerticalDividerDrawable.setBounds(left2 + traX, top + traY, right2 + traX, bottom + traY);
                    this.mVerticalDividerDrawable.draw(c);
                    continue block4;
                }
                case 1: 
                case 2: {
                    int horizontalRight;
                    int horizontalBottom;
                    int horizontalLeft;
                    boolean isGridItemLayoutLastRow = this.isGridItemLayoutLastRow(position, itemViewCount, headersCount);
                    boolean isGridItemLayoutLastColumn = this.isGridItemLayoutLastColumn(position, headersCount, childView);
                    boolean isGridItemLayoutFirstRow = this.isGridItemLayoutFirstRow(position, headersCount);
                    if (this.mLayoutManagerType == 1 && position == itemViewCount + headersCount - 1) {
                        isGridLayoutLastNum = true;
                    }
                    if (this.mOrientation == 0) {
                        int verticalBottom;
                        int verticalTop;
                        if (!this.isNotShowGridEndDivider || !isGridLayoutLastNum && !isGridItemLayoutLastColumn) {
                            horizontalLeft = childView.getLeft() - childViewParams.leftMargin;
                            int horizontalTop = childView.getBottom() + childViewParams.bottomMargin;
                            int horizontalRight2 = childView.getRight() + childViewParams.rightMargin;
                            horizontalBottom = horizontalTop + this.mHorizontalDividerDrawableHeight;
                            if (this.mLayoutManagerType == 2 && !isGridItemLayoutLastRow) {
                                horizontalRight2 += this.mVerticalDividerDrawableHeight;
                            }
                            this.mHorizontalDividerDrawable.setBounds(horizontalLeft + traX, horizontalTop + traY, horizontalRight2 + traX, horizontalBottom + traY);
                            this.mHorizontalDividerDrawable.draw(c);
                        }
                        if ((!this.isHeaderDividersEnabled || headersCount == 0) && isGridItemLayoutFirstRow) continue block4;
                        if (isGridItemLayoutFirstRow) {
                            if (position - headersCount != 0) continue block4;
                            verticalTop = parent.getTop();
                            verticalBottom = parent.getBottom();
                        } else if (this.mLayoutManagerType == 1 && isGridItemLayoutLastRow) {
                            if (!this.isGridItemLayoutFirstColumn(position, headersCount, childView)) continue block4;
                            verticalTop = parent.getTop() + this.mItemViewBothSidesMargin;
                            verticalBottom = parent.getBottom() - this.mItemViewBothSidesMargin;
                        } else {
                            verticalTop = childView.getTop() - childViewParams.topMargin;
                            verticalBottom = childView.getBottom() + childViewParams.bottomMargin;
                            if (this.mLayoutManagerType == 1 && !isGridItemLayoutLastColumn) {
                                verticalBottom += this.mHorizontalDividerDrawableHeight;
                            }
                        }
                        int verticalLeft = childView.getLeft() - childViewParams.leftMargin - this.mVerticalDividerDrawableHeight;
                        int verticalRight = verticalLeft + this.mVerticalDividerDrawableHeight;
                        this.mVerticalDividerDrawable.setBounds(verticalLeft + traX, verticalTop + traY, verticalRight + traX, verticalBottom + traY);
                        this.mVerticalDividerDrawable.draw(c);
                        continue block4;
                    }
                    if (!this.isNotShowGridEndDivider || !isGridItemLayoutLastColumn && (this.mLayoutManagerType == 1 && !isGridLayoutLastNum || this.mLayoutManagerType == 2)) {
                        int verticalLeft = childView.getRight() + childViewParams.rightMargin;
                        int verticalTop = childView.getTop() - childViewParams.topMargin;
                        int verticalRight = verticalLeft + this.mVerticalDividerDrawableHeight;
                        int verticalBottom = childView.getBottom() + childViewParams.bottomMargin;
                        if (this.mLayoutManagerType == 2 && !isGridItemLayoutLastRow) {
                            verticalBottom += this.mHorizontalDividerDrawableHeight;
                        }
                        this.mVerticalDividerDrawable.setBounds(verticalLeft + traX, verticalTop + traY, verticalRight + traX, verticalBottom + traY);
                        this.mVerticalDividerDrawable.draw(c);
                    }
                    if ((!this.isHeaderDividersEnabled || headersCount == 0) && isGridItemLayoutFirstRow) continue block4;
                    if (isGridItemLayoutFirstRow) {
                        if (position - headersCount != 0) continue block4;
                        horizontalLeft = parent.getLeft();
                        horizontalRight = parent.getRight();
                    } else if (this.mLayoutManagerType == 1 && isGridItemLayoutLastRow) {
                        if (!this.isGridItemLayoutFirstColumn(position, headersCount, childView)) continue block4;
                        horizontalLeft = parent.getLeft() + this.mItemViewBothSidesMargin;
                        horizontalRight = parent.getRight() - this.mItemViewBothSidesMargin;
                    } else {
                        horizontalLeft = childView.getLeft() - childViewParams.leftMargin;
                        horizontalRight = childView.getRight() + childViewParams.rightMargin;
                        if (this.mLayoutManagerType == 1 && !isGridItemLayoutLastColumn) {
                            horizontalRight += this.mVerticalDividerDrawableHeight;
                        }
                    }
                    int horizontalTop = childView.getTop() - childViewParams.topMargin - this.mHorizontalDividerDrawableHeight;
                    horizontalBottom = horizontalTop + this.mHorizontalDividerDrawableHeight;
                    this.mHorizontalDividerDrawable.setBounds(horizontalLeft + traX, horizontalTop + traY, horizontalRight + traX, horizontalBottom + traY);
                    this.mHorizontalDividerDrawable.draw(c);
                }
            }
        }
    }

    public void getItemOffsets(Rect outRect, View view, RecyclerView parent, RecyclerView.State state) {
        int itemViewCount;
        int headersCount;
        int footerCount;
        RecyclerView.LayoutParams params = (RecyclerView.LayoutParams)view.getLayoutParams();
        int position = params.getViewAdapterPosition();
        FamiliarRecyclerView curFamiliarRecyclerView = null;
        if (parent instanceof FamiliarRecyclerView) {
            curFamiliarRecyclerView = (FamiliarRecyclerView)parent;
            footerCount = curFamiliarRecyclerView.getFooterViewsCount();
            headersCount = curFamiliarRecyclerView.getHeaderViewsCount();
            itemViewCount = curFamiliarRecyclerView.getAdapter().getItemCount() - headersCount - footerCount;
        } else {
            headersCount = 0;
            footerCount = 0;
            itemViewCount = parent.getAdapter().getItemCount();
        }
        if (this.isInterceptFilter(position, headersCount, footerCount, itemViewCount)) {
            return;
        }
        if (this.isHeadViewPos(headersCount, position)) {
            if (this.mOrientation == 0) {
                outRect.set(this.mVerticalDividerDrawableHeight, 0, 0, 0);
            } else {
                outRect.set(0, this.mHorizontalDividerDrawableHeight, 0, 0);
            }
            return;
        }
        if (this.isFooterViewPos(headersCount, footerCount, itemViewCount, position)) {
            if (this.mOrientation == 0) {
                outRect.set(this.mVerticalDividerDrawableHeight, 0, 0, 0);
            } else {
                outRect.set(0, this.mHorizontalDividerDrawableHeight, 0, 0);
            }
            return;
        }
        if (this.isEmptyView(curFamiliarRecyclerView, position, headersCount)) {
            if (this.isHeaderDividersEnabled && headersCount > 0) {
                if (this.mOrientation == 0) {
                    outRect.set(this.mVerticalDividerDrawableHeight, 0, 0, 0);
                } else {
                    outRect.set(0, this.mHorizontalDividerDrawableHeight, 0, 0);
                }
            }
            return;
        }
        if (this.mLayoutManagerType == 1 || this.mLayoutManagerType == 2) {
            this.processGridOffsets(outRect, position, headersCount, view);
        } else {
            int topOrLeftSize;
            if (!(this.isHeaderDividersEnabled && headersCount != 0 || position - headersCount != 0)) {
                topOrLeftSize = 0;
            } else {
                int n = topOrLeftSize = this.mOrientation == 1 ? this.mHorizontalDividerDrawableHeight : this.mVerticalDividerDrawableHeight;
            }
            if (this.mOrientation == 0) {
                outRect.set(topOrLeftSize, this.mItemViewBothSidesMargin, 0, this.mItemViewBothSidesMargin);
            } else {
                outRect.set(this.mItemViewBothSidesMargin, topOrLeftSize, this.mItemViewBothSidesMargin, 0);
            }
        }
    }

    private void processGridOffsets(Rect outRect, int position, int headersCount, View view) {
        int topOrLeftSize;
        int rightOrBottomOffset;
        int leftOrTopOffset;
        float mDividerRightBaseOffset;
        float mDividerLeftBaseOffset;
        int tempDividerDrawableSize;
        int curGridNum = this.mLayoutManagerType == 1 ? (position - headersCount) % this.mGridSpanCount : ((StaggeredGridLayoutManager.LayoutParams)view.getLayoutParams()).getSpanIndex();
        int n = tempDividerDrawableSize = this.mOrientation == 0 ? this.mHorizontalDividerDrawableHeight : this.mVerticalDividerDrawableHeight;
        if (this.mItemViewBothSidesMargin > 0) {
            mDividerLeftBaseOffset = (float)tempDividerDrawableSize / (float)this.mGridSpanCount * (float)curGridNum - (float)(this.mItemViewBothSidesMargin * 2 / this.mGridSpanCount * curGridNum) + (float)this.mItemViewBothSidesMargin;
            mDividerRightBaseOffset = (float)tempDividerDrawableSize / (float)this.mGridSpanCount * (float)(this.mGridSpanCount - (curGridNum + 1)) + (float)(this.mItemViewBothSidesMargin * 2 / this.mGridSpanCount * (curGridNum + 1)) - (float)this.mItemViewBothSidesMargin;
        } else {
            mDividerLeftBaseOffset = (float)tempDividerDrawableSize / (float)this.mGridSpanCount * (float)curGridNum;
            mDividerRightBaseOffset = (float)tempDividerDrawableSize / (float)this.mGridSpanCount * (float)(this.mGridSpanCount - (curGridNum + 1));
        }
        if (!this.isDivisible && this.mUnDivisibleValue > 0.0f) {
            leftOrTopOffset = Math.round(mDividerLeftBaseOffset - this.mUnDivisibleValue * (float)(curGridNum + 1));
            rightOrBottomOffset = Math.round(mDividerRightBaseOffset + this.mUnDivisibleValue * (float)(curGridNum + 1));
        } else {
            leftOrTopOffset = (int)mDividerLeftBaseOffset;
            rightOrBottomOffset = (int)mDividerRightBaseOffset;
        }
        if ((!this.isHeaderDividersEnabled || headersCount == 0) && this.isGridItemLayoutFirstRow(position, headersCount)) {
            topOrLeftSize = 0;
        } else {
            int n2 = topOrLeftSize = this.mOrientation == 1 ? this.mHorizontalDividerDrawableHeight : this.mVerticalDividerDrawableHeight;
        }
        if (this.isGridItemLayoutLastColumn(position, headersCount, view)) {
            if (this.mOrientation == 0) {
                outRect.set(topOrLeftSize, leftOrTopOffset, 0, this.mItemViewBothSidesMargin);
            } else {
                outRect.set(leftOrTopOffset, topOrLeftSize, this.mItemViewBothSidesMargin, 0);
            }
        } else if (this.isGridItemLayoutFirstColumn(position, headersCount, view)) {
            if (this.mOrientation == 0) {
                outRect.set(topOrLeftSize, this.mItemViewBothSidesMargin, 0, rightOrBottomOffset);
            } else {
                outRect.set(this.mItemViewBothSidesMargin, topOrLeftSize, rightOrBottomOffset, 0);
            }
        } else if (this.mOrientation == 0) {
            outRect.set(topOrLeftSize, leftOrTopOffset, 0, rightOrBottomOffset);
        } else {
            outRect.set(leftOrTopOffset, topOrLeftSize, rightOrBottomOffset, 0);
        }
    }

    private boolean isHeadViewPos(int headersCount, int position) {
        return this.isHeaderDividersEnabled && headersCount > 0 && position < headersCount;
    }

    private boolean isFooterViewPos(int headersCount, int footerCount, int itemViewCount, int position) {
        return this.isFooterDividersEnabled && footerCount > 0 && position >= itemViewCount + headersCount;
    }

    private boolean isInterceptFilter(int position, int headersCount, int footerCount, int itemViewCount) {
        if (this.isHeaderDividersEnabled && headersCount > 0 && position == 0) {
            return true;
        }
        if (!this.isHeaderDividersEnabled && position < headersCount) {
            return true;
        }
        return (!this.isFooterDividersEnabled || footerCount == 0) && position >= itemViewCount + headersCount;
    }

    private boolean isEmptyView(FamiliarRecyclerView familiarRecyclerView, int position, int headersCount) {
        return null != familiarRecyclerView && familiarRecyclerView.isKeepShowHeadOrFooter() && familiarRecyclerView.isShowEmptyView() && position == headersCount;
    }

    private boolean isGridItemLayoutLastRow(int position, int itemViewCount, int headersCount) {
        if (this.mLayoutManagerType == 0) {
            return false;
        }
        return Math.ceil((float)itemViewCount / (float)this.mGridSpanCount) == Math.ceil((float)(position - headersCount + 1) / (float)this.mGridSpanCount);
    }

    private boolean isGridItemLayoutFirstRow(int position, int headersCount) {
        return position - headersCount < this.mGridSpanCount;
    }

    private boolean isGridItemLayoutLastColumn(int position, int headersCount, View view) {
        int spanIndex;
        return this.mLayoutManagerType == 1 ? (position + 1 - headersCount) % this.mGridSpanCount == 0 : this.mLayoutManagerType == 2 && (spanIndex = ((StaggeredGridLayoutManager.LayoutParams)view.getLayoutParams()).getSpanIndex()) == this.mGridSpanCount - 1;
    }

    private boolean isGridItemLayoutFirstColumn(int position, int headersCount, View view) {
        int spanIndex;
        if (this.mLayoutManagerType == 1) {
            return (position + 1 - headersCount) % this.mGridSpanCount == 1;
        }
        return this.mLayoutManagerType == 2 && (spanIndex = ((StaggeredGridLayoutManager.LayoutParams)view.getLayoutParams()).getSpanIndex()) == 0;
    }
}

