/*
 * Decompiled with CFR 0.152.
 */
package cn.iwgang.familiarrecyclerview;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.StaggeredGridLayoutManager;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import cn.iwgang.familiarrecyclerview.FamiliarDefaultItemDecoration;
import cn.iwgang.familiarrecyclerview.FamiliarWrapRecyclerViewAdapter;
import cn.iwgang.familiarrecyclerview.R;
import java.util.ArrayList;
import java.util.List;

public class FamiliarRecyclerView
extends RecyclerView {
    public static final int LAYOUT_MANAGER_TYPE_LINEAR = 0;
    public static final int LAYOUT_MANAGER_TYPE_GRID = 1;
    public static final int LAYOUT_MANAGER_TYPE_STAGGERED_GRID = 2;
    private static final int DEF_LAYOUT_MANAGER_TYPE = 0;
    private static final int DEF_GRID_SPAN_COUNT = 2;
    private static final int DEF_LAYOUT_MANAGER_ORIENTATION = 1;
    private static final int DEF_DIVIDER_HEIGHT = 30;
    private List<View> mHeaderView = new ArrayList<View>();
    private List<View> mFooterView = new ArrayList<View>();
    private FamiliarWrapRecyclerViewAdapter mWrapFamiliarRecyclerViewAdapter;
    private RecyclerView.Adapter mReqAdapter;
    private GridLayoutManager mCurGridLayoutManager;
    private FamiliarDefaultItemDecoration mFamiliarDefaultItemDecoration;
    private Drawable mVerticalDivider;
    private Drawable mHorizontalDivider;
    private int mVerticalDividerHeight;
    private int mHorizontalDividerHeight;
    private int mItemViewBothSidesMargin;
    private boolean isHeaderDividersEnabled = false;
    private boolean isFooterDividersEnabled = false;
    private boolean isDefaultItemDecoration = true;
    private boolean isKeepShowHeadOrFooter = false;
    private boolean isNotShowGridEndDivider = false;
    private int mEmptyViewResId;
    private View mEmptyView;
    private OnItemClickListener mTempOnItemClickListener;
    private OnItemLongClickListener mTempOnItemLongClickListener;
    private OnHeadViewBindViewHolderListener mTempOnHeadViewBindViewHolderListener;
    private OnFooterViewBindViewHolderListener mTempOnFooterViewBindViewHolderListener;
    private int mLayoutManagerType;
    private Drawable mDefAllDivider;
    private int mDefAllDividerHeight;
    private boolean needInitAddItemDescration = false;
    private boolean hasShowEmptyView = false;
    private RecyclerView.AdapterDataObserver mReqAdapterDataObserver = new RecyclerView.AdapterDataObserver(){

        public void onChanged() {
            FamiliarRecyclerView.this.mWrapFamiliarRecyclerViewAdapter.notifyDataSetChanged();
            FamiliarRecyclerView.this.processEmptyView();
        }

        public void onItemRangeInserted(int positionStart, int itemCount) {
            FamiliarRecyclerView.this.mWrapFamiliarRecyclerViewAdapter.notifyItemInserted(FamiliarRecyclerView.this.getHeaderViewsCount() + positionStart);
            FamiliarRecyclerView.this.processEmptyView();
        }

        public void onItemRangeRemoved(int positionStart, int itemCount) {
            FamiliarRecyclerView.this.mWrapFamiliarRecyclerViewAdapter.notifyItemRemoved(FamiliarRecyclerView.this.getHeaderViewsCount() + positionStart);
            FamiliarRecyclerView.this.processEmptyView();
        }

        public void onItemRangeChanged(int positionStart, int itemCount) {
            FamiliarRecyclerView.this.mWrapFamiliarRecyclerViewAdapter.notifyItemRangeChanged(FamiliarRecyclerView.this.getHeaderViewsCount() + positionStart, itemCount);
            FamiliarRecyclerView.this.processEmptyView();
        }

        public void onItemRangeMoved(int fromPosition, int toPosition, int itemCount) {
            FamiliarRecyclerView.this.mWrapFamiliarRecyclerViewAdapter.notifyItemMoved(FamiliarRecyclerView.this.getHeaderViewsCount() + fromPosition, FamiliarRecyclerView.this.getHeaderViewsCount() + toPosition);
        }
    };

    public FamiliarRecyclerView(Context context) {
        this(context, null);
    }

    public FamiliarRecyclerView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public FamiliarRecyclerView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.FamiliarRecyclerView);
        this.mDefAllDivider = ta.getDrawable(R.styleable.FamiliarRecyclerView_frv_divider);
        this.mDefAllDividerHeight = (int)ta.getDimension(R.styleable.FamiliarRecyclerView_frv_dividerHeight, -1.0f);
        this.mVerticalDivider = ta.getDrawable(R.styleable.FamiliarRecyclerView_frv_dividerVertical);
        this.mHorizontalDivider = ta.getDrawable(R.styleable.FamiliarRecyclerView_frv_dividerHorizontal);
        this.mVerticalDividerHeight = (int)ta.getDimension(R.styleable.FamiliarRecyclerView_frv_dividerVerticalHeight, -1.0f);
        this.mHorizontalDividerHeight = (int)ta.getDimension(R.styleable.FamiliarRecyclerView_frv_dividerHorizontalHeight, -1.0f);
        this.mItemViewBothSidesMargin = (int)ta.getDimension(R.styleable.FamiliarRecyclerView_frv_itemViewBothSidesMargin, 0.0f);
        this.mEmptyViewResId = ta.getResourceId(R.styleable.FamiliarRecyclerView_frv_emptyView, -1);
        this.isKeepShowHeadOrFooter = ta.getBoolean(R.styleable.FamiliarRecyclerView_frv_isEmptyViewKeepShowHeadOrFooter, false);
        this.isHeaderDividersEnabled = ta.getBoolean(R.styleable.FamiliarRecyclerView_frv_headerDividersEnabled, false);
        this.isFooterDividersEnabled = ta.getBoolean(R.styleable.FamiliarRecyclerView_frv_footerDividersEnabled, false);
        this.isNotShowGridEndDivider = ta.getBoolean(R.styleable.FamiliarRecyclerView_frv_isNotShowGridEndDivider, false);
        if (ta.hasValue(R.styleable.FamiliarRecyclerView_frv_layoutManager)) {
            int layoutManagerType = ta.getInt(R.styleable.FamiliarRecyclerView_frv_layoutManager, 0);
            int layoutManagerOrientation = ta.getInt(R.styleable.FamiliarRecyclerView_frv_layoutManagerOrientation, 1);
            boolean isReverseLayout = ta.getBoolean(R.styleable.FamiliarRecyclerView_frv_isReverseLayout, false);
            int gridSpanCount = ta.getInt(R.styleable.FamiliarRecyclerView_frv_spanCount, 2);
            switch (layoutManagerType) {
                case 0: {
                    this.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(context, layoutManagerOrientation, isReverseLayout));
                    break;
                }
                case 1: {
                    this.setLayoutManager((RecyclerView.LayoutManager)new GridLayoutManager(context, gridSpanCount, layoutManagerOrientation, isReverseLayout));
                    break;
                }
                case 2: {
                    this.setLayoutManager((RecyclerView.LayoutManager)new StaggeredGridLayoutManager(gridSpanCount, layoutManagerOrientation));
                }
            }
        }
        ta.recycle();
    }

    private void processDefDivider(boolean isLinearLayoutManager, int layoutManagerOrientation) {
        if (!this.isDefaultItemDecoration) {
            return;
        }
        if ((null == this.mVerticalDivider || null == this.mHorizontalDivider) && null != this.mDefAllDivider) {
            if (isLinearLayoutManager) {
                if (layoutManagerOrientation == 1 && null == this.mHorizontalDivider) {
                    this.mHorizontalDivider = this.mDefAllDivider;
                } else if (layoutManagerOrientation == 0 && null == this.mVerticalDivider) {
                    this.mVerticalDivider = this.mDefAllDivider;
                }
            } else {
                if (null == this.mVerticalDivider) {
                    this.mVerticalDivider = this.mDefAllDivider;
                }
                if (null == this.mHorizontalDivider) {
                    this.mHorizontalDivider = this.mDefAllDivider;
                }
            }
        }
        if (this.mVerticalDividerHeight > 0 && this.mHorizontalDividerHeight > 0) {
            return;
        }
        if (this.mDefAllDividerHeight > 0) {
            if (isLinearLayoutManager) {
                if (layoutManagerOrientation == 1 && this.mHorizontalDividerHeight <= 0) {
                    this.mHorizontalDividerHeight = this.mDefAllDividerHeight;
                } else if (layoutManagerOrientation == 0 && this.mVerticalDividerHeight <= 0) {
                    this.mVerticalDividerHeight = this.mDefAllDividerHeight;
                }
            } else {
                if (this.mVerticalDividerHeight <= 0) {
                    this.mVerticalDividerHeight = this.mDefAllDividerHeight;
                }
                if (this.mHorizontalDividerHeight <= 0) {
                    this.mHorizontalDividerHeight = this.mDefAllDividerHeight;
                }
            }
        } else if (isLinearLayoutManager) {
            if (layoutManagerOrientation == 1 && this.mHorizontalDividerHeight <= 0) {
                if (null != this.mHorizontalDivider) {
                    this.mHorizontalDividerHeight = this.mHorizontalDivider.getIntrinsicHeight() > 0 ? this.mHorizontalDivider.getIntrinsicHeight() : 30;
                }
            } else if (layoutManagerOrientation == 0 && this.mVerticalDividerHeight <= 0 && null != this.mVerticalDivider) {
                this.mVerticalDividerHeight = this.mVerticalDivider.getIntrinsicHeight() > 0 ? this.mVerticalDivider.getIntrinsicHeight() : 30;
            }
        } else {
            if (this.mVerticalDividerHeight <= 0 && null != this.mVerticalDivider) {
                this.mVerticalDividerHeight = this.mVerticalDivider.getIntrinsicHeight() > 0 ? this.mVerticalDivider.getIntrinsicHeight() : 30;
            }
            if (this.mHorizontalDividerHeight <= 0 && null != this.mHorizontalDivider) {
                this.mHorizontalDividerHeight = this.mHorizontalDivider.getIntrinsicHeight() > 0 ? this.mHorizontalDivider.getIntrinsicHeight() : 30;
            }
        }
    }

    public void setAdapter(RecyclerView.Adapter adapter) {
        ViewParent emptyViewParent;
        if (this.mEmptyViewResId != -1) {
            if (null != this.getParent()) {
                ViewGroup parentView = (ViewGroup)this.getParent();
                View tempEmptyView1 = parentView.findViewById(this.mEmptyViewResId);
                if (null != tempEmptyView1) {
                    this.mEmptyView = tempEmptyView1;
                    if (this.isKeepShowHeadOrFooter) {
                        parentView.removeView(tempEmptyView1);
                    }
                } else {
                    View tempEmptyView2;
                    ViewParent pParentView = parentView.getParent();
                    if (null != pParentView && pParentView instanceof ViewGroup && null != (tempEmptyView2 = ((ViewGroup)pParentView).findViewById(this.mEmptyViewResId))) {
                        this.mEmptyView = tempEmptyView2;
                        if (this.isKeepShowHeadOrFooter) {
                            ((ViewGroup)pParentView).removeView(tempEmptyView2);
                        }
                    }
                }
            }
            this.mEmptyViewResId = -1;
        } else if (this.isKeepShowHeadOrFooter && null != this.mEmptyView && null != (emptyViewParent = this.mEmptyView.getParent()) && emptyViewParent instanceof ViewGroup) {
            ((ViewGroup)emptyViewParent).removeView(this.mEmptyView);
        }
        if (null == adapter) {
            if (null != this.mReqAdapter) {
                if (!this.isKeepShowHeadOrFooter) {
                    this.mReqAdapter.unregisterAdapterDataObserver(this.mReqAdapterDataObserver);
                }
                this.mReqAdapter = null;
                this.mWrapFamiliarRecyclerViewAdapter = null;
                this.processEmptyView();
            }
            return;
        }
        this.mReqAdapter = adapter;
        this.mWrapFamiliarRecyclerViewAdapter = new FamiliarWrapRecyclerViewAdapter(this, adapter, this.mHeaderView, this.mFooterView, this.mLayoutManagerType);
        this.mWrapFamiliarRecyclerViewAdapter.setOnItemClickListener(this.mTempOnItemClickListener);
        this.mWrapFamiliarRecyclerViewAdapter.setOnItemLongClickListener(this.mTempOnItemLongClickListener);
        this.mWrapFamiliarRecyclerViewAdapter.setOnHeadViewBindViewHolderListener(this.mTempOnHeadViewBindViewHolderListener);
        this.mWrapFamiliarRecyclerViewAdapter.setOnFooterViewBindViewHolderListener(this.mTempOnFooterViewBindViewHolderListener);
        this.mReqAdapter.registerAdapterDataObserver(this.mReqAdapterDataObserver);
        super.setAdapter((RecyclerView.Adapter)this.mWrapFamiliarRecyclerViewAdapter);
        if (this.needInitAddItemDescration && null != this.mFamiliarDefaultItemDecoration) {
            this.needInitAddItemDescration = false;
            super.addItemDecoration((RecyclerView.ItemDecoration)this.mFamiliarDefaultItemDecoration);
        }
        this.processEmptyView();
    }

    public void reRegisterAdapterDataObserver() {
        if (null != this.mReqAdapter && !this.mReqAdapter.hasObservers()) {
            this.mReqAdapter.registerAdapterDataObserver(this.mReqAdapterDataObserver);
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (null != this.mReqAdapter && this.mReqAdapter.hasObservers()) {
            this.mReqAdapter.unregisterAdapterDataObserver(this.mReqAdapterDataObserver);
        }
    }

    public void setLayoutManager(RecyclerView.LayoutManager layout) {
        super.setLayoutManager(layout);
        if (null == layout) {
            return;
        }
        if (layout instanceof GridLayoutManager) {
            this.mCurGridLayoutManager = (GridLayoutManager)layout;
            this.mCurGridLayoutManager.setSpanSizeLookup(new GridLayoutManager.SpanSizeLookup(){

                public int getSpanSize(int position) {
                    if (position < FamiliarRecyclerView.this.getHeaderViewsCount() || position >= FamiliarRecyclerView.this.mReqAdapter.getItemCount() + FamiliarRecyclerView.this.getHeaderViewsCount()) {
                        return FamiliarRecyclerView.this.mCurGridLayoutManager.getSpanCount();
                    }
                    return 1;
                }
            });
            this.mLayoutManagerType = 1;
            this.processDefDivider(false, this.mCurGridLayoutManager.getOrientation());
            this.initDefaultItemDecoration();
        } else if (layout instanceof StaggeredGridLayoutManager) {
            this.mLayoutManagerType = 2;
            this.processDefDivider(false, ((StaggeredGridLayoutManager)layout).getOrientation());
            this.initDefaultItemDecoration();
        } else if (layout instanceof LinearLayoutManager) {
            this.mLayoutManagerType = 0;
            this.processDefDivider(true, ((LinearLayoutManager)layout).getOrientation());
            this.initDefaultItemDecoration();
        }
    }

    public void addItemDecoration(RecyclerView.ItemDecoration decor) {
        if (null == decor) {
            return;
        }
        if (null != this.mFamiliarDefaultItemDecoration) {
            this.removeItemDecoration(this.mFamiliarDefaultItemDecoration);
            this.mFamiliarDefaultItemDecoration = null;
        }
        this.isDefaultItemDecoration = false;
        super.addItemDecoration(decor);
    }

    private void initDefaultItemDecoration() {
        if (!this.isDefaultItemDecoration) {
            return;
        }
        if (null != this.mFamiliarDefaultItemDecoration) {
            super.removeItemDecoration((RecyclerView.ItemDecoration)this.mFamiliarDefaultItemDecoration);
            this.mFamiliarDefaultItemDecoration = null;
        }
        this.mFamiliarDefaultItemDecoration = new FamiliarDefaultItemDecoration(this, this.mVerticalDivider, this.mHorizontalDivider, this.mVerticalDividerHeight, this.mHorizontalDividerHeight);
        this.mFamiliarDefaultItemDecoration.setItemViewBothSidesMargin(this.mItemViewBothSidesMargin);
        this.mFamiliarDefaultItemDecoration.setHeaderDividersEnabled(this.isHeaderDividersEnabled);
        this.mFamiliarDefaultItemDecoration.setFooterDividersEnabled(this.isFooterDividersEnabled);
        this.mFamiliarDefaultItemDecoration.setNotShowGridEndDivider(this.isNotShowGridEndDivider);
        if (null != this.getAdapter()) {
            this.needInitAddItemDescration = false;
            super.addItemDecoration((RecyclerView.ItemDecoration)this.mFamiliarDefaultItemDecoration);
        } else {
            this.needInitAddItemDescration = true;
        }
    }

    private void processEmptyView() {
        if (null != this.mEmptyView) {
            boolean isShowEmptyView;
            boolean bl = isShowEmptyView = (null != this.mReqAdapter ? this.mReqAdapter.getItemCount() : 0) == 0;
            if (isShowEmptyView == this.hasShowEmptyView) {
                return;
            }
            if (this.isKeepShowHeadOrFooter) {
                if (this.hasShowEmptyView) {
                    this.mWrapFamiliarRecyclerViewAdapter.notifyItemRemoved(this.getHeaderViewsCount());
                }
            } else {
                this.mEmptyView.setVisibility(isShowEmptyView ? 0 : 8);
                this.setVisibility(isShowEmptyView ? 8 : 0);
            }
            this.hasShowEmptyView = isShowEmptyView;
        }
    }

    public void setEmptyView(View emptyView) {
        this.setEmptyView(emptyView, false);
    }

    public void setEmptyView(View emptyView, boolean isKeepShowHeadOrFooter) {
        this.mEmptyView = emptyView;
        this.isKeepShowHeadOrFooter = isKeepShowHeadOrFooter;
    }

    public View getEmptyView() {
        return this.mEmptyView;
    }

    public void setEmptyViewKeepShowHeadOrFooter(boolean isKeepShowHeadOrFoot) {
        this.isKeepShowHeadOrFooter = isKeepShowHeadOrFoot;
    }

    public boolean isShowEmptyView() {
        return this.hasShowEmptyView;
    }

    public boolean isKeepShowHeadOrFooter() {
        return this.isKeepShowHeadOrFooter;
    }

    public void setDivider(int height, Drawable divider) {
        if (!this.isDefaultItemDecoration || height <= 0) {
            return;
        }
        this.mVerticalDividerHeight = height;
        this.mHorizontalDividerHeight = height;
        if (this.mVerticalDivider != divider) {
            this.mVerticalDivider = divider;
        }
        if (this.mHorizontalDivider != divider) {
            this.mHorizontalDivider = divider;
        }
        if (null != this.mFamiliarDefaultItemDecoration) {
            this.mFamiliarDefaultItemDecoration.setVerticalDividerDrawableHeight(this.mVerticalDividerHeight);
            this.mFamiliarDefaultItemDecoration.setHorizontalDividerDrawableHeight(this.mHorizontalDividerHeight);
            this.mFamiliarDefaultItemDecoration.setVerticalDividerDrawable(this.mVerticalDivider);
            this.mFamiliarDefaultItemDecoration.setHorizontalDividerDrawable(this.mHorizontalDivider);
            if (null != this.mWrapFamiliarRecyclerViewAdapter) {
                this.mWrapFamiliarRecyclerViewAdapter.notifyDataSetChanged();
            }
        }
    }

    public void setDivider(Drawable divider) {
        if (!this.isDefaultItemDecoration || this.mVerticalDividerHeight <= 0 && this.mHorizontalDividerHeight <= 0) {
            return;
        }
        if (this.mVerticalDivider != divider) {
            this.mVerticalDivider = divider;
        }
        if (this.mHorizontalDivider != divider) {
            this.mHorizontalDivider = divider;
        }
        if (null != this.mFamiliarDefaultItemDecoration) {
            this.mFamiliarDefaultItemDecoration.setVerticalDividerDrawable(this.mVerticalDivider);
            this.mFamiliarDefaultItemDecoration.setHorizontalDividerDrawable(this.mHorizontalDivider);
            if (null != this.mWrapFamiliarRecyclerViewAdapter) {
                this.mWrapFamiliarRecyclerViewAdapter.notifyDataSetChanged();
            }
        }
    }

    public void setDivider(Drawable dividerVertical, Drawable dividerHorizontal) {
        if (!this.isDefaultItemDecoration || this.mVerticalDividerHeight <= 0 && this.mHorizontalDividerHeight <= 0) {
            return;
        }
        if (this.mVerticalDivider != dividerVertical) {
            this.mVerticalDivider = dividerVertical;
        }
        if (this.mHorizontalDivider != dividerHorizontal) {
            this.mHorizontalDivider = dividerHorizontal;
        }
        if (null != this.mFamiliarDefaultItemDecoration) {
            this.mFamiliarDefaultItemDecoration.setVerticalDividerDrawable(this.mVerticalDivider);
            this.mFamiliarDefaultItemDecoration.setHorizontalDividerDrawable(this.mHorizontalDivider);
            if (null != this.mWrapFamiliarRecyclerViewAdapter) {
                this.mWrapFamiliarRecyclerViewAdapter.notifyDataSetChanged();
            }
        }
    }

    public void setDividerVertical(Drawable dividerVertical) {
        if (!this.isDefaultItemDecoration || this.mVerticalDividerHeight <= 0) {
            return;
        }
        if (this.mVerticalDivider != dividerVertical) {
            this.mVerticalDivider = dividerVertical;
        }
        if (null != this.mFamiliarDefaultItemDecoration) {
            this.mFamiliarDefaultItemDecoration.setVerticalDividerDrawable(this.mVerticalDivider);
            if (null != this.mWrapFamiliarRecyclerViewAdapter) {
                this.mWrapFamiliarRecyclerViewAdapter.notifyDataSetChanged();
            }
        }
    }

    public void setDividerHorizontal(Drawable dividerHorizontal) {
        if (!this.isDefaultItemDecoration || this.mHorizontalDividerHeight <= 0) {
            return;
        }
        if (this.mHorizontalDivider != dividerHorizontal) {
            this.mHorizontalDivider = dividerHorizontal;
        }
        if (null != this.mFamiliarDefaultItemDecoration) {
            this.mFamiliarDefaultItemDecoration.setHorizontalDividerDrawable(this.mHorizontalDivider);
            if (null != this.mWrapFamiliarRecyclerViewAdapter) {
                this.mWrapFamiliarRecyclerViewAdapter.notifyDataSetChanged();
            }
        }
    }

    public void setDividerHeight(int height) {
        if (!this.isDefaultItemDecoration) {
            return;
        }
        this.mVerticalDividerHeight = height;
        this.mHorizontalDividerHeight = height;
        if (null != this.mFamiliarDefaultItemDecoration) {
            this.mFamiliarDefaultItemDecoration.setVerticalDividerDrawableHeight(this.mVerticalDividerHeight);
            this.mFamiliarDefaultItemDecoration.setHorizontalDividerDrawableHeight(this.mHorizontalDividerHeight);
            if (null != this.mWrapFamiliarRecyclerViewAdapter) {
                this.mWrapFamiliarRecyclerViewAdapter.notifyDataSetChanged();
            }
        }
    }

    public void setDividerVerticalHeight(int height) {
        if (!this.isDefaultItemDecoration) {
            return;
        }
        this.mVerticalDividerHeight = height;
        if (null != this.mFamiliarDefaultItemDecoration) {
            this.mFamiliarDefaultItemDecoration.setVerticalDividerDrawableHeight(this.mVerticalDividerHeight);
            if (null != this.mWrapFamiliarRecyclerViewAdapter) {
                this.mWrapFamiliarRecyclerViewAdapter.notifyDataSetChanged();
            }
        }
    }

    public void setDividerHorizontalHeight(int height) {
        if (!this.isDefaultItemDecoration) {
            return;
        }
        this.mHorizontalDividerHeight = height;
        if (null != this.mFamiliarDefaultItemDecoration) {
            this.mFamiliarDefaultItemDecoration.setHorizontalDividerDrawableHeight(this.mHorizontalDividerHeight);
            if (null != this.mWrapFamiliarRecyclerViewAdapter) {
                this.mWrapFamiliarRecyclerViewAdapter.notifyDataSetChanged();
            }
        }
    }

    public void setItemViewBothSidesMargin(int bothSidesMargin) {
        if (!this.isDefaultItemDecoration) {
            return;
        }
        this.mItemViewBothSidesMargin = bothSidesMargin;
        if (null != this.mFamiliarDefaultItemDecoration) {
            this.mFamiliarDefaultItemDecoration.setItemViewBothSidesMargin(this.mItemViewBothSidesMargin);
            if (null != this.mWrapFamiliarRecyclerViewAdapter) {
                this.mWrapFamiliarRecyclerViewAdapter.notifyDataSetChanged();
            }
        }
    }

    public void setOnHeadViewBindViewHolderListener(OnHeadViewBindViewHolderListener onHeadViewBindViewHolderListener) {
        if (null != this.mWrapFamiliarRecyclerViewAdapter) {
            this.mWrapFamiliarRecyclerViewAdapter.setOnHeadViewBindViewHolderListener(onHeadViewBindViewHolderListener);
        } else {
            this.mTempOnHeadViewBindViewHolderListener = onHeadViewBindViewHolderListener;
        }
    }

    public void setOnFooterViewBindViewHolderListener(OnFooterViewBindViewHolderListener onFooterViewBindViewHolderListener) {
        if (null != this.mWrapFamiliarRecyclerViewAdapter) {
            this.mWrapFamiliarRecyclerViewAdapter.setOnFooterViewBindViewHolderListener(onFooterViewBindViewHolderListener);
        } else {
            this.mTempOnFooterViewBindViewHolderListener = onFooterViewBindViewHolderListener;
        }
    }

    public void addHeaderView(View v) {
        this.addHeaderView(v, false);
    }

    public void addHeaderView(View v, boolean isScrollTo) {
        if (this.mHeaderView.contains(v)) {
            return;
        }
        this.mHeaderView.add(v);
        if (null != this.mWrapFamiliarRecyclerViewAdapter) {
            int pos = this.mHeaderView.size() - 1;
            this.mWrapFamiliarRecyclerViewAdapter.notifyItemInserted(pos);
            if (isScrollTo) {
                this.scrollToPosition(pos);
            }
        }
    }

    public boolean removeHeaderView(View v) {
        if (!this.mHeaderView.contains(v)) {
            return false;
        }
        if (null != this.mWrapFamiliarRecyclerViewAdapter) {
            this.mWrapFamiliarRecyclerViewAdapter.notifyItemRemoved(this.mHeaderView.indexOf(v));
        }
        return this.mHeaderView.remove(v);
    }

    public void addFooterView(View v) {
        this.addFooterView(v, false);
    }

    public void addFooterView(View v, boolean isScrollTo) {
        if (this.mFooterView.contains(v)) {
            return;
        }
        this.mFooterView.add(v);
        if (null != this.mWrapFamiliarRecyclerViewAdapter) {
            int pos = (null == this.mReqAdapter ? 0 : this.mReqAdapter.getItemCount()) + this.getHeaderViewsCount() + this.mFooterView.size() - 1;
            this.mWrapFamiliarRecyclerViewAdapter.notifyItemInserted(pos);
            if (isScrollTo) {
                this.scrollToPosition(pos);
            }
        }
    }

    public boolean removeFooterView(View v) {
        if (!this.mFooterView.contains(v)) {
            return false;
        }
        if (null != this.mWrapFamiliarRecyclerViewAdapter) {
            int pos = (null == this.mReqAdapter ? 0 : this.mReqAdapter.getItemCount()) + this.getHeaderViewsCount() + this.mFooterView.indexOf(v);
            this.mWrapFamiliarRecyclerViewAdapter.notifyItemRemoved(pos);
        }
        return this.mFooterView.remove(v);
    }

    public int getHeaderViewsCount() {
        return this.mHeaderView.size();
    }

    public int getFooterViewsCount() {
        return this.mFooterView.size();
    }

    public int getFirstVisiblePosition() {
        RecyclerView.LayoutManager layoutManager = this.getLayoutManager();
        if (null == layoutManager) {
            return 0;
        }
        int ret = -1;
        switch (this.mLayoutManagerType) {
            case 0: {
                ret = ((LinearLayoutManager)layoutManager).findFirstCompletelyVisibleItemPosition() - this.getHeaderViewsCount();
                break;
            }
            case 1: {
                ret = ((GridLayoutManager)layoutManager).findFirstCompletelyVisibleItemPosition() - this.getHeaderViewsCount();
                break;
            }
            case 2: {
                StaggeredGridLayoutManager tempStaggeredGridLayoutManager = (StaggeredGridLayoutManager)layoutManager;
                int[] firstVisibleItemPositions = new int[tempStaggeredGridLayoutManager.getSpanCount()];
                tempStaggeredGridLayoutManager.findFirstCompletelyVisibleItemPositions(firstVisibleItemPositions);
                ret = firstVisibleItemPositions[0] - this.getHeaderViewsCount();
            }
        }
        return ret < 0 ? 0 : ret;
    }

    public int getLastVisiblePosition() {
        RecyclerView.LayoutManager layoutManager = this.getLayoutManager();
        if (null == layoutManager) {
            return -1;
        }
        int curItemCount = null != this.mReqAdapter ? this.mReqAdapter.getItemCount() - 1 : 0;
        int ret = -1;
        switch (this.mLayoutManagerType) {
            case 0: {
                ret = ((LinearLayoutManager)layoutManager).findLastCompletelyVisibleItemPosition() - this.getHeaderViewsCount();
                if (ret <= curItemCount) break;
                ret -= this.getFooterViewsCount();
                break;
            }
            case 1: {
                ret = ((GridLayoutManager)layoutManager).findLastCompletelyVisibleItemPosition() - this.getHeaderViewsCount();
                if (ret <= curItemCount) break;
                ret -= this.getFooterViewsCount();
                break;
            }
            case 2: {
                StaggeredGridLayoutManager tempStaggeredGridLayoutManager = (StaggeredGridLayoutManager)layoutManager;
                int[] lastVisibleItemPositions = new int[tempStaggeredGridLayoutManager.getSpanCount()];
                tempStaggeredGridLayoutManager.findLastCompletelyVisibleItemPositions(lastVisibleItemPositions);
                if (lastVisibleItemPositions.length <= 0) break;
                int maxPos = lastVisibleItemPositions[0];
                for (int curPos : lastVisibleItemPositions) {
                    if (curPos <= maxPos) continue;
                    maxPos = curPos;
                }
                ret = maxPos - this.getHeaderViewsCount();
                if (ret <= curItemCount) break;
                ret -= this.getFooterViewsCount();
            }
        }
        return ret < 0 ? (null != this.mReqAdapter ? this.mReqAdapter.getItemCount() - 1 : 0) : ret;
    }

    public void setHeaderDividersEnabled(boolean isHeaderDividersEnabled) {
        this.isHeaderDividersEnabled = isHeaderDividersEnabled;
        if (this.isDefaultItemDecoration && null != this.mFamiliarDefaultItemDecoration) {
            this.mFamiliarDefaultItemDecoration.setHeaderDividersEnabled(isHeaderDividersEnabled);
            if (null != this.mWrapFamiliarRecyclerViewAdapter) {
                this.mWrapFamiliarRecyclerViewAdapter.notifyDataSetChanged();
            }
        }
    }

    public void setFooterDividersEnabled(boolean isFooterDividersEnabled) {
        this.isFooterDividersEnabled = isFooterDividersEnabled;
        if (this.isDefaultItemDecoration && null != this.mFamiliarDefaultItemDecoration) {
            this.mFamiliarDefaultItemDecoration.setFooterDividersEnabled(isFooterDividersEnabled);
            if (null != this.mWrapFamiliarRecyclerViewAdapter) {
                this.mWrapFamiliarRecyclerViewAdapter.notifyDataSetChanged();
            }
        }
    }

    public void setNotShowGridEndDivider(boolean isNotShowGridEndDivider) {
        this.isNotShowGridEndDivider = isNotShowGridEndDivider;
        if (this.isDefaultItemDecoration && null != this.mFamiliarDefaultItemDecoration) {
            this.mFamiliarDefaultItemDecoration.setNotShowGridEndDivider(isNotShowGridEndDivider);
            if (null != this.mWrapFamiliarRecyclerViewAdapter) {
                this.mWrapFamiliarRecyclerViewAdapter.notifyDataSetChanged();
            }
        }
    }

    public int getCurLayoutManagerType() {
        return this.mLayoutManagerType;
    }

    public void setOnItemClickListener(OnItemClickListener listener) {
        if (null == this.mWrapFamiliarRecyclerViewAdapter) {
            this.mTempOnItemClickListener = listener;
        } else {
            this.mWrapFamiliarRecyclerViewAdapter.setOnItemClickListener(listener);
        }
    }

    public void setOnItemLongClickListener(OnItemLongClickListener listener) {
        if (null == this.mWrapFamiliarRecyclerViewAdapter) {
            this.mTempOnItemLongClickListener = listener;
        } else {
            this.mWrapFamiliarRecyclerViewAdapter.setOnItemLongClickListener(listener);
        }
    }

    public static interface OnFooterViewBindViewHolderListener {
        public void onFooterViewBindViewHolder(RecyclerView.ViewHolder var1, int var2, boolean var3);
    }

    public static interface OnHeadViewBindViewHolderListener {
        public void onHeadViewBindViewHolder(RecyclerView.ViewHolder var1, int var2, boolean var3);
    }

    public static interface OnItemLongClickListener {
        public boolean onItemLongClick(FamiliarRecyclerView var1, View var2, int var3);
    }

    public static interface OnItemClickListener {
        public void onItemClick(FamiliarRecyclerView var1, View var2, int var3);
    }
}

