/*
 * Decompiled with CFR 0.152.
 */
package cn.iwgang.familiarrecyclerview;

import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.StaggeredGridLayoutManager;

public abstract class FamiliarRecyclerViewOnScrollListener
extends RecyclerView.OnScrollListener {
    private LinearLayoutManager mLinearLayoutManager;
    private GridLayoutManager mGridLayoutManager;
    private StaggeredGridLayoutManager mStaggeredGridLayoutManager;
    private int mLayoutManagerType = 1;
    private boolean isCanScrolledCallback = false;
    private int[] mStaggeredFirstPositions;
    private int[] mStaggeredLastPositions;
    private int callbackType = 0;

    public FamiliarRecyclerViewOnScrollListener(RecyclerView.LayoutManager layoutManager) {
        if (layoutManager.getClass().isAssignableFrom(LinearLayoutManager.class)) {
            this.mLayoutManagerType = 1;
            this.mLinearLayoutManager = (LinearLayoutManager)layoutManager;
        } else if (layoutManager.getClass().isAssignableFrom(GridLayoutManager.class)) {
            this.mLayoutManagerType = 2;
            this.mGridLayoutManager = (GridLayoutManager)layoutManager;
        } else if (layoutManager.getClass().isAssignableFrom(StaggeredGridLayoutManager.class)) {
            this.mLayoutManagerType = 3;
            this.mStaggeredGridLayoutManager = (StaggeredGridLayoutManager)layoutManager;
            this.mStaggeredLastPositions = new int[this.mStaggeredGridLayoutManager.getSpanCount()];
            this.mStaggeredFirstPositions = new int[this.mStaggeredGridLayoutManager.getSpanCount()];
        }
    }

    public final void onScrolled(RecyclerView recyclerView, int dx, int dy) {
        super.onScrolled(recyclerView, dx, dy);
        if (!this.isCanScrolledCallback) {
            return;
        }
        if (this.checkToTop()) {
            this.callbackType = 1;
            if (!this.isIdleCallBack()) {
                this.onScrolledToTop();
            }
        } else if (this.checkToBottom(recyclerView)) {
            this.callbackType = 2;
            if (!this.isIdleCallBack()) {
                this.onScrolledToBottom();
            }
        } else {
            this.callbackType = 0;
        }
    }

    public final void onScrollStateChanged(RecyclerView recyclerView, int newState) {
        super.onScrollStateChanged(recyclerView, newState);
        switch (newState) {
            case 0: {
                this.isCanScrolledCallback = false;
                if (!this.isIdleCallBack()) break;
                if (this.callbackType == 1) {
                    this.onScrolledToTop();
                    break;
                }
                if (this.callbackType != 2) break;
                this.onScrolledToBottom();
                break;
            }
            case 1: {
                this.isCanScrolledCallback = true;
            }
        }
    }

    private boolean checkToTop() {
        switch (this.mLayoutManagerType) {
            case 1: {
                return this.mLinearLayoutManager.findFirstCompletelyVisibleItemPosition() == 0;
            }
            case 2: {
                return this.mGridLayoutManager.findFirstCompletelyVisibleItemPosition() == 0;
            }
            case 3: {
                this.mStaggeredGridLayoutManager.findFirstCompletelyVisibleItemPositions(this.mStaggeredFirstPositions);
                return this.mStaggeredFirstPositions[0] == 0;
            }
        }
        return false;
    }

    private boolean checkToBottom(RecyclerView recyclerView) {
        switch (this.mLayoutManagerType) {
            case 1: {
                return this.mLinearLayoutManager.findLastCompletelyVisibleItemPosition() == recyclerView.getAdapter().getItemCount() - 1;
            }
            case 2: {
                return this.mGridLayoutManager.findLastCompletelyVisibleItemPosition() == recyclerView.getAdapter().getItemCount() - 1;
            }
            case 3: {
                this.mStaggeredGridLayoutManager.findLastCompletelyVisibleItemPositions(this.mStaggeredLastPositions);
                if (this.mStaggeredLastPositions.length <= 0) break;
                int totalCount = recyclerView.getAdapter().getItemCount() - 1;
                for (int curPos : this.mStaggeredLastPositions) {
                    if (curPos != totalCount) continue;
                    return true;
                }
                break;
            }
        }
        return false;
    }

    public abstract void onScrolledToTop();

    public abstract void onScrolledToBottom();

    protected boolean isIdleCallBack() {
        return true;
    }
}

