/*
 * Decompiled with CFR 0.152.
 */
package cn.iwgang.familiarrecyclerview;

import android.content.Context;
import android.os.Handler;
import android.support.v4.widget.SwipeRefreshLayout;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import cn.iwgang.familiarrecyclerview.FamiliarRecyclerView;
import cn.iwgang.familiarrecyclerview.FamiliarRecyclerViewOnScrollListener;
import cn.iwgang.familiarrecyclerview.IFamiliarLoadMore;

public class FamiliarRefreshRecyclerView
extends SwipeRefreshLayout
implements SwipeRefreshLayout.OnRefreshListener {
    private FamiliarRecyclerView mRvList;
    private IFamiliarLoadMore mLoadMoreView;
    private OnPullRefreshListener mOnPullRefreshListener;
    private OnLoadMoreListener mOnLoadMoreListener;
    private FamiliarRecyclerViewOnScrollListener mFamiliarRecyclerViewOnScrollListener;
    private boolean isPullRefreshEnabled = true;
    private boolean isLoadMoreEnabled = false;
    private boolean isSetLoadMoreView = false;

    public FamiliarRefreshRecyclerView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initViews(attrs);
    }

    private void initViews(AttributeSet attrs) {
        this.mRvList = new FamiliarRecyclerView(this.getContext(), attrs);
        this.addView((View)this.mRvList, new ViewGroup.LayoutParams(-1, -1));
        this.setOnRefreshListener(this);
    }

    public void onRefresh() {
        if (!this.isPullRefreshEnabled) {
            return;
        }
        this.callOnPullRefresh();
    }

    public void setAdapter(RecyclerView.Adapter adapter) {
        this.mRvList.setAdapter(adapter);
    }

    public void setLoadMoreView(IFamiliarLoadMore loadMoreView) {
        if (null == loadMoreView) {
            if (null != this.mLoadMoreView) {
                this.mRvList.removeFooterView(this.mLoadMoreView.getView());
                this.mRvList.removeOnScrollListener(this.mFamiliarRecyclerViewOnScrollListener);
                this.isSetLoadMoreView = false;
                this.mLoadMoreView = null;
            }
            return;
        }
        this.mLoadMoreView = loadMoreView;
        this.initializeLoadMoreView();
        this.isSetLoadMoreView = null != this.mLoadMoreView;
    }

    public FamiliarRecyclerView getFamiliarRecyclerView() {
        return this.mRvList;
    }

    protected void autoRefresh() {
        if (!this.isPullRefreshEnabled) {
            return;
        }
        this.setRefreshing(true);
        new Handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                FamiliarRefreshRecyclerView.this.callOnPullRefresh();
            }
        }, 1000L);
    }

    public void setPullRefreshEnabled(boolean enabled) {
        if (this.isPullRefreshEnabled == enabled) {
            return;
        }
        this.setEnabled(enabled);
        if (!enabled) {
            this.setRefreshing(false);
        }
        this.isPullRefreshEnabled = enabled;
    }

    public void setLoadMoreEnabled(boolean enabled) {
        if (!this.isSetLoadMoreView || this.isLoadMoreEnabled == enabled || null == this.mLoadMoreView) {
            return;
        }
        if (!enabled) {
            this.mRvList.removeFooterView(this.mLoadMoreView.getView());
        } else {
            this.mRvList.addFooterView(this.mLoadMoreView.getView());
        }
        this.isLoadMoreEnabled = enabled;
    }

    public void pullRefreshComplete() {
        this.setRefreshing(false);
    }

    public void loadMoreComplete() {
        if (this.isSetLoadMoreView) {
            this.mLoadMoreView.showNormal();
        }
    }

    private void initializeLoadMoreView() {
        if (null == this.mFamiliarRecyclerViewOnScrollListener) {
            this.mFamiliarRecyclerViewOnScrollListener = new FamiliarRecyclerViewOnScrollListener(this.mRvList.getLayoutManager()){

                @Override
                public void onScrolledToTop() {
                }

                @Override
                public void onScrolledToBottom() {
                    if (!FamiliarRefreshRecyclerView.this.isLoadMoreEnabled || !FamiliarRefreshRecyclerView.this.isSetLoadMoreView || FamiliarRefreshRecyclerView.this.mLoadMoreView.isLoading()) {
                        return;
                    }
                    FamiliarRefreshRecyclerView.this.mLoadMoreView.showLoading();
                    FamiliarRefreshRecyclerView.this.callOnLoadMore();
                }
            };
        }
        this.mRvList.addOnScrollListener(this.mFamiliarRecyclerViewOnScrollListener);
        this.mLoadMoreView.getView().setLayoutParams((ViewGroup.LayoutParams)new RecyclerView.LayoutParams(-1, -2));
    }

    private void callOnPullRefresh() {
        if (null != this.mOnPullRefreshListener) {
            this.mOnPullRefreshListener.onPullRefresh();
        }
    }

    private void callOnLoadMore() {
        if (null != this.mOnLoadMoreListener) {
            this.mOnLoadMoreListener.onLoadMore();
        }
    }

    public void setOnPullRefreshListener(OnPullRefreshListener onPullRefreshListener) {
        this.mOnPullRefreshListener = onPullRefreshListener;
    }

    public void setOnLoadMoreListener(OnLoadMoreListener onLoadMoreListener) {
        this.mOnLoadMoreListener = onLoadMoreListener;
    }

    public void setOnItemClickListener(FamiliarRecyclerView.OnItemClickListener onItemClickListener) {
        if (null != onItemClickListener) {
            this.mRvList.setOnItemClickListener(onItemClickListener);
        }
    }

    public void setOnItemLongClickListener(FamiliarRecyclerView.OnItemLongClickListener onItemLongClickListener) {
        if (null != onItemLongClickListener) {
            this.mRvList.setOnItemLongClickListener(onItemLongClickListener);
        }
    }

    public static interface OnLoadMoreListener {
        public void onLoadMore();
    }

    public static interface OnPullRefreshListener {
        public void onPullRefresh();
    }
}

