/*
 * Decompiled with CFR 0.152.
 */
package cn.iwgang.familiarrecyclerview;

import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.StaggeredGridLayoutManager;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.FrameLayout;
import cn.iwgang.familiarrecyclerview.FamiliarRecyclerView;
import java.util.ArrayList;
import java.util.List;

public class FamiliarWrapRecyclerViewAdapter
extends RecyclerView.Adapter
implements View.OnClickListener,
View.OnLongClickListener {
    private static final int MIN_INTERVAL_CLICK_TIME = 100;
    private static final int VIEW_TYPE_HEADER = -1;
    private static final int VIEW_TYPE_FOOTER = -2;
    private static final int VIEW_TYPE_EMPTY_VIEW = -3;
    private List<View> mHeaderView;
    private List<View> mFooterView;
    private RecyclerView.Adapter mReqAdapter;
    private int curHeaderOrFooterPos;
    private int mLayoutManagerType = 0;
    private FamiliarRecyclerView.OnItemClickListener mOnItemClickListener;
    private FamiliarRecyclerView.OnItemLongClickListener mOnItemLongClickListener;
    private FamiliarRecyclerView mFamiliarRecyclerView;
    private long mLastClickTime;
    private FamiliarRecyclerView.OnHeadViewBindViewHolderListener mOnHeadViewBindViewHolderListener;
    private FamiliarRecyclerView.OnFooterViewBindViewHolderListener mOnFooterViewBindViewHolderListener;
    private List<Integer> mHeadOrFooterInitInvokeViewBindViewFlag = new ArrayList<Integer>();

    public FamiliarWrapRecyclerViewAdapter(FamiliarRecyclerView familiarRecyclerView, RecyclerView.Adapter reqAdapter, List<View> mHeaderView, List<View> mFooterView, int layoutManagerType) {
        this.mFamiliarRecyclerView = familiarRecyclerView;
        this.mReqAdapter = reqAdapter;
        this.mHeaderView = mHeaderView;
        this.mFooterView = mFooterView;
        this.mLayoutManagerType = layoutManagerType;
    }

    public int getHeadersCount() {
        return null != this.mHeaderView ? this.mHeaderView.size() : 0;
    }

    public int getFootersCount() {
        return null != this.mFooterView ? this.mFooterView.size() : 0;
    }

    private int getReqAdapterCount() {
        return null != this.mReqAdapter ? this.mReqAdapter.getItemCount() : 0;
    }

    public int getItemCount() {
        int count = 0;
        int tempItemCount = this.mReqAdapter.getItemCount();
        count = this.mFamiliarRecyclerView.isKeepShowHeadOrFooter() ? (count += tempItemCount == 0 ? 1 : tempItemCount) : (count += tempItemCount);
        if (null != this.mHeaderView && this.mHeaderView.size() > 0) {
            count += this.mHeaderView.size();
        }
        if (null != this.mFooterView && this.mFooterView.size() > 0) {
            count += this.mFooterView.size();
        }
        return count;
    }

    public int getItemViewType(int position) {
        if (this.isHeaderView(position)) {
            this.curHeaderOrFooterPos = position;
            return -1;
        }
        int headersCount = this.getHeadersCount();
        int adapterCount = 0;
        if (this.getReqAdapterCount() > 0 && position >= headersCount) {
            int adjPosition = position - headersCount;
            adapterCount = this.mReqAdapter.getItemCount();
            if (adjPosition < adapterCount) {
                return this.mReqAdapter.getItemViewType(adjPosition);
            }
        } else if (this.mFamiliarRecyclerView.isKeepShowHeadOrFooter() && position == headersCount) {
            return -3;
        }
        this.curHeaderOrFooterPos = position - headersCount - adapterCount;
        return -2;
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        switch (viewType) {
            case -1: {
                EmptyHeaderOrFooterViewHolder headerViewHolder;
                View tempHeadView = this.mHeaderView.get(this.curHeaderOrFooterPos);
                if (this.mLayoutManagerType == 2) {
                    FrameLayout mContainerView = new FrameLayout(tempHeadView.getContext());
                    mContainerView.addView(tempHeadView);
                    headerViewHolder = new EmptyHeaderOrFooterViewHolder((View)mContainerView);
                    StaggeredGridLayoutManager.LayoutParams layoutParams = new StaggeredGridLayoutManager.LayoutParams(-2, -2);
                    layoutParams.setFullSpan(true);
                    headerViewHolder.itemView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                } else {
                    headerViewHolder = new EmptyHeaderOrFooterViewHolder(tempHeadView);
                }
                if (this.mHeaderView.size() > 2) {
                    headerViewHolder.setIsRecyclable(false);
                }
                return headerViewHolder;
            }
            case -2: {
                EmptyHeaderOrFooterViewHolder footerViewHolder;
                View tempFooterView;
                ViewParent tempFooterViewParent;
                int footerViewCount = this.mFooterView.size();
                if (this.curHeaderOrFooterPos >= footerViewCount) {
                    this.curHeaderOrFooterPos = footerViewCount - 1;
                }
                if (null != (tempFooterViewParent = (tempFooterView = this.mFooterView.get(this.curHeaderOrFooterPos)).getParent())) {
                    ((ViewGroup)tempFooterViewParent).removeView(tempFooterView);
                }
                if (this.mLayoutManagerType == 2) {
                    FrameLayout mContainerView = new FrameLayout(tempFooterView.getContext());
                    mContainerView.addView(tempFooterView);
                    footerViewHolder = new EmptyHeaderOrFooterViewHolder((View)mContainerView);
                    StaggeredGridLayoutManager.LayoutParams layoutParams = new StaggeredGridLayoutManager.LayoutParams(-2, -2);
                    layoutParams.setFullSpan(true);
                    footerViewHolder.itemView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                } else {
                    footerViewHolder = new EmptyHeaderOrFooterViewHolder(tempFooterView);
                }
                if (this.mFooterView.size() > 2) {
                    footerViewHolder.setIsRecyclable(false);
                }
                return footerViewHolder;
            }
            case -3: {
                EmptyHeaderOrFooterViewHolder emptyViewHolder;
                View emptyView = this.mFamiliarRecyclerView.getEmptyView();
                emptyView.setVisibility(0);
                if (this.mLayoutManagerType == 2) {
                    FrameLayout mContainerView = new FrameLayout(emptyView.getContext());
                    mContainerView.addView(emptyView);
                    emptyViewHolder = new EmptyHeaderOrFooterViewHolder((View)mContainerView);
                    StaggeredGridLayoutManager.LayoutParams layoutParams = new StaggeredGridLayoutManager.LayoutParams(-2, -2);
                    layoutParams.setFullSpan(true);
                    emptyViewHolder.itemView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                } else {
                    emptyViewHolder = new EmptyHeaderOrFooterViewHolder(emptyView);
                }
                return emptyViewHolder;
            }
        }
        RecyclerView.ViewHolder itemViewHolder = this.mReqAdapter.onCreateViewHolder(parent, viewType);
        if (null != this.mOnItemClickListener) {
            itemViewHolder.itemView.setOnClickListener((View.OnClickListener)this);
        }
        if (null != this.mOnItemLongClickListener) {
            itemViewHolder.itemView.setOnLongClickListener((View.OnLongClickListener)this);
        }
        return itemViewHolder;
    }

    public void onViewAttachedToWindow(RecyclerView.ViewHolder holder) {
        super.onViewAttachedToWindow(holder);
        int position = holder.getAdapterPosition();
        if (null == this.mReqAdapter || this.isHeaderView(position) || this.isFooterView(position)) {
            return;
        }
        this.mReqAdapter.onViewAttachedToWindow(holder);
    }

    public void onViewDetachedFromWindow(RecyclerView.ViewHolder holder) {
        super.onViewDetachedFromWindow(holder);
        int position = holder.getAdapterPosition();
        if (null == this.mReqAdapter || this.isHeaderView(position) || this.isFooterView(position)) {
            return;
        }
        this.mReqAdapter.onViewDetachedFromWindow(holder);
    }

    public void onAttachedToRecyclerView(RecyclerView recyclerView) {
        super.onAttachedToRecyclerView(recyclerView);
        if (null == this.mReqAdapter) {
            return;
        }
        this.mReqAdapter.onAttachedToRecyclerView(recyclerView);
    }

    public void onDetachedFromRecyclerView(RecyclerView recyclerView) {
        super.onDetachedFromRecyclerView(recyclerView);
        if (null == this.mReqAdapter) {
            return;
        }
        this.mReqAdapter.onDetachedFromRecyclerView(recyclerView);
    }

    public void onViewRecycled(RecyclerView.ViewHolder holder) {
        super.onViewRecycled(holder);
        int position = holder.getAdapterPosition();
        if (null == this.mReqAdapter || this.isHeaderView(position) || this.isFooterView(position)) {
            return;
        }
        this.mReqAdapter.onViewRecycled(holder);
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
        int curItemViewType = this.getItemViewType(position);
        if (curItemViewType == -1 && null != this.mOnHeadViewBindViewHolderListener) {
            boolean isInitializeInvoke = false;
            int tempHeadViewHashCode = holder.itemView.hashCode();
            if (!this.mHeadOrFooterInitInvokeViewBindViewFlag.contains(tempHeadViewHashCode)) {
                this.mHeadOrFooterInitInvokeViewBindViewFlag.add(tempHeadViewHashCode);
                isInitializeInvoke = true;
            }
            this.mOnHeadViewBindViewHolderListener.onHeadViewBindViewHolder(holder, position, isInitializeInvoke);
        } else if (curItemViewType == -2 && null != this.mOnFooterViewBindViewHolderListener) {
            boolean isInitializeInvoke = false;
            int tempFooterViewHashCode = holder.itemView.hashCode();
            if (!this.mHeadOrFooterInitInvokeViewBindViewFlag.contains(tempFooterViewHashCode)) {
                this.mHeadOrFooterInitInvokeViewBindViewFlag.add(tempFooterViewHashCode);
                isInitializeInvoke = true;
            }
            this.mOnFooterViewBindViewHolderListener.onFooterViewBindViewHolder(holder, position - this.getHeadersCount() - this.getReqAdapterCount(), isInitializeInvoke);
        } else if (curItemViewType >= 0) {
            int adapterCount;
            int adjPosition = position - this.getHeadersCount();
            if (this.mReqAdapter != null && adjPosition < (adapterCount = this.mReqAdapter.getItemCount())) {
                this.mReqAdapter.onBindViewHolder(holder, adjPosition);
            }
        }
    }

    public void setOnItemClickListener(FamiliarRecyclerView.OnItemClickListener mOnItemClickListener) {
        this.mOnItemClickListener = mOnItemClickListener;
    }

    public void setOnItemLongClickListener(FamiliarRecyclerView.OnItemLongClickListener mOnItemLongClickListener) {
        this.mOnItemLongClickListener = mOnItemLongClickListener;
    }

    public void onClick(View v) {
        long curTime = System.currentTimeMillis();
        if (null != this.mOnItemClickListener && curTime - this.mLastClickTime > 100L) {
            this.mLastClickTime = curTime;
            this.mOnItemClickListener.onItemClick(this.mFamiliarRecyclerView, v, this.mFamiliarRecyclerView.getChildAdapterPosition(v) - this.mFamiliarRecyclerView.getHeaderViewsCount());
        }
    }

    public boolean onLongClick(View v) {
        long curTime = System.currentTimeMillis();
        if (null != this.mOnItemClickListener && curTime - this.mLastClickTime > 100L) {
            this.mLastClickTime = curTime;
            return this.mOnItemLongClickListener.onItemLongClick(this.mFamiliarRecyclerView, v, this.mFamiliarRecyclerView.getChildAdapterPosition(v) - this.mFamiliarRecyclerView.getHeaderViewsCount());
        }
        return false;
    }

    public void setOnHeadViewBindViewHolderListener(FamiliarRecyclerView.OnHeadViewBindViewHolderListener mOnHeadViewBindViewHolderListener) {
        this.mOnHeadViewBindViewHolderListener = mOnHeadViewBindViewHolderListener;
    }

    public void setOnFooterViewBindViewHolderListener(FamiliarRecyclerView.OnFooterViewBindViewHolderListener mOnFooterViewBindViewHolderListener) {
        this.mOnFooterViewBindViewHolderListener = mOnFooterViewBindViewHolderListener;
    }

    private boolean isHeaderView(int position) {
        return position < this.getHeadersCount();
    }

    private boolean isFooterView(int position) {
        return this.getFootersCount() > 0 && position - this.getHeadersCount() - this.getReqAdapterCount() >= 0;
    }

    class EmptyHeaderOrFooterViewHolder
    extends RecyclerView.ViewHolder {
        public EmptyHeaderOrFooterViewHolder(View itemView) {
            super(itemView);
        }
    }
}

