/*
 * Decompiled with CFR 0.152.
 */
package org.restonfire;

import com.google.gson.Gson;
import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.HttpResponseBodyPart;
import com.ning.http.client.HttpResponseHeaders;
import com.ning.http.client.HttpResponseStatus;
import com.ning.http.client.ListenableFuture;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.jdeferred.Deferred;
import org.jdeferred.Promise;
import org.jdeferred.impl.DeferredObject;
import org.restonfire.FirebaseDocumentLocation;
import org.restonfire.FirebaseRestEventStream;
import org.restonfire.PathUtil;
import org.restonfire.RequestBuilderUtil;
import org.restonfire.exceptions.FirebaseAccessException;
import org.restonfire.exceptions.FirebaseAuthenticationExpiredException;
import org.restonfire.exceptions.FirebaseInvalidStateException;
import org.restonfire.exceptions.FirebaseRestException;
import org.restonfire.exceptions.FirebaseRuntimeException;
import org.restonfire.responses.StreamingEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FirebaseRestEventStreamImpl
extends FirebaseDocumentLocation
implements FirebaseRestEventStream {
    private static final Logger LOG = LoggerFactory.getLogger(FirebaseRestEventStreamImpl.class);
    private static final Map<String, StreamingEvent.EventType> EVENT_TYPE_MAPPER = new HashMap<String, StreamingEvent.EventType>(5);
    private final Gson gson;
    private final AsyncHttpClient asyncHttpClient;
    private final AsyncHttpClient.BoundRequestBuilder eventStreamRequest;
    private ListenableFuture<Void> currentListener;

    FirebaseRestEventStreamImpl(AsyncHttpClient asyncHttpClient, Gson gson, String fbBaseUrl, String fbAccessToken, String path) {
        super(fbBaseUrl, path, fbAccessToken);
        this.asyncHttpClient = asyncHttpClient;
        this.gson = gson;
        this.eventStreamRequest = (AsyncHttpClient.BoundRequestBuilder)RequestBuilderUtil.createGet(asyncHttpClient, this.referenceUrl, fbAccessToken).addHeader("Accept", "text/event-stream").setFollowRedirects(true);
    }

    @Override
    public Promise<Void, FirebaseRuntimeException, StreamingEvent> startListening() {
        LOG.debug("startListening() invoked for reference {}", (Object)this.referenceUrl);
        if (this.currentListener != null) {
            throw new FirebaseInvalidStateException(FirebaseRuntimeException.ErrorCode.EventStreamListenerAlreadyActive, "The EventStream is already running");
        }
        DeferredObject deferred = new DeferredObject();
        AsyncHandler<Void> asyncRequestHandler = this.createAsyncHandler((Deferred<Void, FirebaseRuntimeException, StreamingEvent>)deferred);
        this.currentListener = this.eventStreamRequest.execute(asyncRequestHandler);
        return deferred.promise();
    }

    @Override
    public void stopListening() {
        if (this.currentListener == null) {
            throw new FirebaseInvalidStateException(FirebaseRuntimeException.ErrorCode.EventStreamListenerNotActive, "The EventStream is currently not active");
        }
        this.currentListener.done();
        this.currentListener = null;
    }

    @Override
    public FirebaseRestEventStream getRoot() {
        LOG.debug("getRoot() invoked for reference {}", (Object)this.referenceUrl);
        return new FirebaseRestEventStreamImpl(this.asyncHttpClient, this.gson, this.fbBaseUrl, this.fbAccessToken, "");
    }

    @Override
    public FirebaseRestEventStream getParent() {
        LOG.debug("getParent() invoked for reference {}", (Object)this.referenceUrl);
        return new FirebaseRestEventStreamImpl(this.asyncHttpClient, this.gson, this.fbBaseUrl, this.fbAccessToken, PathUtil.getParent(this.path));
    }

    @Override
    public FirebaseRestEventStream child(String childPath) {
        LOG.debug("child({}) invoked for reference {}", (Object)childPath, (Object)this.referenceUrl);
        return new FirebaseRestEventStreamImpl(this.asyncHttpClient, this.gson, this.fbBaseUrl, this.fbAccessToken, PathUtil.concatenatePath(this.path, childPath));
    }

    private AsyncHandler<Void> createAsyncHandler(final Deferred<Void, FirebaseRuntimeException, StreamingEvent> deferred) {
        return new AsyncHandler<Void>(){

            public void onThrowable(Throwable t) {
                String message = "EventStream request for location '" + FirebaseRestEventStreamImpl.this.referenceUrl + "' failed";
                LOG.error(message, t);
                deferred.reject((Object)new FirebaseRestException(FirebaseRuntimeException.ErrorCode.EventStreamRequestFailed, message, t));
            }

            public AsyncHandler.STATE onBodyPartReceived(HttpResponseBodyPart bodyPart) throws Exception {
                LOG.debug("Received event");
                StreamingEvent response = FirebaseRestEventStreamImpl.this.parseResponse(bodyPart.getBodyPartBytes());
                switch (response.getEventType()) {
                    case KeepAlive: {
                        break;
                    }
                    case Cancel: {
                        deferred.reject((Object)new FirebaseAccessException(FirebaseRestEventStreamImpl.this.referenceUrl));
                        break;
                    }
                    case Expired: {
                        deferred.reject((Object)new FirebaseAuthenticationExpiredException(FirebaseRestEventStreamImpl.this.referenceUrl));
                        break;
                    }
                    default: {
                        deferred.notify((Object)response);
                    }
                }
                return AsyncHandler.STATE.CONTINUE;
            }

            public AsyncHandler.STATE onStatusReceived(HttpResponseStatus responseStatus) throws Exception {
                LOG.info("Received Status: " + responseStatus.getStatusCode());
                switch (responseStatus.getStatusCode()) {
                    case 200: 
                    case 307: {
                        break;
                    }
                    case 401: 
                    case 403: {
                        LOG.warn("The request to '{}' that violates the Security and Firebase Rules", (Object)FirebaseRestEventStreamImpl.this.referenceUrl);
                        deferred.reject((Object)new FirebaseAccessException(responseStatus));
                        break;
                    }
                    default: {
                        LOG.error("Unsupported status code: " + responseStatus.getStatusCode());
                        deferred.reject((Object)new FirebaseRestException(FirebaseRuntimeException.ErrorCode.UnsupportedStatusCode, responseStatus));
                    }
                }
                return AsyncHandler.STATE.CONTINUE;
            }

            public AsyncHandler.STATE onHeadersReceived(HttpResponseHeaders headers) throws Exception {
                LOG.debug("Received headers");
                return AsyncHandler.STATE.CONTINUE;
            }

            public Void onCompleted() throws Exception {
                LOG.info("DONE");
                deferred.resolve(null);
                return null;
            }
        };
    }

    /*
     * Exception decompiling
     */
    private StreamingEvent parseResponse(byte[] response) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private StreamingEvent.EventType getEventType(String eventString) {
        LOG.debug("Mapping event type -> " + eventString);
        return EVENT_TYPE_MAPPER.get(eventString.replaceFirst("event:", "").trim().toLowerCase());
    }

    private String getEventData(String dataString) {
        LOG.debug("Extracting event data -> " + dataString);
        return dataString.replaceFirst("data:", "").trim();
    }

    static {
        EVENT_TYPE_MAPPER.put("put", StreamingEvent.EventType.Set);
        EVENT_TYPE_MAPPER.put("patch", StreamingEvent.EventType.Update);
        EVENT_TYPE_MAPPER.put("keep-alive", StreamingEvent.EventType.KeepAlive);
        EVENT_TYPE_MAPPER.put("cancel", StreamingEvent.EventType.Cancel);
        EVENT_TYPE_MAPPER.put("auth_revoked", StreamingEvent.EventType.Expired);
    }
}

