/*
 * Decompiled with CFR 0.152.
 */
package org.restonfire.responses;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import org.restonfire.responses.StreamingEventData;

public class StreamingEvent {
    private final Gson gson;
    private final EventType eventType;
    private final String eventData;

    public StreamingEvent(Gson gson, EventType eventType, String eventData) {
        this.gson = gson;
        this.eventType = eventType;
        this.eventData = eventData;
    }

    public EventType getEventType() {
        return this.eventType;
    }

    public String getSerialzedEventData() {
        return this.eventData;
    }

    public StreamingEventData getEventData() {
        return this.eventType == EventType.Set || this.eventType == EventType.Update ? (StreamingEventData)this.gson.fromJson(this.eventData, StreamingEventData.class) : null;
    }

    public <T> StreamingEventData<T> getEventData(TypeToken<StreamingEventData<T>> typeToken) {
        return this.eventType == EventType.Set || this.eventType == EventType.Update ? (StreamingEventData)this.gson.fromJson(this.eventData, typeToken.getType()) : null;
    }

    public static enum EventType {
        Set,
        Update,
        KeepAlive,
        Cancel,
        Expired;

    }
}

