/*
 * Decompiled with CFR 0.152.
 */
package org.restonfire;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.ning.http.client.AsyncCompletionHandler;
import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.Response;
import java.io.IOException;
import org.jdeferred.Deferred;
import org.jdeferred.Promise;
import org.jdeferred.impl.DeferredObject;
import org.restonfire.FirebaseDocumentLocation;
import org.restonfire.FirebaseRestReference;
import org.restonfire.PathUtil;
import org.restonfire.RequestBuilderUtil;
import org.restonfire.exceptions.FirebaseAccessException;
import org.restonfire.exceptions.FirebaseRestException;
import org.restonfire.exceptions.FirebaseRuntimeException;
import org.restonfire.responses.PushResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class FirebaseRestReferenceImpl
extends FirebaseDocumentLocation
implements FirebaseRestReference {
    private static final Logger LOG = LoggerFactory.getLogger(FirebaseRestReferenceImpl.class);
    private static final String FAILED_TO_PARSE_RESPONSE_BODY_FOR_REQUEST = "Failed to parse responses body for request: ";
    private final Gson gson;
    private final AsyncHttpClient asyncHttpClient;

    FirebaseRestReferenceImpl(AsyncHttpClient asyncHttpClient, Gson gson, String fbBaseUrl, String fbAccessToken, String path) {
        super(fbBaseUrl, path, fbAccessToken);
        this.gson = gson;
        this.asyncHttpClient = asyncHttpClient;
    }

    @Override
    public <T> Promise<T, FirebaseRuntimeException, Void> getValue(final Class<T> clazz) {
        LOG.debug("getValue({}) invoked for reference {}", clazz, (Object)this.referenceUrl);
        DeferredObject deferred = new DeferredObject();
        AsyncHttpClient.BoundRequestBuilder getRequest = RequestBuilderUtil.createGet(this.asyncHttpClient, this.referenceUrl, this.fbAccessToken);
        getRequest.execute((AsyncHandler)new AsyncCompletionHandler<Void>((Deferred)deferred){
            final /* synthetic */ Deferred val$deferred;
            {
                this.val$deferred = deferred;
            }

            public Void onCompleted(Response response) throws Exception {
                try {
                    LOG.debug("Request for getValue({}) completed", (Object)clazz);
                    Object result = FirebaseRestReferenceImpl.this.handleResponse(response, clazz);
                    this.val$deferred.resolve(result);
                }
                catch (FirebaseRuntimeException ex) {
                    this.val$deferred.reject((Object)ex);
                }
                return null;
            }
        });
        return deferred.promise();
    }

    @Override
    public <T> Promise<T, FirebaseRuntimeException, Void> setValue(final T value) {
        LOG.debug("setValue({}) invoked for reference {}", value, (Object)this.referenceUrl);
        DeferredObject deferred = new DeferredObject();
        AsyncHttpClient.BoundRequestBuilder putRequest = RequestBuilderUtil.createPut(this.asyncHttpClient, this.referenceUrl, this.fbAccessToken, this.gson.toJson(value));
        putRequest.execute((AsyncHandler)new AsyncCompletionHandler<Void>((Deferred)deferred){
            final /* synthetic */ Deferred val$deferred;
            {
                this.val$deferred = deferred;
            }

            public Void onCompleted(Response response) throws Exception {
                LOG.debug("Request for setValue({}) completed for reference {}", value, (Object)FirebaseRestReferenceImpl.this.referenceUrl);
                return FirebaseRestReferenceImpl.this.handleValueModifiedResponse(response, this.val$deferred, value);
            }
        });
        return deferred.promise();
    }

    public <T> Promise<T, FirebaseRuntimeException, Void> updateValue(final T value) {
        LOG.debug("updateValue({}) invoked for reference {}", value, (Object)this.referenceUrl);
        DeferredObject deferred = new DeferredObject();
        AsyncHttpClient.BoundRequestBuilder patchRequest = RequestBuilderUtil.createPatch(this.asyncHttpClient, this.referenceUrl, this.fbAccessToken, this.gson.toJson(value));
        patchRequest.execute((AsyncHandler)new AsyncCompletionHandler<Void>((Deferred)deferred){
            final /* synthetic */ Deferred val$deferred;
            {
                this.val$deferred = deferred;
            }

            public Void onCompleted(Response response) throws Exception {
                LOG.debug("Request for updateValue({}) completed for reference {}", value, (Object)FirebaseRestReferenceImpl.this.referenceUrl);
                return FirebaseRestReferenceImpl.this.handleValueModifiedResponse(response, this.val$deferred, value);
            }
        });
        return deferred.promise();
    }

    @Override
    public Promise<Void, FirebaseRuntimeException, Void> removeValue() {
        LOG.debug("removeValue() invoked for reference {}", (Object)this.referenceUrl);
        DeferredObject deferred = new DeferredObject();
        AsyncHttpClient.BoundRequestBuilder deleteRequest = RequestBuilderUtil.createDelete(this.asyncHttpClient, this.referenceUrl, this.fbAccessToken);
        deleteRequest.execute((AsyncHandler)new AsyncCompletionHandler<Void>((Deferred)deferred){
            final /* synthetic */ Deferred val$deferred;
            {
                this.val$deferred = deferred;
            }

            public Void onCompleted(Response response) throws Exception {
                LOG.debug("Request for removeValue() completed for reference {}", (Object)FirebaseRestReferenceImpl.this.referenceUrl);
                return FirebaseRestReferenceImpl.this.handleValueModifiedResponse(response, this.val$deferred, null);
            }
        });
        return deferred.promise();
    }

    @Override
    public Promise<FirebaseRestReference, FirebaseRuntimeException, Void> push() {
        LOG.debug("push() invoked for reference {}", (Object)this.referenceUrl);
        DeferredObject deferred = new DeferredObject();
        AsyncHttpClient.BoundRequestBuilder postRequest = RequestBuilderUtil.createPost(this.asyncHttpClient, this.referenceUrl, this.fbAccessToken, "{}");
        postRequest.execute((AsyncHandler)new AsyncCompletionHandler<Void>((Deferred)deferred){
            final /* synthetic */ Deferred val$deferred;
            {
                this.val$deferred = deferred;
            }

            public Void onCompleted(Response response) throws Exception {
                return FirebaseRestReferenceImpl.this.handleNewReferenceCreatedResponse(response, (Deferred<FirebaseRestReference, FirebaseRuntimeException, Void>)this.val$deferred);
            }
        });
        return deferred.promise();
    }

    @Override
    public FirebaseRestReference getRoot() {
        LOG.debug("getRoot() invoked for reference {}", (Object)this.referenceUrl);
        return new FirebaseRestReferenceImpl(this.asyncHttpClient, this.gson, this.fbBaseUrl, this.fbAccessToken, "");
    }

    @Override
    public FirebaseRestReference getParent() {
        LOG.debug("getParent() invoked for reference {}", (Object)this.referenceUrl);
        return new FirebaseRestReferenceImpl(this.asyncHttpClient, this.gson, this.fbBaseUrl, this.fbAccessToken, PathUtil.getParent(this.path));
    }

    @Override
    public FirebaseRestReference child(String childPath) {
        LOG.debug("child({}) invoked for reference {}", (Object)childPath, (Object)this.referenceUrl);
        return new FirebaseRestReferenceImpl(this.asyncHttpClient, this.gson, this.fbBaseUrl, this.fbAccessToken, PathUtil.concatenatePath(this.path, childPath));
    }

    private <T> Void handleValueModifiedResponse(Response response, Deferred<T, FirebaseRuntimeException, Void> deferred, T value) {
        try {
            this.handleResponse(response, null);
            deferred.resolve(value);
        }
        catch (FirebaseRuntimeException ex) {
            deferred.reject((Object)ex);
        }
        return null;
    }

    private Void handleNewReferenceCreatedResponse(Response response, Deferred<FirebaseRestReference, FirebaseRuntimeException, Void> deferred) throws IOException {
        try {
            LOG.debug("Request for push() completed for reference {}", (Object)this.referenceUrl);
            PushResponse pushResponse = this.handleResponse(response, PushResponse.class);
            deferred.resolve((Object)new FirebaseRestReferenceImpl(this.asyncHttpClient, this.gson, this.fbBaseUrl, this.fbAccessToken, PathUtil.concatenatePath(this.path, pushResponse.getName())));
        }
        catch (FirebaseRuntimeException ex) {
            deferred.reject((Object)ex);
        }
        return null;
    }

    private <T> T handleResponse(Response response, Class<T> clazz) {
        try {
            switch (response.getStatusCode()) {
                case 200: {
                    return (T)(clazz == null ? null : this.gson.fromJson(response.getResponseBody(), clazz));
                }
                case 401: 
                case 403: {
                    LOG.warn("The request to '{}' that violates the Security and Firebase Rules", (Object)this.referenceUrl);
                    throw new FirebaseAccessException(response);
                }
            }
            LOG.error("Unsupported status code: " + response.getStatusCode());
            throw new FirebaseRestException(FirebaseRuntimeException.ErrorCode.UnsupportedStatusCode, response);
        }
        catch (JsonSyntaxException | IOException e) {
            LOG.error(FAILED_TO_PARSE_RESPONSE_BODY_FOR_REQUEST + response.getUri(), e);
            throw new FirebaseRestException(FirebaseRuntimeException.ErrorCode.ResponseDeserializationFailure, FAILED_TO_PARSE_RESPONSE_BODY_FOR_REQUEST + response.getUri(), e);
        }
    }
}

