/*
 * Decompiled with CFR 0.152.
 */
package org.restonfire;

import com.google.gson.Gson;
import com.ning.http.client.AsyncHttpClient;
import org.restonfire.FirebaseRestDatabase;
import org.restonfire.FirebaseRestDatabaseFactory;
import org.restonfire.FirebaseRestDatabaseImpl;
import org.restonfire.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BaseFirebaseRestDatabaseFactory
implements FirebaseRestDatabaseFactory {
    private static final Logger LOG = LoggerFactory.getLogger(BaseFirebaseRestDatabaseFactory.class);
    private final AsyncHttpClient asyncHttpClient;
    private final Gson gson;

    public BaseFirebaseRestDatabaseFactory(AsyncHttpClient asyncHttpClient, Gson gson) {
        this.asyncHttpClient = asyncHttpClient;
        this.gson = gson;
    }

    @Override
    public FirebaseRestDatabase create(String databaseUrl, String firebaseAccessToken) {
        LOG.info("Creating FirebaseRestDatabase for url '{}' {} accessToken", (Object)databaseUrl, (Object)(StringUtil.notNullOrEmpty(firebaseAccessToken) ? "with" : "without"));
        return new FirebaseRestDatabaseImpl(this.asyncHttpClient, this.gson, databaseUrl, firebaseAccessToken);
    }
}

