/*
 * Decompiled with CFR 0.152.
 */
package org.restonfire;

import com.google.gson.Gson;
import com.ning.http.client.AsyncHttpClient;
import org.restonfire.FirebaseRestDatabase;
import org.restonfire.FirebaseRestEventStream;
import org.restonfire.FirebaseRestEventStreamImpl;
import org.restonfire.FirebaseRestReference;
import org.restonfire.FirebaseRestReferenceImpl;
import org.restonfire.FirebaseSecurityRulesReference;
import org.restonfire.FirebaseSecurityRulesReferenceImpl;
import org.restonfire.PathUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FirebaseRestDatabaseImpl
implements FirebaseRestDatabase {
    private static final Logger LOG = LoggerFactory.getLogger(FirebaseRestDatabaseImpl.class);
    private final AsyncHttpClient asyncHttpClient;
    private final Gson gson;
    private final String namespaceUrl;
    private final String firebaseAccessToken;

    FirebaseRestDatabaseImpl(AsyncHttpClient asyncHttpClient, Gson gson, String namespaceUrl, String firebaseAccessToken) {
        this.asyncHttpClient = asyncHttpClient;
        this.gson = gson;
        this.namespaceUrl = PathUtil.normalizePath(namespaceUrl);
        this.firebaseAccessToken = firebaseAccessToken;
    }

    @Override
    public FirebaseRestReference getReference(String path) {
        LOG.info("Creating new FirebaseRestReference for path '{}'", (Object)path);
        return new FirebaseRestReferenceImpl(this.asyncHttpClient, this.gson, this.namespaceUrl, this.firebaseAccessToken, path);
    }

    @Override
    public FirebaseRestEventStream getEventStream(String path) {
        LOG.info("Creating new FirebaseEventStream for path '{}'", (Object)path);
        return new FirebaseRestEventStreamImpl(this.asyncHttpClient, this.gson, this.namespaceUrl, this.firebaseAccessToken, path);
    }

    @Override
    public FirebaseSecurityRulesReference getSecurityRules() {
        LOG.info("Creating new FirebaseSecurityRulesReference");
        return new FirebaseSecurityRulesReferenceImpl(this.asyncHttpClient, this.namespaceUrl, this.firebaseAccessToken);
    }
}

