/*
 * Decompiled with CFR 0.152.
 */
package org.restonfire;

import com.google.gson.Gson;
import com.ning.http.client.AsyncCompletionHandler;
import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.Param;
import com.ning.http.client.Response;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.jdeferred.Deferred;
import org.jdeferred.Promise;
import org.jdeferred.impl.DeferredObject;
import org.restonfire.FirebaseRestQuery;
import org.restonfire.RestUtil;
import org.restonfire.exceptions.FirebaseInvalidStateException;
import org.restonfire.exceptions.FirebaseRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FirebaseRestQueryImpl
implements FirebaseRestQuery {
    private static final Logger LOG = LoggerFactory.getLogger(FirebaseRestQueryImpl.class);
    private static final String ORDER_BY = "orderBy";
    private static final String START_AT = "startAt";
    private static final String END_AT = "endAt";
    private static final String EQUAL_TO = "equalTo";
    private static final String LIMIT_FIRST = "limitToFirst";
    private static final String LIMIT_LAST = "limitToLast";
    private final Gson gson;
    private final String referenceUrl;
    private final AsyncHttpClient.BoundRequestBuilder queryRequest;
    private final Map<String, String> queryParams = new HashMap<String, String>();

    FirebaseRestQueryImpl(Gson gson, AsyncHttpClient.BoundRequestBuilder requestBuilder, String referenceUrl) {
        this.gson = gson;
        this.queryRequest = requestBuilder;
        this.referenceUrl = referenceUrl;
    }

    @Override
    public FirebaseRestQuery startAt(Object val) {
        return this.setParameter(START_AT, val);
    }

    @Override
    public FirebaseRestQuery endAt(Object val) {
        return this.setParameter(END_AT, val);
    }

    @Override
    public FirebaseRestQuery equalTo(Object val) {
        return this.setParameter(EQUAL_TO, val);
    }

    @Override
    public FirebaseRestQuery limitToFirst(int number) {
        return this.setParameter(LIMIT_FIRST, number);
    }

    @Override
    public FirebaseRestQuery limitToLast(int number) {
        return this.setParameter(LIMIT_LAST, number);
    }

    @Override
    public FirebaseRestQuery orderByKey() {
        return this.setParameter(ORDER_BY, "$key");
    }

    @Override
    public FirebaseRestQuery orderByChild(String name) {
        return this.setParameter(ORDER_BY, name);
    }

    @Override
    public FirebaseRestQuery orderByPriority() {
        return this.setParameter(ORDER_BY, "$priority");
    }

    @Override
    public FirebaseRestQuery orderByValue() {
        return this.setParameter(ORDER_BY, "$value");
    }

    @Override
    public void clear() {
        this.queryParams.clear();
    }

    @Override
    public <T> Promise<T, FirebaseRuntimeException, Void> run(final Class<T> clazz) {
        LOG.debug("Running query({}) invoked for reference {}. Filters: {}", new Object[]{clazz, this.referenceUrl, this.gson.toJson(this.queryParams)});
        ArrayList<Param> params = new ArrayList<Param>(this.queryParams.size());
        for (Map.Entry<String, String> entry : this.queryParams.entrySet()) {
            params.add(new Param(entry.getKey(), entry.getValue()));
        }
        if (!params.isEmpty()) {
            this.queryRequest.addQueryParams(params);
        }
        DeferredObject deferred = new DeferredObject();
        this.queryRequest.execute((AsyncHandler)new AsyncCompletionHandler<Void>((Deferred)deferred){
            final /* synthetic */ Deferred val$deferred;
            {
                this.val$deferred = deferred;
            }

            public Void onCompleted(Response response) throws Exception {
                try {
                    LOG.debug("Request for getValue({}) completed", (Object)clazz);
                    Object result = FirebaseRestQueryImpl.this.handleResponse(response, clazz);
                    this.val$deferred.resolve(result);
                }
                catch (FirebaseRuntimeException ex) {
                    this.val$deferred.reject((Object)ex);
                }
                return null;
            }
        });
        return deferred.promise();
    }

    private FirebaseRestQuery setParameter(String key, Object value) {
        if (this.queryParams.containsKey(key)) {
            throw new FirebaseInvalidStateException(FirebaseRuntimeException.ErrorCode.QueryParamAlreadySet, key + " parameter has already been set");
        }
        this.queryParams.put(key, this.gson.toJson(value));
        return this;
    }

    private <T> T handleResponse(Response response, Class<T> clazz) {
        return RestUtil.handleResponse(this.gson, this.referenceUrl, response, clazz);
    }
}

