/*
 * Decompiled with CFR 0.152.
 */
package org.restonfire;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.ning.http.client.AsyncCompletionHandler;
import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.Response;
import org.jdeferred.Deferred;
import org.jdeferred.Promise;
import org.jdeferred.impl.DeferredObject;
import org.restonfire.FirebaseSecurityRulesReference;
import org.restonfire.PathUtil;
import org.restonfire.RequestBuilderUtil;
import org.restonfire.RestUtil;
import org.restonfire.exceptions.FirebaseRuntimeException;
import org.restonfire.responses.FirebaseSecurityRules;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FirebaseSecurityRulesReferenceImpl
implements FirebaseSecurityRulesReference {
    private static final Logger LOG = LoggerFactory.getLogger(FirebaseSecurityRulesReferenceImpl.class);
    private final Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private final AsyncHttpClient asyncHttpClient;
    private final String fbAccessToken;
    private final String referenceUrl;

    FirebaseSecurityRulesReferenceImpl(AsyncHttpClient asyncHttpClient, String fbBaseUrl, String fbAccessToken) {
        this.asyncHttpClient = asyncHttpClient;
        this.fbAccessToken = fbAccessToken;
        this.referenceUrl = PathUtil.concatenatePath(fbBaseUrl, ".settings/rules") + ".json";
    }

    @Override
    public Promise<FirebaseSecurityRules, FirebaseRuntimeException, Void> get() {
        LOG.debug("getValue() invoked for security rules");
        DeferredObject deferred = new DeferredObject();
        AsyncHttpClient.BoundRequestBuilder getRequest = RequestBuilderUtil.createGet(this.asyncHttpClient, this.referenceUrl, this.fbAccessToken);
        getRequest.execute((AsyncHandler)new AsyncCompletionHandler<Void>((Deferred)deferred){
            final /* synthetic */ Deferred val$deferred;
            {
                this.val$deferred = deferred;
            }

            public Void onCompleted(Response response) throws Exception {
                try {
                    LOG.debug("Request for getValue() completed");
                    FirebaseSecurityRules result = FirebaseSecurityRulesReferenceImpl.this.handleResponse(response);
                    this.val$deferred.resolve((Object)result);
                }
                catch (FirebaseRuntimeException ex) {
                    this.val$deferred.reject((Object)ex);
                }
                return null;
            }
        });
        return deferred.promise();
    }

    @Override
    public Promise<FirebaseSecurityRules, FirebaseRuntimeException, Void> set(FirebaseSecurityRules newRules) {
        LOG.debug("setValue() invoked for security rules");
        DeferredObject deferred = new DeferredObject();
        AsyncHttpClient.BoundRequestBuilder putRequest = RequestBuilderUtil.createPut(this.asyncHttpClient, this.referenceUrl, this.fbAccessToken, this.gson.toJson((Object)newRules));
        putRequest.execute((AsyncHandler)new AsyncCompletionHandler<Void>((Deferred)deferred, newRules){
            final /* synthetic */ Deferred val$deferred;
            final /* synthetic */ FirebaseSecurityRules val$newRules;
            {
                this.val$deferred = deferred;
                this.val$newRules = firebaseSecurityRules;
            }

            public Void onCompleted(Response response) throws Exception {
                LOG.debug("Request for setValue() completed");
                return FirebaseSecurityRulesReferenceImpl.this.handleValueModifiedResponse(response, (Deferred<FirebaseSecurityRules, FirebaseRuntimeException, Void>)this.val$deferred, this.val$newRules);
            }
        });
        return deferred.promise();
    }

    private Void handleValueModifiedResponse(Response response, Deferred<FirebaseSecurityRules, FirebaseRuntimeException, Void> deferred, FirebaseSecurityRules value) {
        try {
            this.handleResponse(response);
            deferred.resolve((Object)value);
        }
        catch (FirebaseRuntimeException ex) {
            deferred.reject((Object)ex);
        }
        return null;
    }

    private FirebaseSecurityRules handleResponse(Response response) {
        return RestUtil.handleResponse(this.gson, this.referenceUrl, response, FirebaseSecurityRules.class);
    }
}

