/*
 * Decompiled with CFR 0.152.
 */
package org.restonfire;

final class PathUtil {
    public static final String FORWARD_SLASH = "/";
    private static final String PATH_CANNOT_BE_NULL = "path cannot be null";

    private PathUtil() {
    }

    public static String getParent(String path) {
        if (path == null) {
            throw new IllegalArgumentException(PATH_CANNOT_BE_NULL);
        }
        String normalizedPath = PathUtil.normalizePath(path);
        if (normalizedPath.length() == 0) {
            return null;
        }
        int index = normalizedPath.lastIndexOf(47);
        return index > 0 ? path.substring(0, index) : "";
    }

    public static String concatenatePath(String path, String child) {
        if (path == null) {
            throw new IllegalArgumentException(PATH_CANNOT_BE_NULL);
        }
        String normalizedPath = PathUtil.normalizePath(path);
        String normalizedChild = PathUtil.normalizePath(child);
        return normalizedPath.length() > 0 ? normalizedPath + FORWARD_SLASH + normalizedChild : normalizedChild;
    }

    public static String normalizePath(String path) {
        return path.endsWith(FORWARD_SLASH) ? path.substring(0, path.length() - 1) : path;
    }
}

