/*
 * Decompiled with CFR 0.152.
 */
package org.restonfire;

import com.ning.http.client.AsyncHttpClient;
import org.restonfire.StringUtil;

final class RequestBuilderUtil {
    private RequestBuilderUtil() {
    }

    public static AsyncHttpClient.BoundRequestBuilder createGet(AsyncHttpClient asyncHttpClient, String referenceUrl, String accessToken) {
        AsyncHttpClient.BoundRequestBuilder requestBuilder = asyncHttpClient.prepareGet(referenceUrl);
        return RequestBuilderUtil.addQueryParamsIfApplicable(requestBuilder, accessToken);
    }

    public static AsyncHttpClient.BoundRequestBuilder createPost(AsyncHttpClient asyncHttpClient, String referenceUrl, String accessToken, String body) {
        AsyncHttpClient.BoundRequestBuilder requestBuilder = asyncHttpClient.preparePost(referenceUrl).setBody(body);
        return RequestBuilderUtil.addQueryParamsIfApplicable(requestBuilder, accessToken);
    }

    public static AsyncHttpClient.BoundRequestBuilder createPatch(AsyncHttpClient asyncHttpClient, String referenceUrl, String accessToken, String body) {
        AsyncHttpClient.BoundRequestBuilder requestBuilder = asyncHttpClient.preparePatch(referenceUrl).setBody(body);
        return RequestBuilderUtil.addQueryParamsIfApplicable(requestBuilder, accessToken);
    }

    public static AsyncHttpClient.BoundRequestBuilder createPut(AsyncHttpClient asyncHttpClient, String referenceUrl, String accessToken, String body) {
        AsyncHttpClient.BoundRequestBuilder requestBuilder = asyncHttpClient.preparePut(referenceUrl).setBody(body);
        return RequestBuilderUtil.addQueryParamsIfApplicable(requestBuilder, accessToken);
    }

    public static AsyncHttpClient.BoundRequestBuilder createDelete(AsyncHttpClient asyncHttpClient, String referenceUrl, String accessToken) {
        AsyncHttpClient.BoundRequestBuilder requestBuilder = asyncHttpClient.prepareDelete(referenceUrl);
        return RequestBuilderUtil.addQueryParamsIfApplicable(requestBuilder, accessToken);
    }

    private static AsyncHttpClient.BoundRequestBuilder addQueryParamsIfApplicable(AsyncHttpClient.BoundRequestBuilder requestBuilder, String accessToken) {
        if (StringUtil.notNullOrEmpty(accessToken)) {
            return requestBuilder.addQueryParam("auth", accessToken);
        }
        return requestBuilder;
    }
}

