/*
 * Decompiled with CFR 0.152.
 */
package org.restonfire;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.ning.http.client.Response;
import java.io.IOException;
import org.restonfire.exceptions.FirebaseAccessException;
import org.restonfire.exceptions.FirebaseRestException;
import org.restonfire.exceptions.FirebaseRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class RestUtil {
    private static final Logger LOG = LoggerFactory.getLogger(RestUtil.class);
    private static final String FAILED_TO_PARSE_RESPONSE_BODY_FOR_REQUEST = "Failed to parse responses body for request: ";

    private RestUtil() {
    }

    public static <T> T handleResponse(Gson gson, String referenceUrl, Response response, Class<T> clazz) {
        try {
            switch (response.getStatusCode()) {
                case 200: {
                    return (T)(clazz == null ? null : gson.fromJson(response.getResponseBody(), clazz));
                }
                case 401: 
                case 403: {
                    LOG.warn("The request to '{}' that violates the Security and Firebase Rules", (Object)referenceUrl);
                    throw new FirebaseAccessException(response);
                }
            }
            LOG.error("Unsupported status code ({}), body: {}", (Object)response.getStatusCode(), (Object)response.getResponseBody());
            throw new FirebaseRestException(FirebaseRuntimeException.ErrorCode.UnsupportedStatusCode, response);
        }
        catch (JsonSyntaxException | IOException e) {
            LOG.error(FAILED_TO_PARSE_RESPONSE_BODY_FOR_REQUEST + response.getUri(), e);
            throw new FirebaseRestException(FirebaseRuntimeException.ErrorCode.ResponseDeserializationFailure, FAILED_TO_PARSE_RESPONSE_BODY_FOR_REQUEST + response.getUri(), e);
        }
    }
}

