/*
 * Decompiled with CFR 0.152.
 */
package com.github.janssk1.maven.plugin.graph;

import com.github.janssk1.maven.plugin.graph.ArtifactResolver;
import com.github.janssk1.maven.plugin.graph.DependencyOptions;
import com.github.janssk1.maven.plugin.graph.GraphBuilder;
import com.github.janssk1.maven.plugin.graph.domain.Artifact;
import com.github.janssk1.maven.plugin.graph.domain.ArtifactDependency;
import com.github.janssk1.maven.plugin.graph.domain.ArtifactIdentifier;
import com.github.janssk1.maven.plugin.graph.domain.ArtifactRevisionIdentifier;
import com.github.janssk1.maven.plugin.graph.graph.Graph;
import com.github.janssk1.maven.plugin.graph.graph.Vertex;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.logging.Log;

public class BreadthFirstGraphBuilder
implements GraphBuilder {
    private static final DependencyAttributeRetriever VERSION = new DependencyAttributeRetriever(){

        @Override
        public String getAttributeValue(ArtifactDependency dep) {
            return dep.getId().getVersion();
        }
    };
    private final ArtifactResolver artifactResolver;
    private final Log logger;

    public BreadthFirstGraphBuilder(Log logger, ArtifactResolver artifactResolver) {
        this.logger = logger;
        this.artifactResolver = artifactResolver;
    }

    private void getAllDependencies(Vertex vertex, DependencyOptions options) {
        LinkedList<ArtifactToResolve> artifactQueue = new LinkedList<ArtifactToResolve>();
        artifactQueue.add(new ArtifactToResolve(vertex, null, 0, null, null, new NearestDependencySet(), options));
        while (!artifactQueue.isEmpty()) {
            ArtifactToResolve artifactToResolve = (ArtifactToResolve)artifactQueue.poll();
            artifactToResolve.print();
            Vertex v = artifactToResolve.vertex;
            if (v.getArtifact() != null) continue;
            Artifact dependent = this.artifactResolver.resolveArtifact(v.getArtifactIdentifier());
            v.setArtifact(dependent);
            for (ArtifactDependency artifactDependency : dependent.getDependencyManagerDependencies()) {
                artifactToResolve.dependencyMgnt.put(artifactDependency.getId().getArtifactIdentifier(), artifactDependency);
            }
            List<ArtifactDependency> artifactDependencyList = dependent.getDependencies();
            for (ArtifactDependency dependency : artifactDependencyList) {
                ArtifactToResolve toResolve = artifactToResolve.createDependency(dependency);
                if (toResolve == null) continue;
                artifactQueue.add(toResolve);
            }
        }
    }

    @Override
    public Graph buildGraph(ArtifactRevisionIdentifier artifact, DependencyOptions options) {
        Graph graph = new Graph(artifact);
        this.getAllDependencies(graph.getRoot(), options);
        return graph;
    }

    private class NearestDependencySet {
        private final Map<ArtifactIdentifier, String> idToVersionMap = new HashMap<ArtifactIdentifier, String>();

        private NearestDependencySet() {
        }

        public ArtifactDependency getNearest(ArtifactDependency dependency, String scope) {
            ArtifactRevisionIdentifier id = dependency.getId();
            ArtifactIdentifier artifactId = id.getArtifactIdentifier();
            String nearestVersion = this.idToVersionMap.get(artifactId);
            ArtifactDependency newDep = new ArtifactDependency(new ArtifactRevisionIdentifier(id.getArtifactId(), id.getGroupId(), nearestVersion, id.getClassifier()), scope);
            newDep.setOptional(dependency.isOptional());
            return newDep;
        }

        public void add(ArtifactIdentifier identifier, String version) {
            if (!this.idToVersionMap.containsKey(identifier)) {
                this.idToVersionMap.put(identifier, version);
            }
        }
    }

    private static interface DependencyAttributeRetriever {
        public String getAttributeValue(ArtifactDependency var1);
    }

    private class ArtifactToResolve {
        private final Vertex vertex;
        private final int depth;
        private final ArtifactDependency incoming;
        private final String incomingScope;
        private final ArtifactToResolve parent;
        private final NearestDependencySet nearestDependencySet;
        private final Map<ArtifactIdentifier, ArtifactDependency> dependencyMgnt = new HashMap<ArtifactIdentifier, ArtifactDependency>();
        private final DependencyOptions options;

        private ArtifactToResolve(Vertex vertex, ArtifactToResolve parent, int depth, ArtifactDependency incoming, String incomingScope, NearestDependencySet nearestDependencySet, DependencyOptions options) {
            this.vertex = vertex;
            this.parent = parent;
            this.depth = depth;
            this.incoming = incoming;
            this.nearestDependencySet = nearestDependencySet;
            this.options = options;
            this.incomingScope = incomingScope;
        }

        public void print() {
            StringBuilder offset = new StringBuilder();
            for (int i = 0; i < this.depth; ++i) {
                offset.append("\t");
            }
            BreadthFirstGraphBuilder.this.logger.debug((CharSequence)MessageFormat.format(offset + "Visiting {0}, current depth = {1}", this.vertex.getArtifactIdentifier(), this.depth));
        }

        private String getScope(ArtifactDependency dep, String scope) {
            if (scope.equals("compile")) {
                ArtifactToResolve parent = this.parent;
                while (parent != null) {
                    ArtifactDependency overriden = parent.dependencyMgnt.get(dep.getId().getArtifactIdentifier());
                    if (overriden != null && "provided".equals(overriden.getScope())) {
                        return "provided";
                    }
                    parent = parent.parent;
                }
            }
            return scope;
        }

        public ArtifactToResolve createDependency(ArtifactDependency dependency) {
            String incomingScope = this.getIncomingDependencyScope();
            String scope = this.getScope(dependency, dependency.getScope());
            String transitiveScope = this.getTransitiveScope(scope, incomingScope);
            if (transitiveScope != null && !this.isOptionalOrExcluded(dependency, transitiveScope)) {
                this.nearestDependencySet.add(dependency.getId().getArtifactIdentifier(), this.getOverriddenDependencyValue(dependency, VERSION));
                ArtifactDependency nearestDependency = this.nearestDependencySet.getNearest(dependency, scope);
                Vertex depVertex = this.vertex.addDependency(nearestDependency.getId(), scope, dependency);
                return new ArtifactToResolve(depVertex, this, this.depth + 1, dependency, transitiveScope, this.nearestDependencySet, this.options);
            }
            return null;
        }

        private String getTransitiveScope(String scope, String parentScope) {
            if (parentScope != null) {
                if (scope.equals("provided") || scope.equals("test")) {
                    if (this.options.isIncludeAllTransitiveDependencies()) {
                        return scope;
                    }
                    return null;
                }
                if (parentScope.equals("runtime") || parentScope.equals("provided") || parentScope.equals("test")) {
                    return parentScope;
                }
            }
            return scope;
        }

        private boolean isOptionalOrExcluded(ArtifactDependency artifactDependency, String scope) {
            return this.options.getGraphType().isExcluded(scope) || "system".equals(scope) || artifactDependency.isOptional() || this.isExcluded(artifactDependency.getId().getArtifactIdentifier());
        }

        private boolean isExcluded(ArtifactIdentifier artifactIdentifier) {
            return this.incoming != null && (this.incoming.getExclusions().contains(artifactIdentifier) || this.parent.isExcluded(artifactIdentifier));
        }

        private String getIncomingDependencyScope() {
            return this.incomingScope;
        }

        private String getOverriddenDependencyValue(ArtifactDependency dep, DependencyAttributeRetriever attribute) {
            String value = this.parent != null ? this.parent.getOverriddenDependencyValue(dep.getId().getArtifactIdentifier(), attribute) : null;
            return value != null ? value : attribute.getAttributeValue(dep);
        }

        private String getOverriddenDependencyValue(ArtifactIdentifier artifactId, DependencyAttributeRetriever attribute) {
            String scope;
            if (this.parent != null && (scope = this.parent.getOverriddenDependencyValue(artifactId, attribute)) != null) {
                return scope;
            }
            ArtifactDependency override = this.dependencyMgnt.get(artifactId);
            return override != null ? attribute.getAttributeValue(override) : null;
        }
    }
}

