/*
 * Decompiled with CFR 0.152.
 */
package com.github.janssk1.maven.plugin.graph;

import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DependencyOptions {
    private static Pattern REPORTS_PATTERN = Pattern.compile("([A-Z]+)(-TRANSITIVE)?");
    private final GraphType graphType;
    private final boolean includeAllTransitiveDependencies;

    public static List<DependencyOptions> parseReportDefinitions(String reportsString) {
        LinkedList<DependencyOptions> reportDefinitions = new LinkedList<DependencyOptions>();
        try {
            Matcher matcher = REPORTS_PATTERN.matcher(reportsString);
            while (matcher.find()) {
                String scope = matcher.group(1);
                GraphType type = GraphType.valueOf(scope);
                boolean transitive = matcher.group(2) != null;
                DependencyOptions option = new DependencyOptions(type, transitive);
                reportDefinitions.add(option);
            }
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException("Unable to parse report definitions: " + reportsString, e);
        }
        return reportDefinitions;
    }

    public DependencyOptions(GraphType type, boolean includeAllTransitiveDependencies) {
        this.graphType = type;
        this.includeAllTransitiveDependencies = includeAllTransitiveDependencies;
    }

    public GraphType getGraphType() {
        return this.graphType;
    }

    public boolean isIncludeAllTransitiveDependencies() {
        return this.includeAllTransitiveDependencies;
    }

    public static enum GraphType {
        PACKAGE("test", "runtime", "provided"),
        COMPILE("test", "runtime"),
        TEST(new String[0]),
        RUNTIME("test");

        private Set<String> excludedScopes = new HashSet<String>();

        private GraphType(String ... excludedScopes) {
            this.excludedScopes.addAll(Arrays.asList(excludedScopes));
        }

        public boolean isExcluded(String scope) {
            return this.excludedScopes.contains(scope);
        }
    }
}

