/*
 * Decompiled with CFR 0.152.
 */
package com.github.janssk1.maven.plugin.graph;

import com.github.janssk1.maven.plugin.graph.ArtifactResolver;
import com.github.janssk1.maven.plugin.graph.BreadthFirstGraphBuilder;
import com.github.janssk1.maven.plugin.graph.DependencyOptions;
import com.github.janssk1.maven.plugin.graph.MavenArtifactResolver;
import com.github.janssk1.maven.plugin.graph.RenderOptions;
import com.github.janssk1.maven.plugin.graph.domain.ArtifactRevisionIdentifier;
import com.github.janssk1.maven.plugin.graph.graph.Graph;
import com.github.janssk1.maven.plugin.graph.graphml.GraphMLGenerator;
import com.github.janssk1.maven.plugin.graph.graphml.SizeVertexRenderer;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProjectBuilder;

public class GraphMojo
extends AbstractMojo {
    private String reports;
    private MavenProjectBuilder mavenProjectBuilder;
    private ArtifactFactory artifactFactory;
    private String groupId;
    private String artifactId;
    private String version;
    private File outputDirectory;
    private ArtifactRepository localRepository;

    public void execute() throws MojoExecutionException {
        this.getLog().info((CharSequence)("Using graph.reports=" + this.reports));
        List<DependencyOptions> reportDefinitions = DependencyOptions.parseReportDefinitions(this.reports);
        MavenArtifactResolver artifactResolver = new MavenArtifactResolver(this.getLog(), this.localRepository, this.artifactFactory, this.mavenProjectBuilder);
        for (DependencyOptions reportDefinition : reportDefinitions) {
            this.buildGraph(artifactResolver, reportDefinition);
        }
    }

    private void buildGraph(ArtifactResolver artifactResolver, DependencyOptions options) throws MojoExecutionException {
        BreadthFirstGraphBuilder graphBuilder = new BreadthFirstGraphBuilder(this.getLog(), artifactResolver);
        Graph graph = graphBuilder.buildGraph(new ArtifactRevisionIdentifier(this.artifactId, this.groupId, this.version), options);
        GraphMLGenerator graphSerializer = new GraphMLGenerator();
        try {
            this.outputDirectory.mkdirs();
            File file = new File(this.outputDirectory, this.artifactId + "-" + this.version + "-" + (Object)((Object)options.getGraphType()) + (options.isIncludeAllTransitiveDependencies() ? "-TRANSITIVE" : "") + "-deps.graphml");
            graphSerializer.serialize(graph, new FileWriter(file), new RenderOptions().setVertexRenderer(new SizeVertexRenderer()));
            this.getLog().info((CharSequence)("Created dependency graph in " + file));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Can't write to file", (Exception)e);
        }
    }
}

