/*
 * Decompiled with CFR 0.152.
 */
package com.github.janssk1.maven.plugin.graph;

import com.github.janssk1.maven.plugin.graph.ArtifactResolver;
import com.github.janssk1.maven.plugin.graph.MavenHelper;
import com.github.janssk1.maven.plugin.graph.domain.Artifact;
import com.github.janssk1.maven.plugin.graph.domain.ArtifactImpl;
import com.github.janssk1.maven.plugin.graph.domain.ArtifactRevisionIdentifier;
import com.github.janssk1.maven.plugin.graph.domain.MockArtifact;
import java.io.File;
import java.util.Collections;
import java.util.List;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Relocation;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;

public class MavenArtifactResolver
implements ArtifactResolver {
    private final Log logger;
    private final ArtifactRepository localRepository;
    private final ArtifactFactory artifactFactory;
    private final MavenProjectBuilder mavenProjectBuilder;
    private static final String POM_TYPE = "pom";

    public MavenArtifactResolver(Log logger, ArtifactRepository localRepository, ArtifactFactory artifactFactory, MavenProjectBuilder mavenProjectBuilder) {
        this.logger = logger;
        this.localRepository = localRepository;
        this.artifactFactory = artifactFactory;
        this.mavenProjectBuilder = mavenProjectBuilder;
    }

    private MavenProject getMavenProject(ArtifactRevisionIdentifier artifactIdentifier) throws ProjectBuildingException {
        this.logger.debug((CharSequence)("Fetching artifact " + artifactIdentifier));
        org.apache.maven.artifact.Artifact artifact = this.artifactFactory.createArtifact(artifactIdentifier.getGroupId(), artifactIdentifier.getArtifactId(), artifactIdentifier.getVersion(), "compile", POM_TYPE);
        return this.mavenProjectBuilder.buildFromRepository(artifact, Collections.emptyList(), this.localRepository, false);
    }

    @Override
    public Artifact resolveArtifact(ArtifactRevisionIdentifier identifier) {
        try {
            MavenProject mavenProject = this.getMavenProject(identifier);
            return this.createArtifact(identifier, mavenProject);
        }
        catch (ProjectBuildingException e) {
            this.logger.warn((CharSequence)("Ignoring dependencies of unknown artifact " + identifier));
            this.logger.debug((Throwable)e);
            return new MockArtifact();
        }
    }

    private void configureArtifact(ArtifactImpl artifact, MavenProject mavenProject) {
        artifact.getDependencyManagerDependencies().clear();
        if (mavenProject.getDependencyManagement() != null) {
            List dependencies = mavenProject.getDependencyManagement().getDependencies();
            for (Dependency dependency : dependencies) {
                artifact.getDependencyManagerDependencies().add(MavenHelper.createArtifactDependency(dependency));
            }
        }
    }

    private Artifact createArtifact(ArtifactRevisionIdentifier id, MavenProject mavenProject) {
        ArtifactImpl artifact = new ArtifactImpl(mavenProject);
        File path = this.getArtifactFile(id, mavenProject);
        long fileLength = path.length();
        artifact.setSize(fileLength);
        artifact.setDependencies(MavenHelper.resolveDependencies(mavenProject));
        this.configureArtifact(artifact, mavenProject);
        return artifact;
    }

    private File getArtifactFile(ArtifactRevisionIdentifier id, MavenProject mavenProject) {
        id = this.applyRelocation(id, mavenProject);
        org.apache.maven.artifact.Artifact mainArtifact = mavenProject.getArtifact();
        MyArtifactHandler artifactHandler = new MyArtifactHandler(mainArtifact.getArtifactHandler());
        mainArtifact = new DefaultArtifact(id.getArtifactIdentifier().getGroupId(), id.getArtifactIdentifier().getArtifactId(), VersionRange.createFromVersion((String)id.getVersion()), mainArtifact.getScope(), mainArtifact.getType(), id.getClassifier(), (ArtifactHandler)artifactHandler);
        String relativePath = this.localRepository.pathOf(mainArtifact);
        return new File(this.localRepository.getBasedir(), relativePath);
    }

    private ArtifactRevisionIdentifier applyRelocation(ArtifactRevisionIdentifier id, MavenProject mavenProject) {
        Relocation relocation;
        if (mavenProject.getDistributionManagement() != null && (relocation = mavenProject.getDistributionManagement().getRelocation()) != null) {
            String groupId = relocation.getGroupId() != null ? relocation.getGroupId() : id.getGroupId();
            String artifactId = relocation.getArtifactId() != null ? relocation.getArtifactId() : id.getArtifactId();
            String version = relocation.getVersion() != null ? relocation.getVersion() : id.getVersion();
            return new ArtifactRevisionIdentifier(artifactId, groupId, version, id.getClassifier());
        }
        return id;
    }

    private static class MyArtifactHandler
    implements ArtifactHandler {
        private final ArtifactHandler originalHandler;

        public MyArtifactHandler(ArtifactHandler originalHandler) {
            this.originalHandler = originalHandler;
        }

        public String getExtension() {
            String extension = this.originalHandler.getExtension();
            if (extension.equals("bundle")) {
                extension = "jar";
            }
            return extension;
        }

        public String getDirectory() {
            return this.originalHandler.getDirectory();
        }

        public String getClassifier() {
            return this.originalHandler.getClassifier();
        }

        public String getPackaging() {
            return this.originalHandler.getPackaging();
        }

        public boolean isIncludesDependencies() {
            return this.originalHandler.isIncludesDependencies();
        }

        public String getLanguage() {
            return this.originalHandler.getLanguage();
        }

        public boolean isAddedToClasspath() {
            return this.originalHandler.isAddedToClasspath();
        }
    }
}

