/*
 * Decompiled with CFR 0.152.
 */
package com.github.janssk1.maven.plugin.graph;

import com.github.janssk1.maven.plugin.graph.domain.ArtifactDependency;
import com.github.janssk1.maven.plugin.graph.domain.ArtifactIdentifier;
import com.github.janssk1.maven.plugin.graph.domain.ArtifactRevisionIdentifier;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Exclusion;
import org.apache.maven.project.MavenProject;

class MavenHelper {
    MavenHelper() {
    }

    public static List<ArtifactDependency> resolveDependencies(MavenProject model) {
        ArrayList<ArtifactDependency> dependencies = new ArrayList<ArtifactDependency>(model.getDependencies().size());
        for (Dependency d : model.getDependencies()) {
            dependencies.add(MavenHelper.createArtifactDependency(d));
        }
        return dependencies;
    }

    public static ArtifactDependency createArtifactDependency(Dependency d) {
        ArtifactDependency dependency = new ArtifactDependency(new ArtifactRevisionIdentifier(d), d.getScope());
        dependency.setClassifier(d.getClassifier());
        dependency.setOptional(d.isOptional());
        for (Exclusion ex : d.getExclusions()) {
            ArtifactIdentifier id = new ArtifactIdentifier(ex.getArtifactId(), ex.getGroupId());
            dependency.getExclusions().add(id);
        }
        return dependency;
    }
}

