/*
 * Decompiled with CFR 0.152.
 */
package com.github.janssk1.maven.plugin.graph.domain;

public class ArtifactIdentifier
implements Cloneable {
    private final String artifactId;
    private final String groupId;
    private final String classifier;

    public ArtifactIdentifier(String artifactId, String groupId) {
        this(artifactId, groupId, null);
    }

    public ArtifactIdentifier(String artifactId, String groupId, String classifier) {
        this.artifactId = artifactId;
        this.groupId = groupId;
        this.classifier = classifier;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getClassifier() {
        return this.classifier;
    }

    private String createStringRepresentation() {
        return this.getGroupId() + ':' + this.getArtifactId() + (this.classifier != null ? ':' + this.classifier : "");
    }

    public String toString() {
        return this.createStringRepresentation();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ArtifactIdentifier) {
            ArtifactIdentifier tmp = (ArtifactIdentifier)obj;
            return this.createStringRepresentation().equals(tmp.createStringRepresentation());
        }
        return false;
    }

    public int hashCode() {
        return this.createStringRepresentation().hashCode();
    }
}

