/*
 * Decompiled with CFR 0.152.
 */
package com.github.janssk1.maven.plugin.graph.domain;

import com.github.janssk1.maven.plugin.graph.domain.ArtifactIdentifier;
import org.apache.maven.model.Dependency;

public class ArtifactRevisionIdentifier {
    private final ArtifactIdentifier artifactIdentifier;
    private final String version;

    public ArtifactRevisionIdentifier(ArtifactIdentifier artifactIdentifier, String version) {
        this.artifactIdentifier = artifactIdentifier;
        this.version = version;
    }

    public ArtifactRevisionIdentifier(String artifactId, String groupId, String version) {
        this(artifactId, groupId, version, null);
    }

    public ArtifactRevisionIdentifier(String artifactId, String groupId, String version, String classifier) {
        this(new ArtifactIdentifier(artifactId, groupId, classifier), version);
    }

    public ArtifactRevisionIdentifier(Dependency dep) {
        this(dep.getArtifactId(), dep.getGroupId(), dep.getVersion(), dep.getClassifier());
    }

    public ArtifactIdentifier getArtifactIdentifier() {
        return this.artifactIdentifier;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArtifactRevisionIdentifier that = (ArtifactRevisionIdentifier)o;
        return this.artifactIdentifier.equals(that.artifactIdentifier) && this.version.equals(that.version);
    }

    public int hashCode() {
        int result = this.artifactIdentifier.hashCode();
        result = 31 * result + this.version.hashCode();
        return result;
    }

    public String toString() {
        return this.artifactIdentifier.toString() + ":" + this.version;
    }

    public String getGroupId() {
        return this.artifactIdentifier.getGroupId();
    }

    public String getArtifactId() {
        return this.artifactIdentifier.getArtifactId();
    }

    public String getClassifier() {
        return this.artifactIdentifier.getClassifier();
    }
}

