/*
 * Decompiled with CFR 0.152.
 */
package com.github.janssk1.maven.plugin.graph.graph;

import com.github.janssk1.maven.plugin.graph.domain.ArtifactRevisionIdentifier;
import com.github.janssk1.maven.plugin.graph.graph.Vertex;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class Graph {
    private final Map<ArtifactRevisionIdentifier, Vertex> vertices = new HashMap<ArtifactRevisionIdentifier, Vertex>();
    private Vertex root;

    public Graph(ArtifactRevisionIdentifier root) {
        this.root = new Vertex(this, root);
        this.vertices.put(root, this.root);
    }

    public Vertex getRoot() {
        return this.root;
    }

    public Collection<Vertex> getVertices() {
        return this.vertices.values();
    }

    public Vertex findOrCreate(ArtifactRevisionIdentifier artifactId) {
        Vertex vertex = this.vertices.get(artifactId);
        if (vertex == null) {
            vertex = new Vertex(this, artifactId);
            this.vertices.put(artifactId, vertex);
        }
        return vertex;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        this.root.toString(buffer, 0);
        return buffer.toString();
    }
}

