/*
 * Decompiled with CFR 0.152.
 */
package com.github.janssk1.maven.plugin.graph.graph;

import com.github.janssk1.maven.plugin.graph.domain.Artifact;
import com.github.janssk1.maven.plugin.graph.domain.ArtifactDependency;
import com.github.janssk1.maven.plugin.graph.domain.ArtifactRevisionIdentifier;
import com.github.janssk1.maven.plugin.graph.graph.Edge;
import com.github.janssk1.maven.plugin.graph.graph.Graph;
import java.util.LinkedList;
import java.util.List;

public class Vertex {
    private final ArtifactRevisionIdentifier artifactIdentifier;
    private final List<Edge> edges = new LinkedList<Edge>();
    private Artifact artifact;
    private final Graph graph;

    Vertex(Graph graph, ArtifactRevisionIdentifier artifactIdentifier) {
        this.artifactIdentifier = artifactIdentifier;
        this.graph = graph;
    }

    public List<Edge> getEdges() {
        return this.edges;
    }

    public ArtifactRevisionIdentifier getArtifactIdentifier() {
        return this.artifactIdentifier;
    }

    public Artifact getArtifact() {
        return this.artifact;
    }

    public void setArtifact(Artifact artifact) {
        this.artifact = artifact;
    }

    public Vertex addDependency(ArtifactRevisionIdentifier nearest, String scope, ArtifactDependency original) {
        Vertex target = this.graph.findOrCreate(nearest);
        Edge e = new Edge(original, this, target, scope);
        this.edges.add(e);
        return target;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        this.toString(buffer, 0);
        return buffer.toString();
    }

    public void toString(StringBuffer buffer, int indent) {
        this.addIndent(indent, buffer);
        buffer.append(this.artifactIdentifier.toString()).append("\n");
        for (Edge edge : this.edges) {
            edge.to.toString(buffer, indent + 1);
        }
    }

    private void addIndent(int indent, StringBuffer res) {
        for (int i = 0; i < indent; ++i) {
            res.append("\t");
        }
    }
}

