/*
 * Decompiled with CFR 0.152.
 */
package com.github.janssk1.maven.plugin.graph.graphml;

import com.github.janssk1.maven.plugin.graph.GraphSerializer;
import com.github.janssk1.maven.plugin.graph.RenderOptions;
import com.github.janssk1.maven.plugin.graph.graph.Edge;
import com.github.janssk1.maven.plugin.graph.graph.Graph;
import com.github.janssk1.maven.plugin.graph.graph.Vertex;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.util.List;

public class GraphMLGenerator
implements GraphSerializer {
    private static String encode(String text) {
        if (text == null) {
            text = "";
        }
        return text.replaceAll("[<]", "&lt;").replaceAll("[>]", "&gt;").replaceAll("[:]", "\n:");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serialize(Graph graph, Writer writer, RenderOptions options) throws IOException {
        Builder gen = new Builder(writer);
        try {
            gen.beginGraph(graph.getRoot().getArtifactIdentifier().toString());
            for (Vertex vertex : graph.getVertices()) {
                RenderOptions.VertexInfo vertexInfo = options.getVertexRenderer().renderVertex(vertex);
                gen.beginLeafNode("" + vertex.getArtifactIdentifier().toString(), GraphMLGenerator.encode(vertexInfo.label), "#" + Integer.toHexString(vertexInfo.color.getRGB() & 0xFFFFFF));
                gen.endLeafNode();
            }
            for (Vertex vertex : graph.getVertices()) {
                List<Edge> edges = vertex.getEdges();
                for (Edge edge : edges) {
                    String declaredVersion = edge.originalDependency.getId().getVersion();
                    String actualVersion = edge.to.getArtifactIdentifier().getVersion();
                    String edgeLabel = edge.originalDependency.getScope();
                    if (!declaredVersion.equals(actualVersion)) {
                        edgeLabel = edgeLabel + " (" + declaredVersion + ")";
                    }
                    gen.edge("" + edge.from.getArtifactIdentifier(), "" + edge.to.getArtifactIdentifier(), edgeLabel);
                }
            }
            gen.endGraph();
        }
        finally {
            writer.close();
        }
    }

    private class Builder {
        private static final String TMPL_BASE = "com/github.janssk1/maven/plugin/graph/graphml";
        private final Writer out;

        public Builder(Writer out) {
            this.out = out;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String fetch(BufferedReader in) throws IOException {
            String str;
            StringBuilder sb = new StringBuilder();
            try {
                while ((str = in.readLine()) != null) {
                    sb.append(str);
                    sb.append("\n");
                }
            }
            finally {
                in.close();
            }
            str = sb.toString();
            return str;
        }

        private String fetchTemplate(String tmplName, String name) throws IOException {
            return this.fetchTemplate(tmplName, name, "#FFCC00");
        }

        private String fetchTemplate(String tmplName, String name, String color) throws IOException {
            InputStream is = this.getClass().getClassLoader().getResourceAsStream("com/github.janssk1/maven/plugin/graph/graphml/" + tmplName);
            String text = this.fetch(new BufferedReader(new InputStreamReader(is)));
            if (name != null) {
                text = text.replaceAll("@NAME@", name);
            }
            if (color != null) {
                text = text.replaceAll("@COLOR@", color);
            }
            return text;
        }

        private void beginGraph(String id) throws IOException {
            this.out.write(this.fetchTemplate("head.tmpl", null));
            this.out.write("<graph id='" + id + "' edgedefault='undirected'>");
        }

        private void endGraph() throws IOException {
            this.out.write("</graph>\n");
            this.out.write("</graphml>\n");
        }

        private void beginLeafNode(String id, String name, String color) throws IOException {
            this.out.write("<node id='" + id + "'>");
            this.out.write(this.fetchTemplate("simplenode.tmpl", name, color));
        }

        private void beginLeafNode(String id, String name) throws IOException {
            this.out.write("<node id='" + id + "'>");
            this.out.write(this.fetchTemplate("simplenode.tmpl", name));
        }

        private void endLeafNode() throws IOException {
            this.out.write("</node>\n");
        }

        private void edge(String fromId, String toId, String name) throws IOException {
            this.edge(null, fromId, toId, name);
        }

        private void edge(String id, String fromId, String toId, String name) throws IOException {
            String idx = "";
            if (id != null) {
                idx = "id='" + id + "' ";
            }
            this.out.write("<edge " + idx + "source='" + fromId + "' target='" + toId + "'>");
            this.out.write(this.fetchTemplate("edgenode.tmpl", name));
            this.out.write("</edge>\n");
        }
    }
}

