/*
 * Decompiled with CFR 0.152.
 */
package com.github.janssk1.maven.plugin.graph.graphml;

import com.github.janssk1.maven.plugin.graph.RenderOptions;
import com.github.janssk1.maven.plugin.graph.graph.Vertex;
import com.github.janssk1.maven.plugin.graph.graphml.ColorRange;
import com.github.janssk1.maven.plugin.graph.graphml.FixedIntervalColorRange;
import java.awt.Color;

public class SizeVertexRenderer
implements RenderOptions.VertexRenderer {
    private static final int K = 1000;
    private final ColorRange colorRange;

    private static ColorRange createColorRange() {
        Color[] colors = new Color[240];
        for (int i = 0; i < colors.length; ++i) {
            colors[i] = new Color(255, colors.length - i, colors.length - i);
        }
        return new FixedIntervalColorRange(0, 2000000, colors);
    }

    public SizeVertexRenderer() {
        this(SizeVertexRenderer.createColorRange());
    }

    public SizeVertexRenderer(ColorRange colorRange) {
        this.colorRange = colorRange;
    }

    @Override
    public RenderOptions.VertexInfo renderVertex(Vertex vertex) {
        long jarSize = vertex.getArtifact() != null ? vertex.getArtifact().getSize() : 0L;
        Color color = this.colorRange.getColor(jarSize);
        return new RenderOptions.VertexInfo(vertex.getArtifactIdentifier().toString() + " (" + jarSize + ")", color);
    }
}

