/*
 * Decompiled with CFR 0.152.
 */
package com.github.janssk1.maven.plugin.graph.graphml;

import com.github.janssk1.maven.plugin.graph.graphml.ColorRange;
import java.awt.Color;
import java.util.SortedSet;
import java.util.TreeSet;

public class StaticColorRange
implements ColorRange {
    private SortedSet<ColorPair> colorPairs = new TreeSet<ColorPair>();

    public StaticColorRange addColor(Color c, int max) {
        this.colorPairs.add(new ColorPair(c, max));
        return this;
    }

    @Override
    public Color getColor(long value) {
        for (ColorPair colorPair : this.colorPairs) {
            if (value > (long)colorPair.max) continue;
            return colorPair.color;
        }
        return this.colorPairs.last().color;
    }

    private static class ColorPair
    implements Comparable<ColorPair> {
        private final Color color;
        private final int max;

        private ColorPair(Color color, int max) {
            this.color = color;
            this.max = max;
        }

        @Override
        public int compareTo(ColorPair o) {
            return new Integer(this.max).compareTo(o.max);
        }
    }
}

