/*
 * Decompiled with CFR 0.152.
 */
package nyaya.gen;

import java.io.Serializable;
import java.util.Random;
import nyaya.gen.GenCtx$;
import nyaya.gen.GenSize;
import nyaya.gen.SampleNumber$;
import nyaya.gen.SeedCtx;
import nyaya.gen.SeedCtx$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.runtime.RichInt$;

public final class GenCtx {
    private final Random rnd;
    private final int thread;
    private int lastBit;
    private int intBits;
    private int sampleNumber;
    private GenSize genSize;
    private Function0 nextSize;
    private Function0 nextSizeMin1;

    public static GenCtx apply(GenSize genSize, int n) {
        return GenCtx$.MODULE$.apply(genSize, n);
    }

    public GenCtx(Random rnd, GenSize _genSize, int thread) {
        this.rnd = rnd;
        this.thread = thread;
        this.lastBit = 32;
        this.intBits = 0;
        this.sampleNumber = SampleNumber$.MODULE$.apply(0);
        this.genSize = _genSize;
        this.nextSize = this._nextSize();
        this.nextSizeMin1 = this._nextSizeMin1();
    }

    public Random rnd() {
        return this.rnd;
    }

    public int thread() {
        return this.thread;
    }

    public SeedCtx seedCtx() {
        return SeedCtx$.MODULE$.apply(this.thread(), this.sampleNumber);
    }

    /*
     * WARNING - void declaration
     */
    public <A> A sample(Function1 g) {
        void var2_2;
        Object a = g.apply((Object)this);
        this.incSampleNumber();
        return var2_2;
    }

    public void incSampleNumber() {
        this.sampleNumber = SampleNumber$.MODULE$.apply(this.sampleNumber + 1);
    }

    public boolean nextBit() {
        if (this.lastBit == 32) {
            this.lastBit = 0;
            this.intBits = this.rnd().nextInt();
        } else {
            ++this.lastBit;
        }
        return (this.intBits & 1 << this.lastBit) == 0;
    }

    public void setSeed(long seed) {
        this.rnd().setSeed(seed);
        this.lastBit = 32;
    }

    public int shiftLeft(int i) {
        int j = i << 1;
        return this.nextBit() ? j : j | 1;
    }

    public int nextInt2() {
        return this.nextBit() ? 0 : 1;
    }

    public int nextInt4() {
        return this.shiftLeft(this.nextInt2());
    }

    public int nextInt8() {
        return this.shiftLeft(this.nextInt4());
    }

    public int nextInt16() {
        return this.shiftLeft(this.nextInt8());
    }

    public Function0<Object> nextSize() {
        return this.nextSize;
    }

    public void nextSize_$eq(Function0<Object> x$1) {
        this.nextSize = x$1;
    }

    public Function0<Object> nextSizeMin1() {
        return this.nextSizeMin1;
    }

    public void nextSizeMin1_$eq(Function0<Object> x$1) {
        this.nextSizeMin1 = x$1;
    }

    public int fixGenSize(int n) {
        return RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(this.genSize.value()), n);
    }

    public int fixGenSize1(int n) {
        return RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(this.genSize.value()), n)), 1);
    }

    public void setGenSize(GenSize gs) {
        this.genSize = gs;
        this.nextSize_$eq(this._nextSize());
        this.nextSizeMin1_$eq(this._nextSizeMin1());
    }

    public Function0<Object> _nextSize() {
        Function0 & Serializable intersect;
        if (this.genSize.value() == 0) {
            intersect = (Function0 & Serializable)() -> 0;
        } else {
            int n = this.genSize.value() + 1;
            intersect = (Function0 & Serializable)() -> this.rnd().nextInt(n);
        }
        return intersect;
    }

    public Function0<Object> _nextSizeMin1() {
        return this.genSize.value() <= 1 ? (Function0 & Serializable)() -> 1 : (Function0 & Serializable)() -> this.rnd().nextInt(this.genSize.value()) + 1;
    }
}

